/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.findUsages;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.PsiNamedElementUsageGroupBase;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.impl.FileStructureGroupRuleProvider;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageGroupingRule;
import com.jetbrains.python.psi.PyClass;
import org.jetbrains.annotations.NotNull;

public class PyClassGroupingRuleProvider
implements FileStructureGroupRuleProvider {
    public UsageGroupingRule getUsageGroupingRule(Project project) {
        return new PyClassGroupingRule();
    }

    private static class PyClassGroupingRule
    implements UsageGroupingRule {
        private PyClassGroupingRule() {
        }

        public UsageGroup groupUsage(@NotNull Usage usage) {
            if (usage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/jetbrains/python/findUsages/PyClassGroupingRuleProvider$PyClassGroupingRule", "groupUsage"));
            }
            if (!(usage instanceof PsiElementUsage)) {
                return null;
            }
            PsiElement psiElement = ((PsiElementUsage)usage).getElement();
            PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyClass.class);
            if (pyClass != null) {
                return new PsiNamedElementUsageGroupBase((PsiNamedElement)pyClass);
            }
            return null;
        }
    }
}

