/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.findUsages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class PyClassFindUsagesHandler
extends FindUsagesHandler {
    private final PyClass myClass;

    public PyClassFindUsagesHandler(@NotNull PyClass psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/findUsages/PyClassFindUsagesHandler", "<init>"));
        }
        super(psiElement);
        this.myClass = psiElement;
    }

    @Override
    @NotNull
    public PsiElement[] getSecondaryElements() {
        PyFunction initMethod = this.myClass.findMethodByName("__init__", false);
        if (initMethod != null) {
            PsiElement[] psiElementArray = new PsiElement[]{initMethod};
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PyClassFindUsagesHandler", "getSecondaryElements"));
            }
            return psiElementArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PyClassFindUsagesHandler", "getSecondaryElements"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    protected boolean isSearchForTextOccurencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/findUsages/PyClassFindUsagesHandler", "isSearchForTextOccurencesAvailable"));
        }
        return true;
    }

    @Override
    protected Collection<String> getStringsToSearch(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/findUsages/PyClassFindUsagesHandler", "getStringsToSearch"));
        }
        if (element instanceof PyFunction && "__init__".equals(((PyFunction)element).getName())) {
            return Collections.emptyList();
        }
        return super.getStringsToSearch(element);
    }
}

