/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor.selectWord;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.ArrayList;
import java.util.List;

public class PyStatementSelectionHandler
extends ExtendWordSelectionHandlerBase {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PyStringLiteralExpression || e instanceof PyCallExpression || e instanceof PyStatement || e instanceof PyStatementList;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        PsiElement prevSibling;
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        PsiElement endElement = e;
        while (endElement.getLastChild() != null) {
            endElement = endElement.getLastChild();
        }
        if (endElement instanceof PsiWhiteSpace && (prevSibling = endElement.getPrevSibling()) != null) {
            endElement = prevSibling;
        }
        result.addAll(PyStatementSelectionHandler.expandToWholeLine(editorText, new TextRange(e.getTextRange().getStartOffset(), endElement.getTextRange().getEndOffset())));
        return result;
    }
}

