/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.editor.PythonDocCommentUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import org.jetbrains.annotations.NotNull;

public class PythonSpaceHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/editor/PythonSpaceHandler", "charTyped"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/editor/PythonSpaceHandler", "charTyped"));
        }
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        if (c == ' ' && codeInsightSettings.JAVADOC_STUB_ON_ENTER) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement element = file.findElementAt(offset);
            if (element == null && offset > 1) {
                element = file.findElementAt(offset - 2);
            }
            if (element == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            int expectedStringStart = editor.getCaretModel().getOffset() - 4;
            if (PythonDocCommentUtil.atDocCommentStart(element, expectedStringStart)) {
                PyElement klass;
                PythonDocumentationProvider provider = new PythonDocumentationProvider();
                PyFunction fun = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
                PsiElement parent = element.getParent();
                if (fun != null) {
                    String docStub = provider.generateDocumentationContentStub(fun, false);
                    if ((docStub = docStub + parent.getText().substring(0, 3)).length() != 0) {
                        editor.getDocument().insertString(editor.getCaretModel().getOffset(), (CharSequence)docStub);
                        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                        if (module == null) {
                            return TypedHandlerDelegate.Result.CONTINUE;
                        }
                        PyDocumentationSettings documentationSettings = PyDocumentationSettings.getInstance(module);
                        if (!documentationSettings.myDocStringFormat.equals("Plain")) {
                            editor.getCaretModel().moveCaretRelatively(100, 1, false, false, false);
                        }
                        return TypedHandlerDelegate.Result.STOP;
                    }
                }
                if ((klass = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyClass.class, PyFile.class})) != null) {
                    editor.getDocument().insertString(editor.getCaretModel().getOffset(), (CharSequence)PythonDocCommentUtil.generateDocForClass((PsiElement)klass, parent.getText().substring(0, 3)));
                    return TypedHandlerDelegate.Result.STOP;
                }
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }
}

