/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.SplitLineAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.editor.PythonDocCommentUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDictCompExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGeneratorExpression;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySetCompExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonEnterHandler
extends EnterHandlerDelegateAdapter {
    private int myPostprocessShift = 0;
    public static final Class[] IMPLICIT_WRAP_CLASSES = new Class[]{PySequenceExpression.class, PyDictLiteralExpression.class, PyParenthesizedExpression.class, PyArgumentList.class, PyParameterList.class};
    private static final Class[] WRAPPABLE_CLASSES = new Class[]{PsiComment.class, PyParenthesizedExpression.class, PyListCompExpression.class, PyDictCompExpression.class, PySetCompExpression.class, PyDictLiteralExpression.class, PySetLiteralExpression.class, PyListLiteralExpression.class, PyArgumentList.class, PyParameterList.class, PyFunction.class, PySliceExpression.class, PySubscriptionExpression.class, PyGeneratorExpression.class};

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        PsiElement prevElement;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/editor/PythonEnterHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/editor/PythonEnterHandler", "preprocessEnter"));
        }
        if (caretOffset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffset", "com/jetbrains/python/editor/PythonEnterHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/jetbrains/python/editor/PythonEnterHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/python/editor/PythonEnterHandler", "preprocessEnter"));
        }
        int offset = (Integer)caretOffset.get();
        if (editor instanceof EditorWindow) {
            file = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
            editor = InjectedLanguageUtil.getTopLevelEditor(editor);
            offset = editor.getCaretModel().getOffset();
        }
        if (!(file instanceof PyFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Boolean isSplitLine = (Boolean)DataManager.getInstance().loadFromDataContext(dataContext, SplitLineAction.SPLIT_LINE_KEY);
        if (isSplitLine != null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document doc = editor.getDocument();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(doc);
        PsiElement element = file.findElementAt(offset);
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        if (codeInsightSettings.JAVADOC_STUB_ON_ENTER) {
            int expectedStringStart;
            PsiElement comment = element;
            if (comment == null && offset != 0) {
                comment = file.findElementAt(offset - 1);
            }
            if (PythonDocCommentUtil.atDocCommentStart(comment, expectedStringStart = editor.getCaretModel().getOffset() - 3)) {
                PythonEnterHandler.insertDocStringStub(editor, comment);
                return EnterHandlerDelegate.Result.Continue;
            }
        }
        if (element == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement elementParent = element.getParent();
        if (element.getNode().getElementType() == PyTokenTypes.LPAR) {
            elementParent = elementParent.getParent();
        }
        if (elementParent instanceof PyParenthesizedExpression || elementParent instanceof PyGeneratorExpression) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (offset > 0 && !PyTokenTypes.STRING_NODES.contains(element.getNode().getElementType()) && (prevElement = file.findElementAt(offset - 1)) == element) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (PyTokenTypes.TRIPLE_NODES.contains(element.getNode().getElementType()) || element.getNode().getElementType() == PyTokenTypes.DOCSTRING) {
            return EnterHandlerDelegate.Result.Continue;
        }
        prevElement = file.findElementAt(offset - 1);
        PyStringLiteralExpression string = (PyStringLiteralExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PyStringLiteralExpression.class, (boolean)false);
        if (string != null && prevElement != null && PyTokenTypes.STRING_NODES.contains(prevElement.getNode().getElementType()) && string.getTextOffset() < offset && !(element.getNode() instanceof PsiWhiteSpace)) {
            boolean isEscapedBackslash;
            String stringText = element.getText();
            int prefixLength = PyStringLiteralExpressionImpl.getPrefixLength(stringText);
            if (string.getTextOffset() + prefixLength >= offset) {
                return EnterHandlerDelegate.Result.Continue;
            }
            String pref = element.getText().substring(0, prefixLength);
            String quote = element.getText().substring(prefixLength, prefixLength + 1);
            boolean nextIsBackslash = "\\".equals(doc.getText(TextRange.create((int)(offset - 1), (int)offset)));
            boolean isEscapedQuote = quote.equals(doc.getText(TextRange.create((int)offset, (int)(offset + 1)))) && nextIsBackslash;
            boolean bl = isEscapedBackslash = "\\".equals(doc.getText(TextRange.create((int)(offset - 2), (int)(offset - 1)))) && nextIsBackslash;
            if (nextIsBackslash && !isEscapedQuote && !isEscapedBackslash) {
                return EnterHandlerDelegate.Result.Continue;
            }
            StringBuilder replacementString = new StringBuilder();
            this.myPostprocessShift = prefixLength + quote.length();
            if (PsiTreeUtil.getParentOfType((PsiElement)string, (Class[])IMPLICIT_WRAP_CLASSES) != null) {
                replacementString.append(quote).append(pref).append(quote);
                doc.insertString(offset, (CharSequence)replacementString);
                caretOffset.set((Object)((Integer)caretOffset.get() + 1));
                return EnterHandlerDelegate.Result.Continue;
            }
            if (isEscapedQuote) {
                replacementString.append(quote);
                caretOffset.set((Object)((Integer)caretOffset.get() + 1));
            }
            replacementString.append(quote).append(" \\").append(pref);
            if (!isEscapedQuote) {
                replacementString.append(quote);
            }
            doc.insertString(offset, (CharSequence)replacementString.toString());
            caretOffset.set((Object)((Integer)caretOffset.get() + 3));
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!PyCodeInsightSettings.getInstance().INSERT_BACKSLASH_ON_WRAP) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return PythonEnterHandler.checkInsertBackslash(file, caretOffset, dataContext, offset, doc);
    }

    private static EnterHandlerDelegate.Result checkInsertBackslash(PsiFile file, Ref<Integer> caretOffset, DataContext dataContext, int offset, Document doc) {
        boolean autoWrapInProgress;
        boolean bl = autoWrapInProgress = DataManager.getInstance().loadFromDataContext(dataContext, AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY) != null;
        if (PythonEnterHandler.needInsertBackslash(file, offset, autoWrapInProgress)) {
            doc.insertString(offset, (CharSequence)"\\");
            caretOffset.set((Object)((Integer)caretOffset.get() + 1));
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    public static boolean needInsertBackslash(PsiFile file, int offset, boolean autoWrapInProgress) {
        PsiElement beforeCaret;
        if (offset > 0 && (beforeCaret = file.findElementAt(offset - 1)) instanceof PsiWhiteSpace && beforeCaret.getText().indexOf(92) >= 0) {
            return false;
        }
        PsiElement atCaret = file.findElementAt(offset);
        if (atCaret == null) {
            return false;
        }
        ASTNode nodeAtCaret = atCaret.getNode();
        return PythonEnterHandler.needInsertBackslash(nodeAtCaret, autoWrapInProgress);
    }

    public static boolean needInsertBackslash(ASTNode nodeAtCaret, boolean autoWrapInProgress) {
        PsiElement next;
        PsiElement statementAfter;
        PsiElement statementBefore = PythonEnterHandler.findStatementBeforeCaret(nodeAtCaret);
        if (statementBefore != (statementAfter = PythonEnterHandler.findStatementAfterCaret(nodeAtCaret))) {
            return false;
        }
        if (statementBefore == null) {
            return false;
        }
        if (PsiTreeUtil.hasErrorElements((PsiElement)statementBefore) && !autoWrapInProgress) {
            return false;
        }
        if (PythonEnterHandler.inFromImportParentheses(statementBefore, nodeAtCaret.getTextRange().getStartOffset())) {
            return false;
        }
        PsiElement wrappableBefore = PythonEnterHandler.findWrappable(nodeAtCaret, true);
        PsiElement wrappableAfter = PythonEnterHandler.findWrappable(nodeAtCaret, false);
        if (!(wrappableBefore instanceof PsiComment)) {
            while (wrappableBefore != null && (next = PsiTreeUtil.getParentOfType((PsiElement)wrappableBefore, (Class[])WRAPPABLE_CLASSES)) != null) {
                wrappableBefore = next;
            }
        }
        if (!(wrappableAfter instanceof PsiComment)) {
            while (wrappableAfter != null && (next = PsiTreeUtil.getParentOfType((PsiElement)wrappableAfter, (Class[])WRAPPABLE_CLASSES)) != null) {
                wrappableAfter = next;
            }
        }
        if (wrappableBefore instanceof PsiComment || wrappableAfter instanceof PsiComment) {
            return false;
        }
        return wrappableAfter == null || wrappableBefore != wrappableAfter;
    }

    private static void insertDocStringStub(Editor editor, PsiElement element) {
        PyElement klass;
        PythonDocumentationProvider provider = new PythonDocumentationProvider();
        PyFunction fun = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (fun != null) {
            String docStub = provider.generateDocumentationContentStub(fun, false);
            if ((docStub = docStub + element.getParent().getText().substring(0, 3)).length() != 0) {
                editor.getDocument().insertString(editor.getCaretModel().getOffset(), (CharSequence)docStub);
                return;
            }
        }
        if ((klass = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyClass.class, PyFile.class})) != null && element != null) {
            editor.getDocument().insertString(editor.getCaretModel().getOffset(), (CharSequence)PythonDocCommentUtil.generateDocForClass((PsiElement)klass, element.getParent().getText().substring(0, 3)));
        }
    }

    @Nullable
    private static PsiElement findWrappable(ASTNode nodeAtCaret, boolean before) {
        PsiElement wrappable;
        PsiElement psiElement = wrappable = before ? PythonEnterHandler.findBeforeCaret(nodeAtCaret, WRAPPABLE_CLASSES) : PythonEnterHandler.findAfterCaret(nodeAtCaret, WRAPPABLE_CLASSES);
        if (wrappable == null) {
            PsiElement emptyTuple;
            PsiElement psiElement2 = emptyTuple = before ? PythonEnterHandler.findBeforeCaret(nodeAtCaret, PyTupleExpression.class) : PythonEnterHandler.findAfterCaret(nodeAtCaret, PyTupleExpression.class);
            if (emptyTuple != null && emptyTuple.getNode().getFirstChildNode().getElementType() == PyTokenTypes.LPAR) {
                wrappable = emptyTuple;
            }
        }
        return wrappable;
    }

    @Nullable
    private static PsiElement findStatementBeforeCaret(ASTNode node) {
        return PythonEnterHandler.findBeforeCaret(node, PyStatement.class);
    }

    @Nullable
    private static PsiElement findStatementAfterCaret(ASTNode node) {
        return PythonEnterHandler.findAfterCaret(node, PyStatement.class);
    }

    private static PsiElement findBeforeCaret(ASTNode atCaret, Class<? extends PsiElement> ... classes) {
        while (atCaret != null) {
            if ((atCaret = TreeUtil.prevLeaf(atCaret)) == null || atCaret.getElementType() == TokenType.WHITE_SPACE) continue;
            return PythonEnterHandler.getNonStrictParentOfType(atCaret.getPsi(), classes);
        }
        return null;
    }

    private static PsiElement findAfterCaret(ASTNode atCaret, Class<? extends PsiElement> ... classes) {
        while (atCaret != null) {
            if (atCaret.getElementType() != TokenType.WHITE_SPACE) {
                return PythonEnterHandler.getNonStrictParentOfType(atCaret.getPsi(), classes);
            }
            atCaret = TreeUtil.nextLeaf(atCaret);
        }
        return null;
    }

    @Nullable
    private static <T extends PsiElement> T getNonStrictParentOfType(@NotNull PsiElement element, Class<? extends T> ... classes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/editor/PythonEnterHandler", "getNonStrictParentOfType"));
        }
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/jetbrains/python/editor/PythonEnterHandler", "getNonStrictParentOfType"));
        }
        for (PsiElement run = element; run != null; run = run.getParent()) {
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(run)) continue;
                return (T)run;
            }
            if (run instanceof PsiFile || run instanceof PyStatementList) break;
        }
        return null;
    }

    private static boolean inFromImportParentheses(PsiElement statement, int offset) {
        if (!(statement instanceof PyFromImportStatement)) {
            return false;
        }
        PyFromImportStatement fromImportStatement = (PyFromImportStatement)statement;
        PsiElement leftParen = fromImportStatement.getLeftParen();
        return leftParen != null && offset >= leftParen.getTextRange().getEndOffset();
    }

    @Override
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/editor/PythonEnterHandler", "postProcessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/editor/PythonEnterHandler", "postProcessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/python/editor/PythonEnterHandler", "postProcessEnter"));
        }
        if (this.myPostprocessShift > 0) {
            editor.getCaretModel().moveCaretRelatively(this.myPostprocessShift, 0, false, false, false);
            this.myPostprocessShift = 0;
        }
        return super.postProcessEnter(file, editor, dataContext);
    }
}

