/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;

public class PythonDocCommentUtil {
    private PythonDocCommentUtil() {
    }

    public static boolean atDocCommentStart(PsiElement element, int offset) {
        PyDocStringOwner docStringOwner;
        PyElement func;
        PyStringLiteralExpression string = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyStringLiteralExpression.class);
        if (string != null && (func = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyFunction.class, PyClass.class, PyFile.class})) != null && (docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PyDocStringOwner.class)) == func) {
            PyStringLiteralExpression str = docStringOwner.getDocStringExpression();
            String text = element.getText();
            if (str != null && text.equals(str.getText()) && (text.startsWith("\"\"\"") || text.startsWith("'''")) && offset == str.getTextRange().getStartOffset()) {
                PsiErrorElement error = (PsiErrorElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)string, PsiErrorElement.class);
                if (error != null) {
                    return true;
                }
                error = (PsiErrorElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)string.getParent(), PsiErrorElement.class);
                if (error != null) {
                    return true;
                }
                if (text.length() < 6 || !text.endsWith("\"\"\"") && !text.endsWith("'''")) {
                    return true;
                }
            }
        }
        return false;
    }

    public static String generateDocForClass(PsiElement klass, String suffix) {
        String[] spaces;
        PsiWhiteSpace whitespace;
        String ws = "\n";
        if (klass instanceof PyClass && (whitespace = (PsiWhiteSpace)PsiTreeUtil.getPrevSiblingOfType((PsiElement)((PyClass)klass).getStatementList(), PsiWhiteSpace.class)) != null && (spaces = whitespace.getText().split("\n")).length > 1) {
            ws = ws + spaces[1];
        }
        return ws + suffix;
    }

    public static String removeParamFromDocstring(String text, String prefix, String paramName) {
        StringBuilder newText = new StringBuilder();
        String[] lines = LineTokenizer.tokenize((CharSequence)text, (boolean)true);
        boolean skipNext = false;
        for (String line : lines) {
            if (line.contains(prefix)) {
                String[] subLines = line.split(" ");
                boolean lookNext = false;
                boolean add = true;
                for (String s : subLines) {
                    String tmp;
                    String trimmedLine = s.trim();
                    if (trimmedLine.equals(prefix + "param") || trimmedLine.equals(prefix + "type")) {
                        lookNext = true;
                    }
                    if (!lookNext || !trimmedLine.endsWith(":") || !paramName.equals(tmp = trimmedLine.substring(0, trimmedLine.length() - 1))) continue;
                    lookNext = false;
                    skipNext = true;
                    add = false;
                }
                if (!add) continue;
                newText.append(line);
                skipNext = false;
                continue;
            }
            if (skipNext && !line.contains("\"\"\"") && !line.contains("'''")) continue;
            newText.append(line);
        }
        return newText.toString();
    }
}

