/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonCopyPasteProcessor
implements CopyPastePreProcessor {
    @Override
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @Override
    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if (!CodeInsightSettings.getInstance().INDENT_TO_CARET_ON_PASTE || file.getLanguage() != PythonLanguage.getInstance()) {
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/editor/PythonCopyPasteProcessor", "preprocessOnPaste"));
            }
            return string;
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
        final boolean useTabs = codeStyleSettings.useTabCharacter((FileType)PythonFileType.INSTANCE);
        int indentSize = codeStyleSettings.getIndentSize((FileType)PythonFileType.INSTANCE);
        CharFilter NOT_INDENT_FILTER = new CharFilter(){

            public boolean accept(char ch) {
                return useTabs ? ch != '\t' : ch != ' ';
            }
        };
        String indentChar = useTabs ? "\t" : " ";
        CaretModel caretModel = editor.getCaretModel();
        SelectionModel selectionModel = editor.getSelectionModel();
        final Document document = editor.getDocument();
        int caretOffset = selectionModel.getSelectionStart() != selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretModel.getOffset();
        int lineNumber = document.getLineNumber(caretOffset);
        final int lineStartOffset = PythonCopyPasteProcessor.getLineStartSafeOffset(document, lineNumber);
        final int lineEndOffset = document.getLineEndOffset(lineNumber);
        PsiElement element = file.findElementAt(caretOffset);
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PyStringLiteralExpression.class) != null) {
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/editor/PythonCopyPasteProcessor", "preprocessOnPaste"));
            }
            return string;
        }
        text = PythonCopyPasteProcessor.addLeadingSpaces(text, NOT_INDENT_FILTER, indentSize, indentChar);
        int firstLineIndent = StringUtil.findFirst((CharSequence)text, (CharFilter)NOT_INDENT_FILTER);
        String indentText = PythonCopyPasteProcessor.getIndentText(file, document, caretOffset, lineNumber, firstLineIndent);
        int toRemove = PythonCopyPasteProcessor.calculateIndentToRemove(text, NOT_INDENT_FILTER);
        String toString = document.getText(TextRange.create((int)lineStartOffset, (int)lineEndOffset));
        if (StringUtil.isEmptyOrSpaces((String)indentText) && PythonCopyPasteProcessor.isApplicable(file, text, caretOffset)) {
            caretModel.moveToOffset(lineStartOffset);
            if (StringUtil.isEmptyOrSpaces((String)toString)) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        document.deleteString(lineStartOffset, lineEndOffset);
                    }
                });
            }
            editor.getSelectionModel().setSelection(lineStartOffset, selectionModel.getSelectionEnd());
        }
        List strings = StringUtil.split((String)text, (String)"\n", (boolean)false);
        String newText = "";
        if (StringUtil.isEmptyOrSpaces((String)indentText)) {
            for (String s : strings) {
                newText = newText + indentText + StringUtil.trimStart((String)s, (String)StringUtil.repeat((String)indentChar, (int)toRemove));
            }
        } else {
            newText = text;
        }
        if (PythonCopyPasteProcessor.addLinebreak(text, toString, useTabs) && selectionModel.getSelectionStart() == selectionModel.getSelectionEnd()) {
            newText = newText + "\n";
        }
        String string = newText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/editor/PythonCopyPasteProcessor", "preprocessOnPaste"));
        }
        return string;
    }

    private static String addLeadingSpaces(String text, CharFilter filter, int indentSize, String indentChar) {
        List strings = StringUtil.split((String)text, (String)"\n", (boolean)false);
        if (strings.size() > 1) {
            int firstLineIndent = StringUtil.findFirst((CharSequence)((CharSequence)strings.get(0)), (CharFilter)filter);
            int secondLineIndent = StringUtil.findFirst((CharSequence)((CharSequence)strings.get(1)), (CharFilter)filter);
            int diff = secondLineIndent - firstLineIndent;
            if (diff > indentSize) {
                text = StringUtil.repeat((String)indentChar, (int)(diff - indentSize)) + text;
            }
        }
        return text;
    }

    private static String getIndentText(@NotNull PsiFile file, @NotNull Document document, int caretOffset, int lineNumber, int firstLineIndent) {
        IElementType nonWSType;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/editor/PythonCopyPasteProcessor", "getIndentText"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/python/editor/PythonCopyPasteProcessor", "getIndentText"));
        }
        PsiElement nonWS = PyUtil.findNextAtOffset(file, caretOffset, PsiWhiteSpace.class);
        if (nonWS != null && ((nonWSType = nonWS.getNode().getElementType()) == PyTokenTypes.ELSE_KEYWORD || nonWSType == PyTokenTypes.ELIF_KEYWORD || nonWSType == PyTokenTypes.EXCEPT_KEYWORD || nonWSType == PyTokenTypes.FINALLY_KEYWORD)) {
            nonWS = PyUtil.findNextAtOffset(file, PythonCopyPasteProcessor.getLineStartSafeOffset(document, --lineNumber), PsiWhiteSpace.class);
        }
        int lineStartOffset = PythonCopyPasteProcessor.getLineStartSafeOffset(document, lineNumber);
        String indentText = document.getText(TextRange.create((int)lineStartOffset, (int)caretOffset));
        if (nonWS != null && document.getLineNumber(nonWS.getTextOffset()) == lineNumber) {
            indentText = document.getText(TextRange.create((int)lineStartOffset, (int)nonWS.getTextOffset()));
        } else if (caretOffset == lineStartOffset) {
            String wsText;
            List strings;
            PsiElement ws = file.findElementAt(lineStartOffset);
            if (ws != null && (strings = StringUtil.split((String)(wsText = ws.getText()), (String)"\n")).size() >= 1) {
                indentText = (String)strings.get(0);
            }
            if (indentText.length() == firstLineIndent) {
                return "";
            }
        }
        return indentText;
    }

    private static int calculateIndentToRemove(@NotNull String text, @NotNull CharFilter filter) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/editor/PythonCopyPasteProcessor", "calculateIndentToRemove"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/jetbrains/python/editor/PythonCopyPasteProcessor", "calculateIndentToRemove"));
        }
        List strings = StringUtil.split((String)text, (String)"\n", (boolean)false);
        int minIndent = StringUtil.findFirst((CharSequence)text, (CharFilter)filter);
        for (String s : strings) {
            int indent = StringUtil.findFirst((CharSequence)s, (CharFilter)filter);
            if (indent >= minIndent || StringUtil.isEmptyOrSpaces((String)s)) continue;
            minIndent = indent;
        }
        return minIndent >= 0 ? minIndent : 0;
    }

    private static boolean isApplicable(@NotNull PsiFile file, @NotNull String text, int caretOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/editor/PythonCopyPasteProcessor", "isApplicable"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/editor/PythonCopyPasteProcessor", "isApplicable"));
        }
        boolean useTabs = CodeStyleSettingsManager.getSettings((Project)file.getProject()).useTabCharacter((FileType)PythonFileType.INSTANCE);
        PsiElement nonWS = PyUtil.findNextAtOffset(file, caretOffset, PsiWhiteSpace.class);
        if (nonWS == null || text.endsWith("\n")) {
            return true;
        }
        return PythonCopyPasteProcessor.inStatementList(file, caretOffset) && (text.startsWith(useTabs ? "\t" : " ") || StringUtil.split((String)text, (String)"\n").size() > 1);
    }

    private static boolean inStatementList(@NotNull PsiFile file, int caretOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/editor/PythonCopyPasteProcessor", "inStatementList"));
        }
        PsiElement element = file.findElementAt(caretOffset);
        return PsiTreeUtil.getParentOfType((PsiElement)element, PyStatementList.class) != null || PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class) != null || PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class) != null;
    }

    private static boolean addLinebreak(@NotNull String text, @NotNull String toString, boolean useTabs) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/editor/PythonCopyPasteProcessor", "addLinebreak"));
        }
        if (toString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toString", "com/jetbrains/python/editor/PythonCopyPasteProcessor", "addLinebreak"));
        }
        return (text.startsWith(useTabs ? "\t" : " ") || StringUtil.split((String)text, (String)"\n").size() > 1) && !text.endsWith("\n") && !StringUtil.isEmptyOrSpaces((String)toString);
    }

    public static int getLineStartSafeOffset(Document document, int line) {
        if (line == document.getLineCount()) {
            return document.getTextLength();
        }
        if (line < 0) {
            return 0;
        }
        return document.getLineStartOffset(line);
    }
}

