/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.editorActions.BackspaceHandler;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PythonFileType;

public class PythonBackspaceHandler
extends BackspaceHandlerDelegate {
    private LogicalPosition myTargetPosition;

    public void beforeCharDeleted(char c, PsiFile file, Editor editor) {
        if (PythonFileType.INSTANCE != file.getFileType()) {
            return;
        }
        this.myTargetPosition = BackspaceHandler.getBackspaceUnindentPosition(file, editor);
    }

    public boolean charDeleted(char c, PsiFile file, Editor editor) {
        if (this.myTargetPosition != null) {
            int offset = editor.getCaretModel().getOffset();
            int targetOffset = editor.logicalPositionToOffset(this.myTargetPosition);
            editor.getSelectionModel().setSelection(targetOffset, offset);
            EditorModificationUtil.deleteSelectedText((Editor)editor);
            editor.getCaretModel().moveToLogicalPosition(this.myTargetPosition);
            this.myTargetPosition = null;
            return true;
        }
        return false;
    }
}

