/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.Nullable;

public class PyJoinLinesHandler
implements JoinRawLinesHandlerDelegate {
    public int tryJoinLines(Document document, PsiFile file, int start, int end) {
        return -1;
    }

    public int tryJoinRawLines(Document document, PsiFile file, int start, int end) {
        if (!(file instanceof PyFile)) {
            return -1;
        }
        int i = start;
        CharSequence text = document.getCharsSequence();
        if (i >= 0 && text.charAt(i) == '\n') {
            --i;
        }
        if (i >= 0 && text.charAt(i) == '\\') {
            --i;
        }
        while (i >= 0 && text.charAt(i) == ' ' || text.charAt(i) == '\t') {
            --i;
        }
        if (i < 0) {
            return -1;
        }
        PsiElement left_element = file.findElementAt(i);
        PsiElement right_element = file.findElementAt(end);
        if (left_element != null && right_element != null) {
            IElementType type;
            PyExpression right_expr;
            PyExpression left_expr = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)left_element, PyExpression.class);
            if (left_expr instanceof PsiFile) {
                left_expr = null;
            }
            if ((right_expr = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)right_element, PyExpression.class)) instanceof PsiFile) {
                right_expr = null;
            }
            Joiner[] joiners = new Joiner[]{new OpenBracketJoiner(), new CloseBracketJoiner(), new StringLiteralJoiner(), new StmtJoiner(), new BinaryExprJoiner(), new ListLikeExprJoiner(), new CommentJoiner()};
            Request request = new Request(document, left_element, left_expr, right_element, right_expr);
            for (Joiner joiner : joiners) {
                Result res = joiner.join(request);
                if (res == null) continue;
                int cut_start = i + 1 - res.getCutFromLeft();
                document.deleteString(cut_start, end + res.getCutIntoRight());
                document.insertString(cut_start, (CharSequence)res.getInsert());
                return cut_start + res.getCursorOffset();
            }
            PyExpression leftExpression = request.leftExpr();
            PyExpression rightExpression = request.rightExpr();
            if (request.leftElem() == request.rightElem() && (PyTokenTypes.SINGLE_QUOTED_STRING == (type = request.leftElem().getNode().getElementType()) || PyTokenTypes.SINGLE_QUOTED_UNICODE == type)) {
                if (leftExpression == null) {
                    return -1;
                }
                if (PyJoinLinesHandler.removeBackSlash(document, (PsiElement)leftExpression, false)) {
                    return leftExpression.getTextOffset();
                }
            }
            PyExpression expression = null;
            if (leftExpression != null && rightExpression != null) {
                if (PsiTreeUtil.isAncestor((PsiElement)leftExpression, (PsiElement)rightExpression, (boolean)false)) {
                    expression = leftExpression;
                } else if (PsiTreeUtil.isAncestor((PsiElement)rightExpression, (PsiElement)leftExpression, (boolean)false)) {
                    expression = rightExpression;
                }
                if (expression != null && !(expression instanceof PyStringLiteralExpression) && PyJoinLinesHandler.removeBackSlash(document, (PsiElement)expression, true)) {
                    return expression.getTextOffset();
                }
            }
        }
        return -1;
    }

    private static boolean removeBackSlash(Document document, PsiElement element, boolean trim) {
        String[] substrings = element.getText().split("\n");
        if (substrings.length != 1) {
            StringBuilder replacement = new StringBuilder();
            for (int i = 0; i < substrings.length; ++i) {
                String string = substrings[i];
                if (trim) {
                    string = StringUtil.trimLeading((String)string);
                }
                if (string.trim().endsWith("\\")) {
                    replacement.append(string.substring(0, string.length() - 1));
                } else {
                    replacement.append(string);
                }
                if (i == substrings.length - 1 || element instanceof PyReferenceExpression || element instanceof PyStringLiteralExpression) continue;
                replacement.append(" ");
            }
            document.replaceString(element.getTextOffset(), element.getTextOffset() + element.getTextLength(), (CharSequence)replacement);
            return true;
        }
        return false;
    }

    private static class CommentJoiner
    extends Joiner {
        private CommentJoiner() {
        }

        @Override
        public Result join(Request req) {
            if (req.leftElem() instanceof PsiComment && req.rightElem() instanceof PsiComment) {
                int initial_pos;
                int pos;
                CharSequence text = req.document().getCharsSequence();
                TextRange right_range = req.rightElem().getTextRange();
                int last = right_range.getEndOffset();
                for (pos = initial_pos = right_range.getStartOffset() + 1; pos < last && " \t".indexOf(text.charAt(pos)) >= 0; ++pos) {
                }
                int right = pos - initial_pos + 1;
                return new Result(" ", 0, 0, right);
            }
            return null;
        }
    }

    private static class StringLiteralJoiner
    extends Joiner {
        private StringLiteralJoiner() {
        }

        @Override
        public Result join(Request req) {
            if (req.leftElem() != req.rightElem()) {
                PsiElement parent = req.rightElem().getParent();
                if (req.leftElem().getParent() == parent && parent instanceof PyStringLiteralExpression || req.leftExpr() instanceof PyStringLiteralExpression && req.rightExpr() instanceof PyStringLiteralExpression) {
                    CharSequence text = req.document().getCharsSequence();
                    StrMod left_mod = new StrMod(text, req.leftElem().getTextRange());
                    StrMod right_mod = new StrMod(text, req.rightElem().getTextRange());
                    if (left_mod.isOk() && right_mod.isOk()) {
                        String lquo = left_mod.quote();
                        if (left_mod.equals(right_mod)) {
                            return new Result("", 0, lquo.length(), right_mod.getStartPadding());
                        }
                        if (left_mod.compatibleTo(right_mod) && lquo.length() == 1 && right_mod.quote().length() == 1) {
                            if (!StringLiteralJoiner.containsChar(text, right_mod.getInnerRange(), left_mod.quote().charAt(0))) {
                                int quote_pos = right_mod.getInnerRange().getEndOffset();
                                req.document().replaceString(quote_pos, quote_pos + 1, (CharSequence)left_mod.quote());
                                return new Result("", 0, left_mod.quote().length(), right_mod.getStartPadding());
                            }
                            if (!StringLiteralJoiner.containsChar(text, left_mod.getInnerRange(), right_mod.quote().charAt(0))) {
                                int quote_pos = left_mod.getInnerRange().getStartOffset() - 1;
                                req.document().replaceString(quote_pos, quote_pos + 1, (CharSequence)right_mod.quote());
                                return new Result("", 0, left_mod.quote().length(), right_mod.getStartPadding());
                            }
                        }
                    }
                }
            }
            return null;
        }

        protected static boolean containsChar(CharSequence text, TextRange range, char c) {
            for (int i = range.getStartOffset(); i <= range.getEndOffset(); ++i) {
                if (text.charAt(i) != c) continue;
                return true;
            }
            return false;
        }

        private static class StrMod {
            private final String myPrefix;
            private final boolean myRaw;
            private final String myQuote;
            private final boolean myOk;
            private final TextRange myInnerRange;

            public StrMod(CharSequence text, TextRange range) {
                int pos = range.getStartOffset();
                char c = text.charAt(pos);
                if ("Uu".indexOf(c) > -1 || "Bb".indexOf(c) > -1) {
                    this.myPrefix = String.valueOf(c).toLowerCase();
                    c = text.charAt(++pos);
                } else {
                    this.myPrefix = "";
                }
                if ("Rr".indexOf(c) > -1) {
                    this.myRaw = true;
                    c = text.charAt(++pos);
                } else {
                    this.myRaw = false;
                }
                char quote = c;
                if ("'\"".indexOf(quote) < 0) {
                    this.myInnerRange = null;
                    this.myQuote = "";
                    this.myOk = false;
                    return;
                }
                if (range.getLength() >= 6 && text.charAt(pos + 1) == quote && text.charAt(pos + 2) == quote) {
                    this.myQuote = ((Object)text.subSequence(pos, pos + 3)).toString();
                    if (!this.myQuote.equals(((Object)text.subSequence(range.getEndOffset() - 3, range.getEndOffset())).toString())) {
                        this.myInnerRange = null;
                        this.myOk = false;
                        return;
                    }
                } else {
                    this.myQuote = ((Object)text.subSequence(pos, pos + 1)).toString();
                    if (!this.myQuote.equals(((Object)text.subSequence(range.getEndOffset() - 1, range.getEndOffset())).toString())) {
                        this.myInnerRange = null;
                        this.myOk = false;
                        return;
                    }
                }
                this.myInnerRange = TextRange.from((int)(range.getStartOffset() + this.getStartPadding()), (int)(range.getLength() - this.getStartPadding() - this.quote().length()));
                this.myOk = true;
            }

            public boolean isOk() {
                return this.myOk;
            }

            public String prefix() {
                return this.myPrefix;
            }

            public String quote() {
                return this.myQuote;
            }

            public boolean isRaw() {
                return this.myRaw;
            }

            public boolean equals(Object o) {
                if (o instanceof StrMod) {
                    StrMod other = (StrMod)o;
                    return this.myOk && other.isOk() && this.myRaw == other.isRaw() && this.myPrefix.equals(other.prefix()) && this.myQuote.equals(other.quote());
                }
                return false;
            }

            public int getStartPadding() {
                return this.myQuote.length() + this.myPrefix.length() + (this.myRaw ? 1 : 0);
            }

            public boolean compatibleTo(StrMod other) {
                return this.myOk && other.isOk() && this.myRaw == other.isRaw() && this.myPrefix.equals(other.prefix());
            }

            public TextRange getInnerRange() {
                return this.myInnerRange;
            }
        }
    }

    private static class StmtJoiner
    extends Joiner {
        private StmtJoiner() {
        }

        @Override
        public Result join(Request req) {
            PyStatement right_stmt;
            PyStatement left_stmt = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)req.leftExpr(), PyStatement.class);
            if (left_stmt != null && (right_stmt = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)req.rightExpr(), PyStatement.class)) != null && right_stmt != left_stmt) {
                return new Result("; ", 1);
            }
            return null;
        }
    }

    private static class ListLikeExprJoiner
    extends Joiner {
        private ListLikeExprJoiner() {
        }

        @Override
        public Result join(Request req) {
            boolean left_is_list_like = PyUtil.instanceOf(req.leftExpr(), PyListLiteralExpression.class, PyTupleExpression.class);
            if (left_is_list_like || PyUtil.instanceOf(req.rightExpr(), PyListLiteralExpression.class, PyTupleExpression.class)) {
                String insert = "";
                if (left_is_list_like) {
                    insert = " ";
                }
                return new Result(insert, insert.length());
            }
            return null;
        }
    }

    private static class BinaryExprJoiner
    extends Joiner {
        private BinaryExprJoiner() {
        }

        @Override
        public Result join(Request req) {
            if (req.leftExpr() instanceof PyBinaryExpression || req.rightExpr() instanceof PyBinaryExpression) {
                return new Result(" ", 1);
            }
            return null;
        }
    }

    private static class CloseBracketJoiner
    extends Joiner {
        private static TokenSet CLOSES = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.RBRACKET, PyTokenTypes.RBRACE, PyTokenTypes.RPAR});

        private CloseBracketJoiner() {
        }

        @Override
        public Result join(Request req) {
            if (CLOSES.contains(req.rightElem().getNode().getElementType())) {
                return new Result("", 0);
            }
            return null;
        }
    }

    private static class OpenBracketJoiner
    extends Joiner {
        private static TokenSet OPENS = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.LBRACKET, PyTokenTypes.LBRACE, PyTokenTypes.LPAR});

        private OpenBracketJoiner() {
        }

        @Override
        public Result join(Request req) {
            if (OPENS.contains(req.leftElem().getNode().getElementType())) {
                return new Result("", 0);
            }
            return null;
        }
    }

    private static abstract class Joiner {
        private Joiner() {
        }

        @Nullable
        public abstract Result join(Request var1);
    }

    private static class Request {
        final Document myDocument;
        final PsiElement myLeftElem;
        final PsiElement myRightElem;
        final PyExpression myLeftExpr;
        final PyExpression myRightExpr;

        private Request(Document document, PsiElement leftElem, PyExpression leftExpr, PsiElement rightElem, PyExpression rightExpr) {
            this.myDocument = document;
            this.myLeftElem = leftElem;
            this.myLeftExpr = leftExpr;
            this.myRightElem = rightElem;
            this.myRightExpr = rightExpr;
        }

        public Document document() {
            return this.myDocument;
        }

        public PsiElement leftElem() {
            return this.myLeftElem;
        }

        public PyExpression leftExpr() {
            return this.myLeftExpr;
        }

        public PsiElement rightElem() {
            return this.myRightElem;
        }

        public PyExpression rightExpr() {
            return this.myRightExpr;
        }
    }

    private static class Result {
        final String myInsert;
        final int myOffset;
        final int myCutFromLeft;
        final int myCutIntoRight;

        Result(String insert, int cursorOffset) {
            this.myInsert = insert;
            this.myOffset = cursorOffset;
            this.myCutFromLeft = 0;
            this.myCutIntoRight = 0;
        }

        private Result(String insert, int cursorOffset, int cutFromLeft, int cutIntoRight) {
            this.myCutFromLeft = cutFromLeft;
            this.myCutIntoRight = cutIntoRight;
            this.myInsert = insert;
            this.myOffset = cursorOffset;
        }

        public String getInsert() {
            return this.myInsert;
        }

        public int getCursorOffset() {
            return this.myOffset;
        }

        public int getCutFromLeft() {
            return this.myCutFromLeft;
        }

        public int getCutIntoRight() {
            return this.myCutIntoRight;
        }
    }
}

