/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.editorActions.emacs.EmacsProcessingHandler;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.DocumentUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyEmacsHandler
implements EmacsProcessingHandler {
    private static final TokenSet COMPOUND_STATEMENT_TYPES = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.IF_STATEMENT, PyTokenTypes.IF_KEYWORD, PyTokenTypes.ELIF_KEYWORD, PyTokenTypes.ELSE_KEYWORD, PyElementTypes.WHILE_STATEMENT, PyTokenTypes.WHILE_KEYWORD, PyElementTypes.FOR_STATEMENT, PyTokenTypes.FOR_KEYWORD, PyElementTypes.WITH_STATEMENT, PyTokenTypes.WITH_KEYWORD, PyElementTypes.TRY_EXCEPT_STATEMENT, PyTokenTypes.TRY_KEYWORD, PyTokenTypes.EXCEPT_KEYWORD, PyTokenTypes.FINALLY_KEYWORD, PyElementTypes.FUNCTION_DECLARATION, PyTokenTypes.DEF_KEYWORD, PyElementTypes.CLASS_DECLARATION, PyTokenTypes.CLASS_KEYWORD});

    @Override
    @NotNull
    public EmacsProcessingHandler.Result changeIndent(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        int caretOffset;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/editor/PyEmacsHandler", "changeIndent"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/editor/PyEmacsHandler", "changeIndent"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/editor/PyEmacsHandler", "changeIndent"));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection() || selectionModel.hasBlockSelection()) {
            EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.CONTINUE;
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/editor/PyEmacsHandler", "changeIndent"));
            }
            return result;
        }
        Document document = editor.getDocument();
        int caretLine = document.getLineNumber(caretOffset = editor.getCaretModel().getOffset());
        if (caretLine == 0 || PyEmacsHandler.isLineContainsWhiteSpacesOnlyEmpty(document, caretLine)) {
            EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.CONTINUE;
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/editor/PyEmacsHandler", "changeIndent"));
            }
            return result;
        }
        ChangeIndentContext context = new ChangeIndentContext(project, file, editor, document, caretLine);
        if (PyEmacsHandler.defineSoleIndentIfPossible(context)) {
            EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.STOP;
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/editor/PyEmacsHandler", "changeIndent"));
            }
            return result;
        }
        switch (PyEmacsHandler.tryToIndentToRight(context)) {
            case STOP_SUCCESSFUL: {
                EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.STOP;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/editor/PyEmacsHandler", "changeIndent"));
                }
                return result;
            }
            case STOP_UNSUCCESSFUL: {
                EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.CONTINUE;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/editor/PyEmacsHandler", "changeIndent"));
                }
                return result;
            }
        }
        if (PyEmacsHandler.tryToIndentToLeft(context)) {
            EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.STOP;
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/editor/PyEmacsHandler", "changeIndent"));
            }
            return result;
        }
        EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.CONTINUE;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/editor/PyEmacsHandler", "changeIndent"));
        }
        return result;
    }

    private static boolean defineSoleIndentIfPossible(@NotNull ChangeIndentContext context) {
        int prevLine;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/editor/PyEmacsHandler", "defineSoleIndentIfPossible"));
        }
        for (prevLine = context.targetLine - 1; prevLine >= 0 && PyEmacsHandler.isLineContainsWhiteSpacesOnlyEmpty(context.document, prevLine); --prevLine) {
        }
        if (prevLine < 0) {
            return false;
        }
        int indent = PyEmacsHandler.getLineIndent(context, prevLine);
        int newIndent = -1;
        if (PyEmacsHandler.isLineStartsWithCompoundStatement(context, prevLine)) {
            newIndent = indent + context.getIndentOptions().INDENT_SIZE;
        } else if (indent < PyEmacsHandler.getLineIndent(context, context.targetLine)) {
            newIndent = indent;
        }
        if (newIndent < 0) {
            return false;
        }
        PyEmacsHandler.changeIndent(context, newIndent);
        return true;
    }

    private static ProcessingResult tryToIndentToRight(@NotNull ChangeIndentContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/editor/PyEmacsHandler", "tryToIndentToRight"));
        }
        int targetLineIndent = PyEmacsHandler.getLineIndent(context, context.targetLine);
        List<LineInfo> lineInfos = PyEmacsHandler.collectIndentsGreaterOrEqualToCurrent(context, context.targetLine);
        int newIndent = -1;
        for (int i = lineInfos.size() - 1; i >= 0; --i) {
            LineInfo lineInfo = lineInfos.get(i);
            if (lineInfo.indent == targetLineIndent) continue;
            newIndent = lineInfo.indent;
            break;
        }
        if (newIndent == targetLineIndent || newIndent < 0) {
            return ProcessingResult.CONTINUE;
        }
        PyEmacsHandler.changeIndent(context, newIndent);
        return ProcessingResult.STOP_SUCCESSFUL;
    }

    private static boolean tryToIndentToLeft(@NotNull ChangeIndentContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/editor/PyEmacsHandler", "tryToIndentToLeft"));
        }
        if (context.targetLine == 0 || !PyEmacsHandler.containsNonWhiteSpaceData(context.document, 0, context.targetLine)) {
            PyEmacsHandler.changeIndent(context, 0);
            return false;
        }
        int newIndent = -1;
        for (int line = 0; line < context.targetLine; ++line) {
            if (PyEmacsHandler.isLineContainsWhiteSpacesOnlyEmpty(context.document, line)) continue;
            int indent = PyEmacsHandler.getLineIndent(context, line);
            if (PyEmacsHandler.isLineStartsWithCompoundStatement(context, line)) {
                newIndent = indent;
                break;
            }
            if (newIndent >= 0) continue;
            newIndent = indent;
        }
        if (newIndent < 0) {
            return false;
        }
        PyEmacsHandler.changeIndent(context, newIndent);
        return true;
    }

    private static void changeIndent(@NotNull ChangeIndentContext context, int newIndent) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/editor/PyEmacsHandler", "changeIndent"));
        }
        int caretOffset = context.editor.getCaretModel().getOffset();
        String newIndentString = new IndentInfo(0, newIndent, 0).generateNewWhiteSpace(context.getIndentOptions());
        int start = context.document.getLineStartOffset(context.targetLine);
        int end = DocumentUtil.getFirstNonSpaceCharOffset(context.document, context.targetLine);
        context.editor.getDocument().replaceString(start, end, (CharSequence)newIndentString);
        if (caretOffset > start && caretOffset < end) {
            context.editor.getCaretModel().moveToOffset(start + newIndentString.length());
        }
    }

    private static boolean containsNonWhiteSpaceData(@NotNull Document document, int startLine, int endLine) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/python/editor/PyEmacsHandler", "containsNonWhiteSpaceData"));
        }
        CharSequence text = document.getCharsSequence();
        int start = document.getLineStartOffset(startLine);
        int end = document.getLineStartOffset(endLine);
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n') continue;
            return true;
        }
        return false;
    }

    private static List<LineInfo> collectIndentsGreaterOrEqualToCurrent(@NotNull ChangeIndentContext context, int targetLine) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/editor/PyEmacsHandler", "collectIndentsGreaterOrEqualToCurrent"));
        }
        ArrayList<LineInfo> result = new ArrayList<LineInfo>();
        int targetLineIndent = PyEmacsHandler.getLineIndent(context, targetLine);
        int indentUsedLastTime = Integer.MAX_VALUE;
        for (int i = targetLine - 1; i >= 0 && indentUsedLastTime > targetLineIndent; --i) {
            PsiElement element;
            if (PyEmacsHandler.isLineContainsWhiteSpacesOnlyEmpty(context.document, i)) continue;
            int indent = PyEmacsHandler.getLineIndent(context, i);
            if (indent < targetLineIndent) break;
            if (indent >= indentUsedLastTime || (element = context.file.findElementAt(context.document.getLineStartOffset(i) + indent)) == null) continue;
            ASTNode node = element.getNode();
            result.add(new LineInfo(i, indent, COMPOUND_STATEMENT_TYPES.contains(node.getElementType())));
            indentUsedLastTime = indent;
        }
        return result;
    }

    private static boolean isLineContainsWhiteSpacesOnlyEmpty(@NotNull Document document, int line) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/python/editor/PyEmacsHandler", "isLineContainsWhiteSpacesOnlyEmpty"));
        }
        int start = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        CharSequence text = document.getCharsSequence();
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    private static boolean isLineStartsWithCompoundStatement(@NotNull ChangeIndentContext context, int line) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/editor/PyEmacsHandler", "isLineStartsWithCompoundStatement"));
        }
        PsiElement element = context.file.findElementAt(context.document.getLineStartOffset(line) + PyEmacsHandler.getLineIndent(context, line));
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        return COMPOUND_STATEMENT_TYPES.contains(node.getElementType());
    }

    private static int getLineIndent(@NotNull ChangeIndentContext context, int line) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/editor/PyEmacsHandler", "getLineIndent"));
        }
        int start = context.document.getLineStartOffset(line);
        int end = context.document.getLineEndOffset(line);
        int result = 0;
        CharSequence text = context.document.getCharsSequence();
        block4: for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case ' ': {
                    ++result;
                    continue block4;
                }
                case '\t': {
                    result += context.getIndentOptions().TAB_SIZE;
                    continue block4;
                }
                default: {
                    return result;
                }
            }
        }
        return result;
    }

    private static class ChangeIndentContext {
        @NotNull
        public final Project project;
        @NotNull
        public final PsiFile file;
        @NotNull
        public final Editor editor;
        @NotNull
        public final Document document;
        public final int targetLine;
        private CommonCodeStyleSettings.IndentOptions myIndentOptions;

        private ChangeIndentContext(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor, @NotNull Document document, int targetLine) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/editor/PyEmacsHandler$ChangeIndentContext", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/editor/PyEmacsHandler$ChangeIndentContext", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/editor/PyEmacsHandler$ChangeIndentContext", "<init>"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/python/editor/PyEmacsHandler$ChangeIndentContext", "<init>"));
            }
            this.project = project;
            this.file = file;
            this.editor = editor;
            this.document = document;
            this.targetLine = targetLine;
        }

        public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
            if (this.myIndentOptions == null) {
                CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance((Project)this.project).getCurrentSettings();
                this.myIndentOptions = codeStyleSettings.getIndentOptions(this.file.getFileType());
            }
            return this.myIndentOptions;
        }
    }

    private static class LineInfo {
        public final int line;
        public final int indent;
        public final boolean startsWithCompoundStatement;

        LineInfo(int line, int indent, boolean startsWithCompoundStatement) {
            this.line = line;
            this.indent = indent;
            this.startsWithCompoundStatement = startsWithCompoundStatement;
        }

        public String toString() {
            return "line=" + this.line + ", indent=" + this.indent + ", compound=" + this.startsWithCompoundStatement;
        }
    }

    private static enum ProcessingResult {
        STOP_SUCCESSFUL,
        STOP_UNSUCCESSFUL,
        CONTINUE;

    }
}

