/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Arrays;

public class BaseQuoteHandler
extends SimpleTokenSetQuoteHandler {
    private final char[] ourAutoClosingChars;

    public BaseQuoteHandler(TokenSet tokenSet, char[] autoClosingChars) {
        super(tokenSet);
        this.ourAutoClosingChars = autoClosingChars;
        Arrays.sort(this.ourAutoClosingChars);
    }

    @Override
    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        Document document = iterator.getDocument();
        if (document == null) {
            return false;
        }
        CharSequence text = document.getCharsSequence();
        if (offset + 1 >= text.length() || Arrays.binarySearch(this.ourAutoClosingChars, text.charAt(offset + 1)) >= 0) {
            int start;
            char the_quote = text.charAt(offset);
            if (offset >= 2 && text.charAt(offset - 1) == the_quote && text.charAt(offset - 2) == the_quote && (offset < 3 || text.charAt(offset - 3) != the_quote)) {
                return false;
            }
            if (super.isOpeningQuote(iterator, offset)) {
                return true;
            }
            if (this.myLiteralTokenSet.contains(iterator.getTokenType()) && offset - (start = iterator.getStart()) <= 2 && BaseQuoteHandler.getLiteralStartOffset(text, start) == offset) {
                return true;
            }
        }
        return false;
    }

    private static int getLiteralStartOffset(CharSequence text, int start) {
        char c = Character.toUpperCase(text.charAt(start));
        if (c == 'U' || c == 'B') {
            c = Character.toUpperCase(text.charAt(++start));
        }
        if (c == 'R') {
            ++start;
        }
        return start;
    }

    @Override
    protected boolean isNonClosedLiteral(HighlighterIterator iterator, CharSequence chars) {
        if (BaseQuoteHandler.getLiteralStartOffset(chars, iterator.getStart()) >= iterator.getEnd() - 1) {
            return true;
        }
        return chars.charAt(iterator.getEnd() - 1) != '\"' && chars.charAt(iterator.getEnd() - 1) != '\'';
    }

    @Override
    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        IElementType tokenType = iterator.getTokenType();
        if (this.myLiteralTokenSet.contains(tokenType)) {
            int start = iterator.getStart();
            int end = iterator.getEnd();
            if (end - start >= 1 && offset == end - 1) {
                Character ch;
                Document doc = iterator.getDocument();
                if (doc == null) {
                    return false;
                }
                CharSequence chars = doc.getCharsSequence();
                return chars.length() <= offset + 1 || Arrays.binarySearch(this.ourAutoClosingChars, (ch = Character.valueOf(chars.charAt(offset + 1))).charValue()) >= 0;
            }
        }
        return false;
    }
}

