/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.doctest;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.doctest.PyDocstringLanguageDialect;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyDocstringLanguageInjector
implements LanguageInjector {
    public void getLanguagesToInject(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguagePlaces injectionPlacesRegistrar) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/jetbrains/python/documentation/doctest/PyDocstringLanguageInjector", "getLanguagesToInject"));
        }
        if (injectionPlacesRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectionPlacesRegistrar", "com/jetbrains/python/documentation/doctest/PyDocstringLanguageInjector", "getLanguagesToInject"));
        }
        if (!(host instanceof PyStringLiteralExpression)) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host);
        if (module == null || !PyDocumentationSettings.getInstance((Module)module).analyzeDoctest) {
            return;
        }
        PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)host, PyDocStringOwner.class);
        if (docStringOwner != null && host.equals(docStringOwner.getDocStringExpression())) {
            int start = 0;
            int end = host.getTextLength() - 1;
            String text = host.getText();
            Pair<String, String> quotes = PythonStringUtil.getQuotes(text);
            List strings = StringUtil.split((String)text, (String)"\n", (boolean)false);
            boolean gotExample = false;
            int currentPosition = 0;
            int maxPosition = text.length();
            boolean endsWithSlash = false;
            for (String string : strings) {
                String closingQuote;
                String trimmedString = string.trim();
                if (!trimmedString.startsWith(">>>") && !trimmedString.startsWith("...") && gotExample && start < end) {
                    gotExample = false;
                    if (!endsWithSlash) {
                        injectionPlacesRegistrar.addPlace((Language)PyDocstringLanguageDialect.getInstance(), TextRange.create((int)start, (int)end), null, null);
                    }
                }
                String string2 = closingQuote = quotes == null ? text.substring(0, 1) : (String)quotes.second;
                if (endsWithSlash && !trimmedString.endsWith("\\")) {
                    endsWithSlash = false;
                    injectionPlacesRegistrar.addPlace((Language)PyDocstringLanguageDialect.getInstance(), TextRange.create((int)start, (int)PyDocstringLanguageInjector.getEndOffset(currentPosition, string, maxPosition, closingQuote)), null, null);
                }
                if (trimmedString.startsWith(">>>")) {
                    if (trimmedString.endsWith("\\")) {
                        endsWithSlash = true;
                    }
                    if (!gotExample) {
                        start = currentPosition;
                    }
                    gotExample = true;
                    end = PyDocstringLanguageInjector.getEndOffset(currentPosition, string, maxPosition, closingQuote);
                } else if (trimmedString.startsWith("...") && gotExample) {
                    if (trimmedString.endsWith("\\")) {
                        endsWithSlash = true;
                    }
                    end = PyDocstringLanguageInjector.getEndOffset(currentPosition, string, maxPosition, closingQuote);
                }
                currentPosition += string.length();
            }
            if (gotExample && start < end) {
                injectionPlacesRegistrar.addPlace((Language)PyDocstringLanguageDialect.getInstance(), TextRange.create((int)start, (int)end), null, null);
            }
        }
    }

    private static int getEndOffset(int start, String s, int maxPosition, String closingQuote) {
        int length = s.length();
        if (s.trim().endsWith(closingQuote)) {
            length -= 3;
        } else if (start + length == maxPosition && (s.trim().endsWith("\"") || s.trim().endsWith("'"))) {
            --length;
        }
        int end = start + length;
        if (s.endsWith("\n")) {
            --end;
        }
        return end;
    }
}

