/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.Maps;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.toolbox.Substring;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StructuredDocStringBase
implements StructuredDocString {
    protected final String myDescription;
    protected final Map<String, Substring> mySimpleTagValues;
    protected final Map<String, Map<Substring, Substring>> myArgTagValues;
    private static final Pattern RE_STRICT_TAG_LINE = Pattern.compile("([a-z]+)([^:]*| :class:[^:]*): (.*)");
    private static final Pattern RE_LOOSE_TAG_LINE = Pattern.compile("([a-z]+) ([a-zA-Z_0-9]*):?([^:]*)");
    private static final Pattern RE_ARG_TYPE = Pattern.compile("(.*) ([a-zA-Z_0-9]+)");
    public static String[] PARAM_TAGS = new String[]{"param", "parameter", "arg", "argument"};
    public static String[] PARAM_TYPE_TAGS = new String[]{"type"};
    public static String[] VARIABLE_TAGS = new String[]{"ivar", "cvar", "var"};
    public static String[] RAISES_TAGS = new String[]{"raises", "raise", "except", "exception"};
    public static String[] RETURN_TAGS = new String[]{"return", "returns"};
    @NotNull
    private final String myTagPrefix;
    public static String TYPE = "type";

    protected StructuredDocStringBase(@NotNull String docStringText, String tagPrefix) {
        if (docStringText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docStringText", "com/jetbrains/python/documentation/StructuredDocStringBase", "<init>"));
        }
        this.mySimpleTagValues = Maps.newHashMap();
        this.myArgTagValues = Maps.newHashMap();
        this.myTagPrefix = tagPrefix;
        Substring docString = new Substring(docStringText);
        List<Substring> lines = docString.splitLines();
        int nlines = lines.size();
        StringBuilder builder = new StringBuilder();
        for (int lineno = 0; lineno < nlines; ++lineno) {
            Substring line = lines.get(lineno).trim();
            if (line.startsWith(tagPrefix)) {
                lineno = this.parseTag(lines, lineno, tagPrefix);
                continue;
            }
            builder.append(line.toString()).append("\n");
        }
        this.myDescription = builder.toString();
    }

    @Override
    @NotNull
    public String createParameterType(@NotNull String name, @NotNull String type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/documentation/StructuredDocStringBase", "createParameterType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/documentation/StructuredDocStringBase", "createParameterType"));
        }
        String string = this.myTagPrefix + TYPE + String.format(" %s %s", name, type);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/StructuredDocStringBase", "createParameterType"));
        }
        return string;
    }

    @Override
    public String getDescription() {
        return this.myDescription;
    }

    @Override
    public String getSummary() {
        List strings = StringUtil.split((String)StringUtil.trimLeading((String)this.myDescription), (String)"\n", (boolean)true, (boolean)false);
        if (strings.size() > 1 && ((String)strings.get(1)).isEmpty()) {
            return (String)strings.get(0);
        }
        return "";
    }

    @NotNull
    private Map<Substring, Substring> getTagValuesMap(String key) {
        LinkedHashMap map = this.myArgTagValues.get(key);
        if (map == null) {
            map = Maps.newLinkedHashMap();
            this.myArgTagValues.put(key, map);
        }
        LinkedHashMap linkedHashMap = map;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/StructuredDocStringBase", "getTagValuesMap"));
        }
        return linkedHashMap;
    }

    protected int parseTag(List<Substring> lines, int lineno, String tagPrefix) {
        Substring lineWithPrefix = lines.get(lineno).trim();
        if (lineWithPrefix.startsWith(tagPrefix)) {
            Substring line = lineWithPrefix.substring(tagPrefix.length());
            Matcher strictTagMatcher = RE_STRICT_TAG_LINE.matcher(line);
            Matcher looseTagMatcher = RE_LOOSE_TAG_LINE.matcher(line);
            Matcher tagMatcher = null;
            if (strictTagMatcher.matches()) {
                tagMatcher = strictTagMatcher;
            } else if (looseTagMatcher.matches()) {
                tagMatcher = looseTagMatcher;
            }
            if (tagMatcher != null) {
                Substring nextLine;
                Substring tagName = line.getMatcherGroup(tagMatcher, 1);
                Substring argName = line.getMatcherGroup(tagMatcher, 2).trim();
                TextRange firstArgLineRange = line.getMatcherGroup(tagMatcher, 3).trim().getTextRange();
                int linesCount = lines.size();
                int argStart = firstArgLineRange.getStartOffset();
                int argEnd = firstArgLineRange.getEndOffset();
                while (lineno + 1 < linesCount && (nextLine = lines.get(lineno + 1).trim()).length() != 0 && !nextLine.startsWith(tagPrefix)) {
                    argEnd = nextLine.getTextRange().getEndOffset();
                    ++lineno;
                }
                Substring argValue = new Substring(argName.getSuperString(), argStart, argEnd);
                String tagNameString = tagName.toString();
                if (argName.length() == 0) {
                    this.mySimpleTagValues.put(tagNameString, argValue);
                } else if ("param".equals(tagNameString) || "parameter".equals(tagNameString) || "arg".equals(tagNameString) || "argument".equals(tagNameString)) {
                    Matcher argTypeMatcher = RE_ARG_TYPE.matcher(argName);
                    if (argTypeMatcher.matches()) {
                        Substring type = argName.getMatcherGroup(argTypeMatcher, 1).trim();
                        Substring arg = argName.getMatcherGroup(argTypeMatcher, 2);
                        this.getTagValuesMap(TYPE).put(arg, type);
                    } else {
                        this.getTagValuesMap(tagNameString).put(argName, argValue);
                    }
                } else {
                    this.getTagValuesMap(tagNameString).put(argName, argValue);
                }
            }
        }
        return lineno;
    }

    protected static List<String> toUniqueStrings(List<?> objects) {
        ArrayList<String> result = new ArrayList<String>(objects.size());
        for (Object o : objects) {
            String s = o.toString();
            if (result.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    @Override
    @Nullable
    public Substring getTagValue(String ... tagNames) {
        for (String tagName : tagNames) {
            Substring value = this.mySimpleTagValues.get(tagName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    @Nullable
    public Substring getTagValue(String tagName, @NotNull String argName) {
        if (argName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argName", "com/jetbrains/python/documentation/StructuredDocStringBase", "getTagValue"));
        }
        Map<Substring, Substring> argValues = this.myArgTagValues.get(tagName);
        return argValues != null ? argValues.get(new Substring(argName)) : null;
    }

    @Override
    @Nullable
    public Substring getTagValue(String[] tagNames, @NotNull String argName) {
        if (argName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argName", "com/jetbrains/python/documentation/StructuredDocStringBase", "getTagValue"));
        }
        for (String tagName : tagNames) {
            Map<Substring, Substring> argValues = this.myArgTagValues.get(tagName);
            if (argValues == null) continue;
            return argValues.get(new Substring(argName));
        }
        return null;
    }

    @Override
    public List<Substring> getTagArguments(String ... tagNames) {
        for (String tagName : tagNames) {
            Map<Substring, Substring> map = this.myArgTagValues.get(tagName);
            if (map == null) continue;
            return new ArrayList<Substring>(map.keySet());
        }
        return Collections.emptyList();
    }

    @Override
    public List<Substring> getParameterSubstrings() {
        ArrayList<Substring> results = new ArrayList<Substring>();
        results.addAll(this.getTagArguments(PARAM_TAGS));
        results.addAll(this.getTagArguments(PARAM_TYPE_TAGS));
        return results;
    }

    @Override
    @Nullable
    public Substring getParamByNameAndKind(@NotNull String name, String kind) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/documentation/StructuredDocStringBase", "getParamByNameAndKind"));
        }
        for (Substring s : this.getTagArguments(kind)) {
            if (!name.equals(s.getValue())) continue;
            return s;
        }
        return null;
    }

    public static enum ReferenceType {
        PARAMETER,
        PARAMETER_TYPE,
        KEYWORD,
        VARIABLE,
        CLASS_VARIABLE,
        INSTANCE_VARIABLE;

    }
}

