/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Function;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevDocumentationProvider;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.debugger.PySignatureUtil;
import com.jetbrains.python.documentation.DocStringUtil;
import com.jetbrains.python.documentation.DocumentationBuilderKit;
import com.jetbrains.python.documentation.PyDocumentationBuilder;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.PyTypeModelBuilder;
import com.jetbrains.python.documentation.PythonDocumentationLinkProvider;
import com.jetbrains.python.documentation.PythonDocumentationMap;
import com.jetbrains.python.documentation.PythonDocumentationQuickInfoProvider;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.toolbox.ChainIterable;
import com.jetbrains.python.toolbox.FP;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonDocumentationProvider
extends AbstractDocumentationProvider
implements ExternalDocumentationProvider {
    @NonNls
    static final String LINK_TYPE_CLASS = "#class#";
    @NonNls
    static final String LINK_TYPE_PARENT = "#parent#";
    @NonNls
    static final String LINK_TYPE_PARAM = "#param#";
    @NonNls
    static final String LINK_TYPE_TYPENAME = "#typename#";
    @NonNls
    private static final String RST_PREFIX = ":";
    @NonNls
    private static final String EPYDOC_PREFIX = "@";
    public static final DocumentationBuilderKit.LinkWrapper LinkMyClass = new DocumentationBuilderKit.LinkWrapper("#class#");

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        for (PythonDocumentationQuickInfoProvider point : (PythonDocumentationQuickInfoProvider[])PythonDocumentationQuickInfoProvider.EP_NAME.getExtensions()) {
            String info = point.getQuickInfo(originalElement);
            if (info == null) continue;
            return info;
        }
        if (element instanceof PyFunction) {
            StructuredDocString docString;
            PyFunction func = (PyFunction)element;
            StringBuilder cat = new StringBuilder();
            PyClass cls = func.getContainingClass();
            if (cls != null) {
                String cls_name = cls.getName();
                cat.append("class ").append(cls_name).append("\n");
            }
            String summary = "";
            PyStringLiteralExpression docStringExpression = func.getDocStringExpression();
            if (docStringExpression != null && (docString = DocStringUtil.parse(docStringExpression.getStringValue())) != null) {
                summary = docString.getSummary();
            }
            return DocumentationBuilderKit.$(cat.toString()).add((Iterable<String>)PythonDocumentationProvider.describeDecorators(func, DocumentationBuilderKit.LSame2, ", ", DocumentationBuilderKit.LSame1)).add((Iterable<String>)PythonDocumentationProvider.describeFunction(func, DocumentationBuilderKit.LSame2, DocumentationBuilderKit.LSame1)).toString() + "\n" + summary;
        }
        if (element instanceof PyClass) {
            StructuredDocString docString;
            PyFunction initOrNew;
            PyClass cls = (PyClass)element;
            String summary = "";
            PyStringLiteralExpression docStringExpression = cls.getDocStringExpression();
            if (docStringExpression == null && (initOrNew = cls.findInitOrNew(false)) != null) {
                docStringExpression = initOrNew.getDocStringExpression();
            }
            if (docStringExpression != null && (docString = DocStringUtil.parse(docStringExpression.getStringValue())) != null) {
                summary = docString.getSummary();
            }
            return PythonDocumentationProvider.describeDecorators(cls, DocumentationBuilderKit.LSame2, ", ", DocumentationBuilderKit.LSame1).add((Iterable<String>)PythonDocumentationProvider.describeClass(cls, DocumentationBuilderKit.LSame2, false, false)).toString() + "\n" + summary;
        }
        if (element instanceof PyExpression) {
            return PythonDocumentationProvider.describeExpression((PyExpression)element, originalElement);
        }
        return null;
    }

    static ChainIterable<String> describeFunction(PyFunction fun, FP.Lambda1<Iterable<String>, Iterable<String>> func_name_wrapper, FP.Lambda1<String, String> escaper) {
        ChainIterable<String> cat = new ChainIterable<String>();
        String name = fun.getName();
        cat.addItem("def ").addWith(func_name_wrapper, DocumentationBuilderKit.$(name));
        TypeEvalContext context = TypeEvalContext.userInitiated(fun.getProject(), fun.getContainingFile());
        List<PyParameter> parameters = PyUtil.getParameters(fun, context);
        String paramStr = "(" + StringUtil.join(parameters, (Function)new Function<PyParameter, String>(){

            public String fun(PyParameter parameter) {
                return PyUtil.getReadableRepr((PsiElement)parameter, false);
            }
        }, (String)", ") + ")";
        cat.addItem(escaper.apply(paramStr));
        if (!"__init__".equals(name)) {
            cat.addItem(escaper.apply("\nInferred type: "));
            PythonDocumentationProvider.getTypeDescription(fun, cat);
            cat.addItem("<br>");
        }
        return cat;
    }

    @Nullable
    private static String describeExpression(@NotNull PyExpression expr, @NotNull PsiElement originalElement) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/python/documentation/PythonDocumentationProvider", "describeExpression"));
        }
        if (originalElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElement", "com/jetbrains/python/documentation/PythonDocumentationProvider", "describeExpression"));
        }
        String name = expr.getName();
        if (name != null) {
            PyFunction function;
            StringBuilder result = new StringBuilder(expr instanceof PyNamedParameter ? "parameter" : "variable");
            result.append(String.format(" \"%s\"", name));
            if (expr instanceof PyNamedParameter && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expr, PyFunction.class)) != null) {
                result.append(" of ").append(function.getContainingClass() == null ? "function" : "method");
                result.append(String.format(" \"%s\"", function.getName()));
            }
            if (originalElement instanceof PyTypedElement) {
                result.append("\n").append(PythonDocumentationProvider.describeType((PyTypedElement)originalElement));
            }
            return result.toString();
        }
        return null;
    }

    static String describeType(@NotNull PyTypedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/documentation/PythonDocumentationProvider", "describeType"));
        }
        TypeEvalContext context = TypeEvalContext.userInitiated(element.getProject(), element.getContainingFile());
        return String.format("Inferred type: %s", PythonDocumentationProvider.getTypeName(context.getType(element), context));
    }

    public static void getTypeDescription(@NotNull PyFunction fun, ChainIterable<String> body) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/jetbrains/python/documentation/PythonDocumentationProvider", "getTypeDescription"));
        }
        TypeEvalContext context = TypeEvalContext.userInitiated(fun.getProject(), fun.getContainingFile());
        PyTypeModelBuilder builder = new PyTypeModelBuilder(context);
        builder.build(context.getType(fun), true).toBodyWithLinks(body, fun);
    }

    public static String getTypeName(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/documentation/PythonDocumentationProvider", "getTypeName"));
        }
        PyTypeModelBuilder.TypeModel typeModel = PythonDocumentationProvider.buildTypeModel(type, context);
        return typeModel.asString();
    }

    private static PyTypeModelBuilder.TypeModel buildTypeModel(PyType type, TypeEvalContext context) {
        PyTypeModelBuilder builder = new PyTypeModelBuilder(context);
        return builder.build(type, true);
    }

    public static void describeExpressionTypeWithLinks(ChainIterable<String> body, PyReferenceExpression expression, @NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/documentation/PythonDocumentationProvider", "describeExpressionTypeWithLinks"));
        }
        PyType type = context.getType(expression);
        PythonDocumentationProvider.describeTypeWithLinks(body, (PsiElement)expression, type, context);
    }

    public static void describeTypeWithLinks(ChainIterable<String> body, PsiElement anchor, PyType type, TypeEvalContext context) {
        PyTypeModelBuilder builder = new PyTypeModelBuilder(context);
        builder.build(type, true).toBodyWithLinks(body, anchor);
    }

    static ChainIterable<String> describeDecorators(PyDecoratable what, FP.Lambda1<Iterable<String>, Iterable<String>> deco_name_wrapper, String deco_separator, FP.Lambda1<String, String> escaper) {
        ChainIterable<String> cat = new ChainIterable<String>();
        PyDecoratorList deco_list = what.getDecoratorList();
        if (deco_list != null) {
            for (PyDecorator deco : deco_list.getDecorators()) {
                cat.add(PythonDocumentationProvider.describeDeco(deco, deco_name_wrapper, escaper)).addItem(deco_separator);
            }
        }
        return cat;
    }

    static ChainIterable<String> describeClass(PyClass cls, FP.Lambda1<Iterable<String>, Iterable<String>> name_wrapper, boolean allow_html, boolean link_own_name) {
        ChainIterable<String> cat = new ChainIterable<String>();
        String name = cls.getName();
        cat.addItem("class ");
        if (allow_html && link_own_name) {
            cat.addWith(LinkMyClass, DocumentationBuilderKit.$(name));
        } else {
            cat.addWith(name_wrapper, DocumentationBuilderKit.$(name));
        }
        PyExpression[] ancestors = cls.getSuperClassExpressions();
        if (ancestors.length > 0) {
            cat.addItem("(");
            boolean is_not_first = false;
            for (PyExpression parent : ancestors) {
                String parentName = parent.getName();
                if (parentName == null) continue;
                if (is_not_first) {
                    cat.addItem(", ");
                } else {
                    is_not_first = true;
                }
                if (allow_html) {
                    cat.addWith(new DocumentationBuilderKit.LinkWrapper(LINK_TYPE_PARENT + parentName), DocumentationBuilderKit.$(parentName));
                    continue;
                }
                cat.addItem(parentName);
            }
            cat.addItem(")");
        }
        return cat;
    }

    private static Iterable<String> describeDeco(PyDecorator deco, FP.Lambda1<Iterable<String>, Iterable<String>> name_wrapper, FP.Lambda1<String, String> arg_wrapper) {
        PyArgumentList arglist;
        ChainIterable<String> cat = new ChainIterable<String>();
        cat.addItem(EPYDOC_PREFIX).addWith(name_wrapper, DocumentationBuilderKit.$(PyUtil.getReadableRepr((PsiElement)deco.getCallee(), true)));
        if (deco.hasArgumentList() && (arglist = deco.getArgumentList()) != null) {
            cat.addItem("(").add(DocumentationBuilderKit.interleave(FP.map(FP.combine(DocumentationBuilderKit.LReadableRepr, arg_wrapper), arglist.getArguments()), ", ")).addItem(")");
        }
        return cat;
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (element != null && PydevConsoleRunner.isInPydevConsole(element) || originalElement != null && PydevConsoleRunner.isInPydevConsole(originalElement)) {
            return PydevDocumentationProvider.createDoc(element, originalElement);
        }
        originalElement = PythonDocumentationProvider.findRealOriginalElement(originalElement);
        return new PyDocumentationBuilder(element, originalElement).build();
    }

    private static PsiElement findRealOriginalElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return element;
        }
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(file);
        if (document == null) {
            return element;
        }
        int newOffset = TargetElementUtilBase.adjustOffset(file, document, element.getTextOffset());
        PsiElement newElement = file.findElementAt(newOffset);
        return newElement != null ? newElement : element;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        String typeName;
        PyType type;
        if (link.equals(LINK_TYPE_CLASS)) {
            return PythonDocumentationProvider.inferContainingClassOf(context);
        }
        if (link.equals(LINK_TYPE_PARAM)) {
            return PythonDocumentationProvider.inferClassOfParameter(context);
        }
        if (link.startsWith(LINK_TYPE_PARENT)) {
            PyClass cls = PythonDocumentationProvider.inferContainingClassOf(context);
            if (cls != null) {
                String desired_name = link.substring(LINK_TYPE_PARENT.length());
                for (PyClass parent : cls.getAncestorClasses()) {
                    String parent_name = parent.getName();
                    if (parent_name == null || !parent_name.equals(desired_name)) continue;
                    return parent;
                }
            }
        } else if (link.startsWith(LINK_TYPE_TYPENAME) && (type = PyTypeParser.getTypeByName(context, typeName = link.substring(LINK_TYPE_TYPENAME.length()))) instanceof PyClassType) {
            return ((PyClassType)type).getPyClass();
        }
        return null;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String url = PythonDocumentationProvider.getUrlFor(element, originalElement, true);
        return url == null ? null : Collections.singletonList(url);
    }

    @Nullable
    private static String getUrlFor(PsiElement element, PsiElement originalElement, boolean checkExistence) {
        String url;
        PyClass containingClass;
        Object namedElement;
        Sdk sdk;
        PsiFileSystemItem file;
        Object object = file = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
        if (file == null) {
            return null;
        }
        if ("__init__.py".equals(file.getName())) {
            file = file.getParent();
            assert (file != null);
        }
        if ((sdk = PyBuiltinCache.findSdkForFile(file)) == null) {
            return null;
        }
        QualifiedName qName = QualifiedNameFinder.findCanonicalImportPath(element, originalElement);
        if (qName == null) {
            return null;
        }
        PythonDocumentationMap map = PythonDocumentationMap.getInstance();
        String pyVersion = PythonDocumentationProvider.pyVersion(sdk.getVersionString());
        PsiNamedElement psiNamedElement = namedElement = element instanceof PsiNamedElement && !(element instanceof PsiFileSystemItem) ? (PsiNamedElement)element : null;
        if (namedElement instanceof PyFunction && "__init__".equals(namedElement.getName()) && (containingClass = ((PyFunction)namedElement).getContainingClass()) != null) {
            namedElement = containingClass;
        }
        if ((url = map.urlFor(qName, (PsiNamedElement)namedElement, pyVersion)) != null) {
            if (checkExistence && !PythonDocumentationProvider.pageExists(url)) {
                return map.rootUrlFor(qName);
            }
            return url;
        }
        for (PythonDocumentationLinkProvider provider : (PythonDocumentationLinkProvider[])Extensions.getExtensions(PythonDocumentationLinkProvider.EP_NAME)) {
            String providerUrl = provider.getExternalDocumentationUrl(element, originalElement);
            if (providerUrl == null) continue;
            if (checkExistence && !PythonDocumentationProvider.pageExists(providerUrl)) {
                return provider.getExternalDocumentationRoot(sdk);
            }
            return providerUrl;
        }
        return null;
    }

    private static boolean pageExists(String url) {
        if (new File(url).exists()) {
            return true;
        }
        HttpClient client = new HttpClient();
        HttpConnectionManagerParams params = client.getHttpConnectionManager().getParams();
        params.setSoTimeout(5000);
        params.setConnectionTimeout(5000);
        try {
            HeadMethod method = new HeadMethod(url);
            int rc = client.executeMethod((HttpMethod)method);
            if (rc == 404) {
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @Nullable
    public static String pyVersion(@Nullable String versionString) {
        String version;
        int dot;
        String prefix = "Python ";
        if (versionString != null && versionString.startsWith(prefix) && (dot = (version = versionString.substring(prefix.length())).indexOf(46)) > 0) {
            if ((dot = version.indexOf(46, dot + 1)) > 0) {
                return version.substring(0, dot);
            }
            return version;
        }
        return null;
    }

    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        return null;
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return PythonDocumentationProvider.getUrlFor(element, originalElement, false) != null;
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof PyFile) {
            QualifiedName qName;
            Project project = element.getProject();
            VirtualFile vFile = containingFile.getVirtualFile();
            if (vFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(vFile) && (qName = QualifiedNameFinder.findCanonicalImportPath(element, element)) != null && qName.getComponentCount() > 0) {
                return true;
            }
        }
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
        final Project project = element.getProject();
        final QualifiedName qName = QualifiedNameFinder.findCanonicalImportPath(element, element);
        if (qName != null && qName.getComponentCount() > 0) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    int rc = Messages.showOkCancelDialog((Project)project, (String)("No external documentation URL configured for module " + (String)qName.getComponents().get(0) + ".\nWould you like to configure it now?"), (String)"Python External Documentation", (Icon)Messages.getQuestionIcon());
                    if (rc == 0) {
                        ShowSettingsUtilImpl.showSettingsDialog(project, "com.jetbrains.python.documentation.PythonDocumentationConfigurable", "");
                    }
                }
            }, ModalityState.NON_MODAL);
        }
    }

    @Nullable
    private static PyClass inferContainingClassOf(PsiElement context) {
        if (context instanceof PyClass) {
            return (PyClass)context;
        }
        if (context instanceof PyFunction) {
            return ((PyFunction)context).getContainingClass();
        }
        return (PyClass)PsiTreeUtil.getParentOfType((PsiElement)context, PyClass.class);
    }

    @Nullable
    private static PyClass inferClassOfParameter(PsiElement context) {
        PyType type;
        if (context instanceof PyNamedParameter && (type = TypeEvalContext.userInitiated(context.getProject(), context.getContainingFile()).getType((PyNamedParameter)context)) instanceof PyClassType) {
            return ((PyClassType)type).getPyClass();
        }
        return null;
    }

    public static String generateDocumentationContentStub(PyFunction element, String offset, boolean checkReturn) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return "";
        }
        PyDocumentationSettings documentationSettings = PyDocumentationSettings.getInstance(module);
        String result = "";
        result = documentationSettings.isEpydocFormat(element.getContainingFile()) ? result + PythonDocumentationProvider.generateContent(element, offset, EPYDOC_PREFIX, checkReturn) : (documentationSettings.isReSTFormat(element.getContainingFile()) ? result + PythonDocumentationProvider.generateContent(element, offset, RST_PREFIX, checkReturn) : result + offset);
        return result;
    }

    public static void insertDocStub(PyFunction function, PyStatementList insertPlace, Project project, Editor editor) {
        PyStatement[] statements;
        String[] spaces;
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PsiWhiteSpace whitespace = (PsiWhiteSpace)PsiTreeUtil.getPrevSiblingOfType((PsiElement)insertPlace, PsiWhiteSpace.class);
        String ws = "\n";
        if (whitespace != null && (spaces = whitespace.getText().split("\n")).length > 1) {
            ws = ws + spaces[spaces.length - 1];
        }
        String docContent = ws + PythonDocumentationProvider.generateDocumentationContentStub(function, ws, true);
        PyExpressionStatement string = elementGenerator.createDocstring("\"\"\"" + docContent + "\"\"\"");
        if (insertPlace != null && (statements = insertPlace.getStatements()).length != 0) {
            insertPlace.addBefore((PsiElement)string, (PsiElement)statements[0]);
        }
        PyStringLiteralExpression docstring = function.getDocStringExpression();
        if (editor != null && docstring != null) {
            int offset = docstring.getTextOffset();
            editor.getCaretModel().moveToOffset(offset);
            editor.getCaretModel().moveCaretRelatively(0, 1, false, false, false);
        }
    }

    public String generateDocumentationContentStub(PyFunction element, boolean checkReturn) {
        String[] spaces;
        PsiWhiteSpace whitespace = (PsiWhiteSpace)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element.getStatementList(), PsiWhiteSpace.class);
        String ws = "\n";
        if (whitespace != null && (spaces = whitespace.getText().split("\n")).length > 1) {
            ws = ws + whitespace.getText().split("\n")[1];
        }
        return PythonDocumentationProvider.generateDocumentationContentStub(element, ws, checkReturn);
    }

    private static String generateContent(PyFunction function, String offset, String prefix, boolean checkReturn) {
        StringBuilder builder = new StringBuilder(offset);
        TypeEvalContext context = TypeEvalContext.userInitiated(function.getProject(), function.getContainingFile());
        PySignature signature = PySignatureCacheManager.getInstance(function.getProject()).findSignature(function);
        PyDecoratorList decoratorList = function.getDecoratorList();
        PyDecorator classMethod = decoratorList == null ? null : decoratorList.findDecorator("classmethod");
        for (PyParameter p : PyUtil.getParameters(function, context)) {
            String argType;
            String parameterName = p.getName();
            if (p.getText().equals("self") || parameterName == null || classMethod != null && parameterName.equals("cls")) continue;
            String string = argType = signature == null ? null : signature.getArgTypeQualifiedName(parameterName);
            if (argType == null) {
                builder.append(prefix);
                builder.append("param ");
                builder.append(parameterName);
                builder.append(": ");
                builder.append(offset);
            }
            if (!PyCodeInsightSettings.getInstance().INSERT_TYPE_DOCSTUB && argType == null) continue;
            builder.append(prefix);
            builder.append("type ");
            builder.append(parameterName);
            builder.append(": ");
            if (signature != null && argType != null) {
                builder.append(PySignatureUtil.getShortestImportableName(function, argType));
            }
            builder.append(offset);
        }
        builder.append(PythonDocumentationProvider.generateRaiseOrReturn(function, offset, prefix, checkReturn));
        return builder.toString();
    }

    public static String generateRaiseOrReturn(PyFunction element, String offset, String prefix, boolean checkReturn) {
        StringBuilder builder = new StringBuilder();
        if (checkReturn) {
            RaiseVisitor visitor = new RaiseVisitor();
            PyStatementList statementList = element.getStatementList();
            statementList.accept(visitor);
            if (visitor.myHasReturn) {
                builder.append(prefix).append("return:").append(offset);
                if (PyCodeInsightSettings.getInstance().INSERT_TYPE_DOCSTUB) {
                    builder.append(prefix).append("rtype:").append(offset);
                }
            }
            if (visitor.myHasRaise) {
                builder.append(prefix).append("raise");
                if (visitor.myRaiseTarget != null) {
                    PyExpression callee;
                    String raiseTarget = visitor.myRaiseTarget.getText();
                    if (visitor.myRaiseTarget instanceof PyCallExpression && (callee = ((PyCallExpression)visitor.myRaiseTarget).getCallee()) != null) {
                        raiseTarget = callee.getText();
                    }
                    builder.append(" ").append(raiseTarget);
                }
                builder.append(RST_PREFIX).append(offset);
            }
        } else {
            builder.append(prefix).append("return:").append(offset);
            if (PyCodeInsightSettings.getInstance().INSERT_TYPE_DOCSTUB) {
                builder.append(prefix).append("rtype:").append(offset);
            }
        }
        return builder.toString();
    }

    private static class RaiseVisitor
    extends PyRecursiveElementVisitor {
        private boolean myHasRaise = false;
        private boolean myHasReturn = false;
        private PyExpression myRaiseTarget = null;

        private RaiseVisitor() {
        }

        @Override
        public void visitPyRaiseStatement(PyRaiseStatement node) {
            this.myHasRaise = true;
            PyExpression[] expressions = node.getExpressions();
            if (expressions.length > 0) {
                this.myRaiseTarget = expressions[0];
            }
        }

        @Override
        public void visitPyReturnStatement(PyReturnStatement node) {
            this.myHasReturn = true;
        }
    }
}

