/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.documentation.DocumentationBuilderKit;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyDynamicallyEvaluatedType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.toolbox.ChainIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeModelBuilder {
    private final Map<PyType, TypeModel> myVisited = Maps.newHashMap();
    private final TypeEvalContext myContext;

    PyTypeModelBuilder(TypeEvalContext context) {
        this.myContext = context;
    }

    private static TypeModel _(String name) {
        return new NamedType(name);
    }

    public TypeModel build(@Nullable PyType type, boolean allowUnions) {
        TypeModel evaluated = this.myVisited.get(type);
        if (evaluated != null) {
            return evaluated;
        }
        if (this.myVisited.containsKey(type)) {
            return type != null ? PyTypeModelBuilder._(type.getName()) : PyTypeModelBuilder._("unknown");
        }
        this.myVisited.put(type, null);
        TypeModel result = null;
        if (type instanceof PyCollectionType) {
            String name = type.getName();
            PyType elementType = ((PyCollectionType)type).getElementType(this.myContext);
            ArrayList<TypeModel> elementTypes = new ArrayList<TypeModel>();
            if (elementType instanceof PyTupleType) {
                PyTupleType tupleType = (PyTupleType)elementType;
                int n = tupleType.getElementCount();
                for (int i = 0; i < n; ++i) {
                    PyType t = tupleType.getElementType(i);
                    if (t == null) continue;
                    elementTypes.add(this.build(t, true));
                }
            } else if (elementType != null) {
                elementTypes.add(this.build(elementType, true));
            }
            if (!elementTypes.isEmpty()) {
                result = new CollectionOf(name, elementTypes);
            }
        } else if (type instanceof PyUnionType && allowUnions) {
            result = type instanceof PyDynamicallyEvaluatedType || PyTypeChecker.isUnknown(type) ? new UnknownType(this.build(((PyUnionType)type).excludeNull(this.myContext), true)) : new OneOf(Collections2.transform(((PyUnionType)type).getMembers(), (Function)new Function<PyType, TypeModel>(){

                public TypeModel apply(PyType t) {
                    return PyTypeModelBuilder.this.build(t, false);
                }
            }));
        } else if (type instanceof PyCallableType && !(type instanceof PyClassLikeType)) {
            result = this.build((PyCallableType)type);
        }
        if (result == null) {
            result = type != null ? PyTypeModelBuilder._(type.getName()) : PyTypeModelBuilder._("unknown");
        }
        this.myVisited.put(type, result);
        return result;
    }

    private TypeModel build(@NotNull PyCallableType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/documentation/PyTypeModelBuilder", "build"));
        }
        ArrayList<TypeModel> parameterModels = null;
        List<PyCallableParameter> parameters = type.getParameters(this.myContext);
        if (parameters != null) {
            parameterModels = new ArrayList<TypeModel>();
            for (PyCallableParameter parameter : parameters) {
                parameterModels.add(new ParamType(parameter.getName(), this.build(parameter.getType(this.myContext), true)));
            }
        }
        PyType ret = type.getReturnType(this.myContext);
        TypeModel returnType = this.build(ret, true);
        return new FunctionType(returnType, parameterModels);
    }

    private static abstract class TypeNameVisitor
    implements TypeVisitor {
        private int myDepth = 0;
        private static final int MAX_DEPTH = 6;

        private TypeNameVisitor() {
        }

        @Override
        public void oneOf(OneOf oneOf) {
            ++this.myDepth;
            if (this.myDepth > 6) {
                this.add("...");
                return;
            }
            this.processList(oneOf.oneOfTypes, " | ");
            --this.myDepth;
        }

        private void processList(Collection<TypeModel> list, String separator) {
            boolean first = true;
            for (TypeModel t : list) {
                if (!first) {
                    this.add(separator);
                } else {
                    first = false;
                }
                t.accept(this);
            }
        }

        protected abstract void add(String var1);

        @Override
        public void collectionOf(CollectionOf collectionOf) {
            ++this.myDepth;
            if (this.myDepth > 6) {
                this.add("...");
                return;
            }
            this.addType(collectionOf.collectionName);
            this.add("[");
            this.processList(collectionOf.elementTypes, ", ");
            this.add("]");
            --this.myDepth;
        }

        protected abstract void addType(String var1);

        @Override
        public void name(String name) {
            this.addType(name);
        }

        @Override
        public void function(FunctionType function) {
            ++this.myDepth;
            if (this.myDepth > 6) {
                this.add("...");
                return;
            }
            this.add("(");
            Collection parameters = function.parameters;
            if (parameters != null) {
                this.processList(parameters, ", ");
            } else {
                this.add("...");
            }
            this.add(") -> ");
            function.returnType.accept(this);
            --this.myDepth;
        }

        @Override
        public void param(ParamType param) {
            ++this.myDepth;
            if (this.myDepth > 6) {
                this.add("...");
                return;
            }
            if (param.name != null) {
                this.add(param.name);
            }
            if (param.type != null) {
                if (param.name != null) {
                    this.add(": ");
                }
                param.type.accept(this);
            }
            --this.myDepth;
        }

        @Override
        public void unknown(UnknownType type) {
            type.type.accept(this);
        }
    }

    private static class TypeToBodyWithLinksVisitor
    extends TypeNameVisitor {
        private ChainIterable<String> myBody;
        private PsiElement myAnchor;

        public TypeToBodyWithLinksVisitor(ChainIterable<String> body, PsiElement anchor) {
            this.myBody = body;
            this.myAnchor = anchor;
        }

        @Override
        protected void add(String s) {
            this.myBody.addItem(DocumentationBuilderKit.combUp(s));
        }

        @Override
        protected void addType(String name) {
            PyType type = PyTypeParser.getTypeByName(this.myAnchor, name);
            if (type instanceof PyClassType) {
                this.myBody.addWith(new DocumentationBuilderKit.LinkWrapper("#typename#" + name), DocumentationBuilderKit.$(name));
            } else {
                this.add(name);
            }
        }
    }

    private static class TypeToStringVisitor
    extends TypeNameVisitor {
        private final StringBuilder myStringBuilder = new StringBuilder();

        private TypeToStringVisitor() {
        }

        @Override
        protected void add(String s) {
            this.myStringBuilder.append(s);
        }

        @Override
        protected void addType(String name) {
            this.add(name);
        }

        public String getString() {
            return this.myStringBuilder.toString();
        }

        @Override
        public void unknown(UnknownType type) {
            TypeModel nested = type.type;
            if (nested != null) {
                nested.accept(this);
            }
            this.add(" | unknown");
        }
    }

    private static interface TypeVisitor {
        public void oneOf(OneOf var1);

        public void collectionOf(CollectionOf var1);

        public void name(String var1);

        public void function(FunctionType var1);

        public void param(ParamType var1);

        public void unknown(UnknownType var1);
    }

    static class ParamType
    extends TypeModel {
        @Nullable
        private final String name;
        @Nullable
        private final TypeModel type;

        private ParamType(@Nullable String name, @Nullable TypeModel type) {
            this.name = name;
            this.type = type;
        }

        @Override
        void accept(TypeVisitor visitor) {
            visitor.param(this);
        }
    }

    static class FunctionType
    extends TypeModel {
        private TypeModel returnType;
        @Nullable
        private Collection<TypeModel> parameters;

        FunctionType(@Nullable TypeModel returnType, @Nullable Collection<TypeModel> parameters) {
            this.returnType = returnType != null ? returnType : PyTypeModelBuilder._("unknown");
            this.parameters = parameters;
        }

        @Override
        void accept(TypeVisitor visitor) {
            visitor.function(this);
        }
    }

    static class UnknownType
    extends TypeModel {
        private final TypeModel type;

        private UnknownType(TypeModel type) {
            this.type = type;
        }

        @Override
        void accept(TypeVisitor visitor) {
            visitor.unknown(this);
        }
    }

    static class NamedType
    extends TypeModel {
        private String name;

        private NamedType(String name) {
            this.name = name;
        }

        @Override
        void accept(TypeVisitor visitor) {
            visitor.name(this.name);
        }
    }

    static class CollectionOf
    extends TypeModel {
        private String collectionName;
        private List<TypeModel> elementTypes;

        private CollectionOf(String collectionName, List<TypeModel> elementTypes) {
            this.collectionName = collectionName;
            this.elementTypes = elementTypes;
        }

        @Override
        void accept(TypeVisitor visitor) {
            visitor.collectionOf(this);
        }
    }

    static class OneOf
    extends TypeModel {
        private Collection<TypeModel> oneOfTypes;

        private OneOf(Collection<TypeModel> oneOfTypes) {
            this.oneOfTypes = oneOfTypes;
        }

        @Override
        void accept(TypeVisitor visitor) {
            visitor.oneOf(this);
        }
    }

    static abstract class TypeModel {
        TypeModel() {
        }

        abstract void accept(TypeVisitor var1);

        public String asString() {
            TypeToStringVisitor visitor = new TypeToStringVisitor();
            this.accept(visitor);
            return visitor.getString();
        }

        public void toBodyWithLinks(@NotNull ChainIterable<String> body, @NotNull PsiElement anchor) {
            if (body == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeModel", "toBodyWithLinks"));
            }
            if (anchor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeModel", "toBodyWithLinks"));
            }
            TypeToBodyWithLinksVisitor visitor = new TypeToBodyWithLinksVisitor(body, anchor);
            this.accept(visitor);
        }
    }
}

