/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.Lists;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.documentation.DocStringUtil;
import com.jetbrains.python.documentation.EpydocString;
import com.jetbrains.python.documentation.PyDocumentationBuilder;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.SphinxDocString;
import com.jetbrains.python.documentation.StructuredDocStringBase;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.toolbox.Substring;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStructuredDocstringFormatter {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.documentation.PyStructuredDocstringFormatter");

    private PyStructuredDocstringFormatter() {
    }

    @Nullable
    public static List<String> formatDocstring(@NotNull PsiElement element, @NotNull String docstring) {
        StructuredDocStringBase structuredDocString;
        String formatter;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/documentation/PyStructuredDocstringFormatter", "formatDocstring"));
        }
        if (docstring == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docstring", "com/jetbrains/python/documentation/PyStructuredDocstringFormatter", "formatDocstring"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            Module[] modules = ModuleManager.getInstance((Project)element.getProject()).getModules();
            if (modules.length == 0) {
                return Lists.newArrayList();
            }
            module = modules[0];
        }
        if (module == null) {
            return Lists.newArrayList();
        }
        PyDocumentationSettings documentationSettings = PyDocumentationSettings.getInstance(module);
        ArrayList<String> result = new ArrayList<String>();
        String[] lines = PyDocumentationBuilder.removeCommonIndentation(docstring);
        String preparedDocstring = StringUtil.join((String[])lines, (String)"\n");
        if (documentationSettings.isEpydocFormat(element.getContainingFile()) || DocStringUtil.isEpydocDocString(preparedDocstring)) {
            formatter = PythonHelpersLocator.getHelperPath("epydoc_formatter.py");
            structuredDocString = new EpydocString(preparedDocstring);
            result.add(PyStructuredDocstringFormatter.formatStructuredDocString(structuredDocString));
        } else if (documentationSettings.isReSTFormat(element.getContainingFile()) || DocStringUtil.isSphinxDocString(preparedDocstring)) {
            formatter = PythonHelpersLocator.getHelperPath("rest_formatter.py");
            structuredDocString = new SphinxDocString(preparedDocstring);
        } else {
            return null;
        }
        String output = PyStructuredDocstringFormatter.runExternalTool(module, formatter, docstring);
        if (output != null) {
            result.add(0, output);
        } else {
            result.add(0, structuredDocString.getDescription());
        }
        return result;
    }

    @Nullable
    private static String runExternalTool(@NotNull Module module, @NotNull String formatter, @NotNull String docstring) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/documentation/PyStructuredDocstringFormatter", "runExternalTool"));
        }
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/jetbrains/python/documentation/PyStructuredDocstringFormatter", "runExternalTool"));
        }
        if (docstring == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docstring", "com/jetbrains/python/documentation/PyStructuredDocstringFormatter", "runExternalTool"));
        }
        Sdk sdk = PythonSdkType.findPython2Sdk(module);
        if (sdk == null) {
            return null;
        }
        String sdkHome = sdk.getHomePath();
        if (sdkHome == null) {
            return null;
        }
        Charset charset = EncodingProjectManager.getInstance((Project)module.getProject()).getDefaultCharset();
        if (charset == null) {
            return null;
        }
        ByteBuffer encoded = charset.encode(docstring);
        byte[] data = new byte[encoded.limit()];
        encoded.get(data);
        ProcessOutput output = PySdkUtil.getProcessOutput(new File(sdkHome).getParent(), new String[]{sdkHome, formatter}, null, 5000, data, true);
        if (output.isTimeout()) {
            LOG.info("timeout when calculating docstring");
            return null;
        }
        if (output.getExitCode() != 0) {
            String error = "error when calculating docstring: " + output.getStderr();
            LOG.info(error);
            return null;
        }
        return output.getStdout();
    }

    private static String formatStructuredDocString(@NotNull StructuredDocString docString) {
        List<String> additionalTags;
        List<String> raisedException;
        if (docString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docString", "com/jetbrains/python/documentation/PyStructuredDocstringFormatter", "formatStructuredDocString"));
        }
        StringBuilder result = new StringBuilder();
        String attributeDescription = docString.getAttributeDescription();
        if (attributeDescription != null) {
            result.append(attributeDescription);
            String attrType = docString.getParamType(null);
            if (attrType != null) {
                result.append(" <i>Type: ").append(attrType).append("</i>");
            }
        }
        PyStructuredDocstringFormatter.formatParameterDescriptions(docString, result, false);
        PyStructuredDocstringFormatter.formatParameterDescriptions(docString, result, true);
        String returnDescription = docString.getReturnDescription();
        String returnType = docString.getReturnType();
        if (returnDescription != null || returnType != null) {
            result.append("<br><b>Return value:</b><br>");
            if (returnDescription != null) {
                result.append(returnDescription);
            }
            if (returnType != null) {
                result.append(" <i>Type: ").append(returnType).append("</i>");
            }
        }
        if ((raisedException = docString.getRaisedExceptions()).size() > 0) {
            result.append("<br><b>Raises:</b><br>");
            for (String s : raisedException) {
                result.append("<b>").append(s).append("</b> - ").append(docString.getRaisedExceptionDescription(s)).append("<br>");
            }
        }
        if (!(additionalTags = docString.getAdditionalTags()).isEmpty()) {
            result.append("<br/><br/><b>Additional:</b><br/>");
            result.append("<table>");
            for (String tagName : additionalTags) {
                List<Substring> args = docString.getTagArguments(tagName);
                for (Substring arg : args) {
                    String s = arg.toString();
                    result.append("<tr><td align=\"right\"><b>").append(tagName);
                    result.append(" ").append(s).append(":</b>");
                    result.append("</td><td>").append(docString.getTagValue(tagName, s)).append("</td></tr>");
                }
                result.append("</table>");
            }
        }
        return result.toString();
    }

    private static void formatParameterDescriptions(@NotNull StructuredDocString docString, @NotNull StringBuilder result, boolean keyword) {
        List<String> parameters;
        if (docString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docString", "com/jetbrains/python/documentation/PyStructuredDocstringFormatter", "formatParameterDescriptions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/documentation/PyStructuredDocstringFormatter", "formatParameterDescriptions"));
        }
        List<String> list = parameters = keyword ? docString.getKeywordArguments() : docString.getParameters();
        if (parameters.size() > 0) {
            result.append("<br><b>").append(keyword ? "Keyword arguments:" : "Parameters").append("</b><br>");
            for (String parameter : parameters) {
                String paramType;
                String description = keyword ? docString.getKeywordArgumentDescription(parameter) : docString.getParamDescription(parameter);
                result.append("<b>");
                result.append(parameter);
                result.append("</b>: ");
                if (description != null) {
                    result.append(description);
                }
                if ((paramType = docString.getParamType(parameter)) != null) {
                    result.append(" <i>Type: ").append(paramType).append("</i>");
                }
                result.append("<br>");
            }
        }
    }
}

