/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.python.documentation.EpydocString;
import com.jetbrains.python.documentation.SphinxDocString;
import com.jetbrains.python.documentation.StructuredDocStringBase;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PyDocumentationSettings", storages={@Storage(file="$MODULE_FILE$")})
public class PyDocumentationSettings
implements PersistentStateComponent<PyDocumentationSettings> {
    public String myDocStringFormat = "reStructuredText";
    public boolean analyzeDoctest = true;

    public boolean isEpydocFormat(PsiFile file) {
        return this.isFormat(file, "Epytext");
    }

    public boolean isReSTFormat(PsiFile file) {
        return this.isFormat(file, "reStructuredText");
    }

    public boolean isPlain(PsiFile file) {
        return this.isFormat(file, "Plain");
    }

    private boolean isFormat(PsiFile file, String format) {
        String docformat;
        PyTargetExpression expr;
        if (file instanceof PyFile && (expr = ((PyFile)file).findTopLevelAttribute("__docformat__")) != null && (docformat = PyPsiUtils.strValue(expr.findAssignedValue())) != null) {
            List words = StringUtil.split((String)docformat, (String)" ");
            return words.size() > 0 && format.equalsIgnoreCase((String)words.get(0));
        }
        return format.equalsIgnoreCase(this.myDocStringFormat);
    }

    public static PyDocumentationSettings getInstance(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/documentation/PyDocumentationSettings", "getInstance"));
        }
        return (PyDocumentationSettings)ModuleServiceManager.getService((Module)module, PyDocumentationSettings.class);
    }

    public void setFormat(String format) {
        this.myDocStringFormat = format;
    }

    @Transient
    public String getFormat() {
        return this.myDocStringFormat;
    }

    public PyDocumentationSettings getState() {
        return this;
    }

    public void loadState(PyDocumentationSettings state2) {
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    @Nullable
    public StructuredDocStringBase getDocString() {
        if (this.myDocStringFormat.equals("Epytext")) {
            return new EpydocString();
        }
        if (this.myDocStringFormat.equals("reStructuredText")) {
            return new SphinxDocString();
        }
        return null;
    }
}

