/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.documentation.DocStringUtil;
import com.jetbrains.python.documentation.DocumentationBuilderKit;
import com.jetbrains.python.documentation.PyStructuredDocstringFormatter;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.resolve.RootVisitor;
import com.jetbrains.python.psi.resolve.RootVisitorHost;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyDynamicallyEvaluatedType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.toolbox.ChainIterable;
import com.jetbrains.python.toolbox.Maybe;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PyDocumentationBuilder {
    private final PsiElement myElement;
    private final PsiElement myOriginalElement;
    private ChainIterable<String> myResult;
    private ChainIterable<String> myProlog;
    private ChainIterable<String> myBody;
    private ChainIterable<String> myEpilog;
    private static final Pattern ourSpacesPattern = Pattern.compile("^\\s+");

    public PyDocumentationBuilder(PsiElement element, PsiElement originalElement) {
        this.myElement = element;
        this.myOriginalElement = originalElement;
        this.myResult = new ChainIterable();
        this.myProlog = new ChainIterable();
        this.myBody = new ChainIterable();
        this.myEpilog = new ChainIterable();
        this.myResult.add((Iterable<String>)this.myProlog).addWith(DocumentationBuilderKit.TagCode, this.myBody).add((Iterable<String>)this.myEpilog);
        this.myResult = DocumentationBuilderKit.wrapInTag("html", DocumentationBuilderKit.wrapInTag("body", this.myResult));
    }

    public String build() {
        PyClass cls;
        Property property;
        PyType type;
        PyExpression qual;
        String elementName;
        ChainIterable<String> reassignCat = new ChainIterable<String>();
        PsiElement followed = this.resolveToDocStringOwner(reassignCat);
        PsiElement outer = null;
        boolean is_property = false;
        String accessor_kind = "None";
        TypeEvalContext context = TypeEvalContext.userInitiated(this.myElement.getProject(), this.myElement.getContainingFile());
        if (this.myOriginalElement != null && PyUtil.isPythonIdentifier(elementName = this.myOriginalElement.getText()) && (outer = this.myOriginalElement.getParent()) instanceof PyQualifiedExpression && (qual = ((PyQualifiedExpression)outer).getQualifier()) != null && (type = context.getType(qual)) instanceof PyClassType && (property = (cls = ((PyClassType)type).getPyClass()).findProperty(elementName, true)) != null) {
            is_property = true;
            AccessDirection dir = AccessDirection.of((PyElement)outer);
            Maybe<Callable> accessor = property.getByDirection(dir);
            this.myProlog.addItem("property ").addWith(DocumentationBuilderKit.TagBold, DocumentationBuilderKit.$(new String[0]).addWith(DocumentationBuilderKit.TagCode, DocumentationBuilderKit.$(elementName))).addItem(" of ").add((Iterable<String>)PythonDocumentationProvider.describeClass(cls, DocumentationBuilderKit.TagCode, true, true));
            if (accessor.isDefined() && property.getDoc() != null) {
                this.myBody.addItem(": ").addItem(property.getDoc()).addItem("<br>");
            } else {
                PyStringLiteralExpression docstring;
                Callable getter = property.getGetter().valueOrNull();
                if (getter != null && getter != this.myElement && getter instanceof PyFunction && (docstring = ((PyFunction)getter).getDocStringExpression()) != null) {
                    this.myProlog.addItem("<br>").addWith(DocumentationBuilderKit.TagItalic, DocumentationBuilderKit.$("Copied from getter:")).addItem("<br>").addItem(docstring.getStringValue());
                }
                this.myBody.addItem("<br>");
            }
            this.myBody.addItem("<br>");
            if (accessor.isDefined() && accessor.value() == null) {
                followed = null;
            }
            accessor_kind = dir == AccessDirection.READ ? "Getter" : (dir == AccessDirection.WRITE ? "Setter" : "Deleter");
            if (followed != null) {
                this.myEpilog.addWith(DocumentationBuilderKit.TagSmall, DocumentationBuilderKit.$("<br>", "<br>", accessor_kind, " of property")).addItem("<br>");
            }
        }
        if (this.myProlog.isEmpty() && !is_property && !this.isAttribute()) {
            this.myProlog.add((Iterable<String>)reassignCat);
        }
        if (followed instanceof PyDocStringOwner) {
            String docString = null;
            PyStringLiteralExpression doc_expr = ((PyDocStringOwner)followed).getDocStringExpression();
            if (doc_expr != null) {
                docString = doc_expr.getStringValue();
            }
            if (followed instanceof PyClass) {
                cls = (PyClass)followed;
                this.myBody.add((Iterable<String>)PythonDocumentationProvider.describeDecorators(cls, DocumentationBuilderKit.TagItalic, "<br>", DocumentationBuilderKit.LCombUp));
                this.myBody.add((Iterable<String>)PythonDocumentationProvider.describeClass(cls, DocumentationBuilderKit.TagBold, true, false));
            } else if (followed instanceof PyFunction) {
                PyFunction fun = (PyFunction)followed;
                if (!is_property) {
                    cls = fun.getContainingClass();
                    if (cls != null) {
                        this.myBody.addWith(DocumentationBuilderKit.TagSmall, PythonDocumentationProvider.describeClass(cls, DocumentationBuilderKit.TagCode, true, true)).addItem("<br>").addItem("<br>");
                    }
                } else {
                    cls = null;
                }
                this.myBody.add((Iterable<String>)PythonDocumentationProvider.describeDecorators(fun, DocumentationBuilderKit.TagItalic, "<br>", DocumentationBuilderKit.LCombUp)).add((Iterable<String>)PythonDocumentationProvider.describeFunction(fun, DocumentationBuilderKit.TagBold, DocumentationBuilderKit.LCombUp));
                if (docString == null) {
                    this.addInheritedDocString(fun, cls);
                }
            } else if (followed instanceof PyFile) {
                this.addModulePath((PyFile)followed);
            }
            if (docString != null) {
                this.myBody.addItem("<br>");
                PyDocumentationBuilder.addFormattedDocString(this.myElement, docString, this.myBody, this.myEpilog);
            }
        } else if (is_property) {
            String accessor_message = followed != null ? "Declaration: " : accessor_kind + " is not defined.";
            this.myBody.addWith(DocumentationBuilderKit.TagItalic, DocumentationBuilderKit.$(accessor_message)).addItem("<br>");
            if (followed != null) {
                this.myBody.addItem(DocumentationBuilderKit.combUp(PyUtil.getReadableRepr(followed, false)));
            }
        } else if (this.isAttribute()) {
            this.addAttributeDoc();
        } else if (followed instanceof PyNamedParameter) {
            PyType type2;
            this.myBody.addItem(DocumentationBuilderKit.combUp("Parameter " + PyUtil.getReadableRepr(followed, false)));
            boolean typeFromDocstringAdded = this.addTypeAndDescriptionFromDocstring((PyNamedParameter)followed);
            if (outer instanceof PyExpression && (type2 = context.getType((PyExpression)outer)) != null) {
                PsiElement target;
                String s = null;
                if (type2 instanceof PyDynamicallyEvaluatedType) {
                    if (!typeFromDocstringAdded) {
                        s = "\nDynamically inferred type: ";
                    }
                } else if (outer.getReference() != null && (target = outer.getReference().resolve()) instanceof PyTargetExpression && ((PyTargetExpression)target).getName().equals(((PyNamedParameter)followed).getName())) {
                    s = "\nReassigned value has type: ";
                }
                if (s == null && !typeFromDocstringAdded) {
                    s = "\nInferred type: ";
                }
                if (s != null) {
                    this.myBody.addItem(DocumentationBuilderKit.combUp(s));
                    PythonDocumentationProvider.describeTypeWithLinks(this.myBody, followed, type2, context);
                }
            }
        } else if (followed != null && outer instanceof PyReferenceExpression) {
            this.myBody.addItem(DocumentationBuilderKit.combUp("\nInferred type: "));
            PythonDocumentationProvider.describeExpressionTypeWithLinks(this.myBody, (PyReferenceExpression)outer, context);
        }
        if (this.myBody.isEmpty() && this.myEpilog.isEmpty()) {
            return null;
        }
        return this.myResult.toString();
    }

    private boolean isAttribute() {
        return this.myElement instanceof PyTargetExpression && PyUtil.isAttribute((PyTargetExpression)this.myElement);
    }

    @Nullable
    private PsiElement resolveToDocStringOwner(ChainIterable<String> prolog_cat) {
        PyCallExpression call;
        Pair<String, PyFunction> wrap_info;
        if (this.myElement instanceof PyTargetExpression) {
            PsiElement resolved;
            String target_name = this.myElement.getText();
            prolog_cat.addWith(DocumentationBuilderKit.TagSmall, DocumentationBuilderKit.$(PyBundle.message("QDOC.assigned.to.$0", target_name)).addItem("<br>"));
            PyExpression assignedValue = ((PyTargetExpression)this.myElement).findAssignedValue();
            if (assignedValue instanceof PyReferenceExpression && (resolved = PyDocumentationBuilder.resolveWithoutImplicits((PyReferenceExpression)assignedValue)) != null) {
                return resolved;
            }
            return assignedValue;
        }
        if (this.myElement instanceof PyReferenceExpression) {
            prolog_cat.addWith(DocumentationBuilderKit.TagSmall, DocumentationBuilderKit.$(PyBundle.message("QDOC.assigned.to.$0", this.myElement.getText())).addItem("<br>"));
            return PyDocumentationBuilder.resolveWithoutImplicits((PyReferenceExpression)this.myElement);
        }
        if (this.myElement instanceof PyCallExpression && (wrap_info = PyCallExpressionHelper.interpretAsModifierWrappingCall(call = (PyCallExpression)this.myElement, this.myOriginalElement)) != null) {
            String wrapper_name = (String)wrap_info.getFirst();
            PyFunction wrapped_func = (PyFunction)wrap_info.getSecond();
            prolog_cat.addWith(DocumentationBuilderKit.TagSmall, DocumentationBuilderKit.$(PyBundle.message("QDOC.wrapped.in.$0", wrapper_name)).addItem("<br>"));
            return wrapped_func;
        }
        return this.myElement;
    }

    private static PsiElement resolveWithoutImplicits(PyReferenceExpression element) {
        QualifiedResolveResult resolveResult = element.followAssignmentsChain(PyResolveContext.noImplicits());
        return resolveResult.isImplicit() ? null : resolveResult.getElement();
    }

    private void addInheritedDocString(PyFunction fun, PyClass cls) {
        boolean not_found = true;
        String meth_name = fun.getName();
        if (cls != null && meth_name != null) {
            boolean is_constructor = "__init__".equals(meth_name);
            Iterable<PyClass> classes = cls.getAncestorClasses();
            if (is_constructor) {
                classes = new ChainIterable<PyClass>(cls).add(classes);
            }
            for (PyClass ancestor : classes) {
                String inherited_doc;
                PyStringLiteralExpression doc_elt = null;
                PyFunction inherited = null;
                boolean is_from_class = false;
                if (is_constructor) {
                    doc_elt = cls.getDocStringExpression();
                }
                if (doc_elt != null) {
                    is_from_class = true;
                } else {
                    inherited = ancestor.findMethodByName(meth_name, false);
                }
                if (inherited != null) {
                    doc_elt = inherited.getDocStringExpression();
                }
                if (doc_elt == null || (inherited_doc = doc_elt.getStringValue()).length() <= 1) continue;
                this.myEpilog.addItem("<br>").addItem("<br>");
                String ancestor_name = ancestor.getName();
                String marker = cls == ancestor ? "#class#" : "#parent#";
                String ancestor_link = DocumentationBuilderKit.$(new String[0]).addWith(new DocumentationBuilderKit.LinkWrapper(marker + ancestor_name), DocumentationBuilderKit.$(ancestor_name)).toString();
                if (is_from_class) {
                    this.myEpilog.addItem(PyBundle.message("QDOC.copied.from.class.$0", ancestor_link));
                } else {
                    this.myEpilog.addItem(PyBundle.message("QDOC.copied.from.$0.$1", ancestor_link, meth_name));
                }
                this.myEpilog.addItem("<br>").addItem("<br>");
                ChainIterable<String> formatted = new ChainIterable<String>();
                ChainIterable<String> unformatted = new ChainIterable<String>();
                PyDocumentationBuilder.addFormattedDocString(fun, inherited_doc, formatted, unformatted);
                this.myEpilog.addWith(DocumentationBuilderKit.TagCode, formatted).add((Iterable<String>)unformatted);
                not_found = false;
                break;
            }
            if (not_found && PyNames.UnderscoredAttributes.contains((Object)meth_name)) {
                this.addPredefinedMethodDoc(fun, meth_name);
            }
        }
    }

    private void addPredefinedMethodDoc(PyFunction fun, String meth_name) {
        PyClass objcls;
        PyFunction obj_underscored;
        PyClassType objtype = PyBuiltinCache.getInstance(fun).getObjectType();
        if (objtype != null && (obj_underscored = (objcls = objtype.getPyClass()).findMethodByName(meth_name, false)) != null) {
            String predefined_doc;
            PyStringLiteralExpression predefined_doc_expr = obj_underscored.getDocStringExpression();
            String string = predefined_doc = predefined_doc_expr != null ? predefined_doc_expr.getStringValue() : null;
            if (predefined_doc != null && predefined_doc.length() > 1) {
                PyDocumentationBuilder.addFormattedDocString(fun, predefined_doc, this.myBody, this.myBody);
                this.myEpilog.addItem("<br>").addItem("<br>").addItem(PyBundle.message("QDOC.copied.from.builtin", new Object[0]));
            }
        }
    }

    private static void addFormattedDocString(PsiElement element, @NotNull String docstring, ChainIterable<String> formattedOutput, ChainIterable<String> unformattedOutput) {
        if (docstring == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docstring", "com/jetbrains/python/documentation/PyDocumentationBuilder", "addFormattedDocString"));
        }
        Project project = element.getProject();
        List<String> formatted = PyStructuredDocstringFormatter.formatDocstring(element, docstring);
        if (formatted != null) {
            unformattedOutput.add((Iterable<String>)formatted);
            return;
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] lines = PyDocumentationBuilder.removeCommonIndentation(docstring);
        boolean isFirstLine = true;
        int tabSize = CodeStyleSettingsManager.getSettings((Project)project).getTabSize((FileType)PythonFileType.INSTANCE);
        for (String line : lines) {
            int leadingTabs;
            if (isFirstLine && ourSpacesPattern.matcher(line).matches()) continue;
            if (isFirstLine) {
                isFirstLine = false;
            } else {
                result.add("<br>");
            }
            for (leadingTabs = 0; leadingTabs < line.length() && line.charAt(leadingTabs) == '\t'; ++leadingTabs) {
            }
            if (leadingTabs > 0) {
                line = StringUtil.repeatSymbol((char)' ', (int)(tabSize * leadingTabs)) + line.substring(leadingTabs);
            }
            result.add(DocumentationBuilderKit.combUp(line));
        }
        formattedOutput.add((Iterable<String>)result);
    }

    private boolean addTypeAndDescriptionFromDocstring(@NotNull PyNamedParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/jetbrains/python/documentation/PyDocumentationBuilder", "addTypeAndDescriptionFromDocstring"));
        }
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)parameter, PyFunction.class);
        if (function != null) {
            String docString = PyPsiUtils.strValue(function.getDocStringExpression());
            Pair<String, String> typeAndDescr = PyDocumentationBuilder.getTypeAndDescr(docString, parameter);
            String type = (String)typeAndDescr.first;
            String desc = (String)typeAndDescr.second;
            if (type != null) {
                PyType pyType = PyTypeParser.getTypeByName((PsiElement)parameter, type);
                if (pyType instanceof PyClassType) {
                    this.myBody.addItem(": ").addWith(new DocumentationBuilderKit.LinkWrapper("#param#"), DocumentationBuilderKit.$(pyType.getName()));
                } else {
                    this.myBody.addItem(": ").addItem(type);
                }
            }
            if (desc != null) {
                this.myEpilog.addItem("<br>").addItem(desc);
            }
            return type != null;
        }
        return false;
    }

    private static Pair<String, String> getTypeAndDescr(String docString, @NotNull PyNamedParameter followed) {
        if (followed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "followed", "com/jetbrains/python/documentation/PyDocumentationBuilder", "getTypeAndDescr"));
        }
        StructuredDocString structuredDocString = DocStringUtil.parse(docString);
        String type = null;
        String desc = null;
        if (structuredDocString != null) {
            String name = followed.getName();
            type = structuredDocString.getParamType(name);
            desc = structuredDocString.getParamDescription(name);
        }
        return Pair.create(type, desc);
    }

    private void addAttributeDoc() {
        PyClass cls = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyClass.class);
        assert (cls != null);
        String type = PyUtil.isInstanceAttribute((PyExpression)this.myElement) ? "Instance attribute " : "Class attribute ";
        this.myProlog.addItem(type).addWith(DocumentationBuilderKit.TagBold, DocumentationBuilderKit.$(new String[0]).addWith(DocumentationBuilderKit.TagCode, DocumentationBuilderKit.$(((PyTargetExpression)this.myElement).getName()))).addItem(" of class ").addWith(PythonDocumentationProvider.LinkMyClass, DocumentationBuilderKit.$(new String[0]).addWith(DocumentationBuilderKit.TagCode, DocumentationBuilderKit.$(cls.getName()))).addItem("<br>");
        String docString = ((PyTargetExpression)this.myElement).getDocStringValue();
        if (docString != null) {
            PyDocumentationBuilder.addFormattedDocString(this.myElement, docString, this.myBody, this.myEpilog);
        }
    }

    public static String[] removeCommonIndentation(String docstring) {
        String[] lines = LineTokenizer.tokenize((CharSequence)docstring, (boolean)false);
        boolean isFirst = true;
        int cutWidth = Integer.MAX_VALUE;
        int firstIndentedLine = 0;
        for (String frag : lines) {
            if (frag.length() == 0) continue;
            int padWidth = 0;
            Matcher matcher = ourSpacesPattern.matcher(frag);
            if (matcher.find()) {
                padWidth = matcher.end();
            }
            if (isFirst) {
                isFirst = false;
                if (padWidth == 0) {
                    firstIndentedLine = 1;
                    continue;
                }
            }
            if (padWidth >= cutWidth) continue;
            cutWidth = padWidth;
        }
        if (cutWidth > 0 && cutWidth < Integer.MAX_VALUE) {
            for (int i = firstIndentedLine; i < lines.length; ++i) {
                if (lines[i].length() < cutWidth) continue;
                lines[i] = lines[i].substring(cutWidth);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            if (line.startsWith(">>> ")) break;
            result.add(line);
        }
        return result.toArray(new String[result.size()]);
    }

    private void addModulePath(PyFile followed) {
        VirtualFile file = followed.getVirtualFile();
        if (file == null) {
            this.myProlog.addWith(DocumentationBuilderKit.TagSmall, DocumentationBuilderKit.$(PyBundle.message("QDOC.module.path.unknown", new Object[0])));
        } else {
            String path = file.getPath();
            RootFinder finder = new RootFinder(path);
            RootVisitorHost.visitRoots(followed, finder);
            String rootPath = finder.getResult();
            if (rootPath != null) {
                String afterPart = path.substring(rootPath.length());
                this.myProlog.addWith(DocumentationBuilderKit.TagSmall, DocumentationBuilderKit.$(rootPath).addWith(DocumentationBuilderKit.TagBold, DocumentationBuilderKit.$(afterPart)));
            } else {
                this.myProlog.addWith(DocumentationBuilderKit.TagSmall, DocumentationBuilderKit.$(path));
            }
        }
    }

    private static class RootFinder
    implements RootVisitor {
        private String myResult;
        private String myPath;

        private RootFinder(String path) {
            this.myPath = path;
        }

        @Override
        public boolean visitRoot(VirtualFile root, Module module, Sdk sdk, boolean isModuleSource) {
            String vpath = VfsUtilCore.urlToPath((String)root.getUrl());
            if (this.myPath.startsWith(vpath)) {
                this.myResult = vpath;
                return false;
            }
            return true;
        }

        String getResult() {
            return this.myResult;
        }
    }
}

