/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.debugger.PySignatureUtil;
import com.jetbrains.python.documentation.DocStringUtil;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.toolbox.Substring;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDocstringGenerator {
    @NotNull
    private PyDocStringOwner myDocStringOwner;
    @Nullable
    private PyFunction myFunction;
    private List<DocstringParam> myParams;
    private final Project myProject;
    private PyStringLiteralExpression myDocStringExpression;
    private final Map<String, Pair<Integer, Integer>> myParamTypesOffset;
    private PsiFile myFile;
    private boolean myGenerateReturn;

    public PyDocstringGenerator(@NotNull PyDocStringOwner docStringOwner) {
        if (docStringOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docStringOwner", "com/jetbrains/python/documentation/PyDocstringGenerator", "<init>"));
        }
        this.myParams = Lists.newArrayList();
        this.myParamTypesOffset = Maps.newHashMap();
        this.myDocStringOwner = docStringOwner;
        if (docStringOwner instanceof PyFunction) {
            this.myFunction = (PyFunction)docStringOwner;
        }
        this.myProject = this.myDocStringOwner.getProject();
        this.myFile = this.myDocStringOwner.getContainingFile();
    }

    public void addFunctionArguments(@NotNull PyFunction function, @Nullable PySignature signature) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/documentation/PyDocstringGenerator", "addFunctionArguments"));
        }
        for (PyParameter functionParam : function.getParameterList().getParameters()) {
            String type;
            String paramName = functionParam.getName();
            if (functionParam.isSelf() || StringUtil.isEmpty((String)paramName)) continue;
            String string = type = signature != null ? signature.getArgTypeQualifiedName(paramName) : null;
            if (type != null) {
                this.withParamTypedByQualifiedName("type", paramName, type, function);
                continue;
            }
            this.withParam("param", paramName);
        }
    }

    public PyDocstringGenerator withParam(@NotNull String kind, @NotNull String name) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/python/documentation/PyDocstringGenerator", "withParam"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/documentation/PyDocstringGenerator", "withParam"));
        }
        return this.withParamTypedByName(kind, name, null);
    }

    public PyDocstringGenerator withParamTypedByQualifiedName(String kind, String name, @Nullable String type, @NotNull PsiElement anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/documentation/PyDocstringGenerator", "withParamTypedByQualifiedName"));
        }
        String typeName = type != null ? PySignatureUtil.getShortestImportableName(anchor, type) : null;
        return this.withParamTypedByName(kind, name, typeName);
    }

    public PyDocstringGenerator withParamTypedByName(String kind, String name, String type) {
        this.myParams.add(new DocstringParam(kind, name, type));
        return this;
    }

    public void withReturn() {
        this.myGenerateReturn = true;
    }

    private PsiFile getFile() {
        return this.myFile;
    }

    public void startTemplate() {
        assert (this.myDocStringExpression != null);
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)this.myDocStringExpression);
        if (this.myParams.size() > 1) {
            throw new IllegalArgumentException("TemplateBuilder can be created only for one parameter");
        }
        int offset = this.getStartOffset();
        if (offset > 0) {
            builder.replaceRange(TextRange.create((int)offset, (int)this.getEndOffset()), this.getDefaultType());
            Template template = ((TemplateBuilderImpl)builder).buildInlineTemplate();
            VirtualFile virtualFile = this.myFile.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, virtualFile, this.myDocStringExpression.getTextOffset());
            Editor targetEditor = FileEditorManager.getInstance((Project)this.myProject).openTextEditor(descriptor, true);
            if (targetEditor != null) {
                TemplateManager.getInstance(this.myProject).startTemplate(targetEditor, template);
            }
        }
    }

    private String getDefaultType() {
        DocstringParam param = this.getParamToEdit();
        if (StringUtil.isEmpty((String)param.getType())) {
            return "object";
        }
        return param.getType();
    }

    @NotNull
    public String addParamToDocstring() {
        String text = this.getDocstringText();
        StructuredDocString structuredDocString = DocStringUtil.parse(text);
        Collection<DocstringParam> paramsToAdd = PyDocstringGenerator.getParamsToAdd(structuredDocString, this.myParams);
        String[] lines = LineTokenizer.tokenize((CharSequence)text, (boolean)true);
        if (lines.length == 1) {
            String string = this.createSingleLineReplacement(paramsToAdd);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/PyDocstringGenerator", "addParamToDocstring"));
            }
            return string;
        }
        String string = this.createMultiLineReplacement(lines, paramsToAdd);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/PyDocstringGenerator", "addParamToDocstring"));
        }
        return string;
    }

    public boolean haveParametersToAdd() {
        Collection<DocstringParam> paramsToAdd = this.collectParametersToAdd();
        return paramsToAdd.size() > 0;
    }

    private Collection<DocstringParam> collectParametersToAdd() {
        String text = this.getDocstringText();
        StructuredDocString structuredDocString = DocStringUtil.parse(text);
        return PyDocstringGenerator.getParamsToAdd(structuredDocString, this.myParams);
    }

    @NotNull
    private String getDocstringText() {
        PyStringLiteralExpression docstring = this.myDocStringOwner.getDocStringExpression();
        String string = docstring != null ? docstring.getText() : "\"\"\"\"\"\"";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/PyDocstringGenerator", "getDocstringText"));
        }
        return string;
    }

    public static Collection<DocstringParam> getParamsToAdd(final StructuredDocString structuredDocString, List<DocstringParam> params) {
        return Collections2.filter(params, (Predicate)new Predicate<DocstringParam>(){

            public boolean apply(DocstringParam input) {
                Substring s = structuredDocString != null ? structuredDocString.getParamByNameAndKind(input.getName(), input.getKind()) : null;
                return s == null;
            }
        });
    }

    @NotNull
    private String createMultiLineReplacement(String[] lines, Collection<DocstringParam> paramsToAdd) {
        String line;
        int i;
        StringBuilder replacementText = new StringBuilder();
        int ind = lines.length - 1;
        for (i = 0; i != lines.length - 1; ++i) {
            line = lines[i];
            if (this.isPlaceToInsertParameter(line)) {
                ind = i;
                break;
            }
            replacementText.append(line);
        }
        if (replacementText.length() > 0) {
            replacementText.deleteCharAt(replacementText.length() - 1);
        }
        this.addParams(replacementText, false, paramsToAdd);
        for (i = ind; i != lines.length; ++i) {
            line = lines[i];
            replacementText.append(line);
        }
        String string = replacementText.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/PyDocstringGenerator", "createMultiLineReplacement"));
        }
        return string;
    }

    private boolean isPlaceToInsertParameter(String line) {
        return line.contains(this.getPrefix());
    }

    private int addParams(StringBuilder replacementText, boolean addWS, Collection<DocstringParam> paramsToAdd) {
        PyFunction function;
        String returnType;
        PyDocumentationSettings documentationSettings;
        String ws = this.getWhitespace();
        if (!StringUtil.containsAlphaCharacters((String)replacementText.toString())) {
            replacementText.append("\n");
        }
        replacementText.append(ws);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myDocStringOwner);
        if (module != null && (documentationSettings = PyDocumentationSettings.getInstance(module)).isPlain(this.getFile())) {
            return replacementText.length() - 1;
        }
        int i = 0;
        for (DocstringParam param : paramsToAdd) {
            int startOffset;
            replacementText.append(this.getPrefix());
            replacementText.append(param.getKind());
            replacementText.append(" ");
            replacementText.append(param.getName());
            replacementText.append(": ");
            int endOffset = startOffset = replacementText.length();
            if (param.getType() != null) {
                replacementText.append(param.getType());
                endOffset += param.getType().length();
            }
            this.myParamTypesOffset.put(param.getName(), (Pair<Integer, Integer>)Pair.create((Object)startOffset, (Object)endOffset));
            if (++i >= paramsToAdd.size()) continue;
            replacementText.append(ws);
        }
        if (this.myGenerateReturn && this.myDocStringOwner instanceof PyFunction && !(returnType = PythonDocumentationProvider.generateRaiseOrReturn(function = (PyFunction)this.myDocStringOwner, " ", this.getPrefix(), true)).isEmpty()) {
            replacementText.append(ws).append(returnType);
        }
        int offset = replacementText.length();
        if (addWS) {
            replacementText.append(ws);
        } else {
            replacementText.append("\n");
        }
        return offset;
    }

    private String getWhitespace() {
        PsiWhiteSpace whitespace = null;
        if (this.myDocStringOwner instanceof PyFunction) {
            PyStatementList statementList = ((PyFunction)this.myDocStringOwner).getStatementList();
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.getFile());
            if (document != null && this.myFunction != null && statementList.getStatements().length != 0 && document.getLineNumber(statementList.getTextOffset()) != document.getLineNumber(this.myFunction.getTextOffset())) {
                whitespace = (PsiWhiteSpace)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statementList, PsiWhiteSpace.class);
            }
        }
        String ws = "\n";
        if (whitespace != null) {
            String[] spaces = whitespace.getText().split("\n");
            if (spaces.length > 0) {
                ws = ws + spaces[spaces.length - 1];
            }
        } else {
            ws = ws + StringUtil.repeat((String)" ", (int)PyDocstringGenerator.getIndentSize(this.myDocStringOwner));
        }
        return ws;
    }

    @NotNull
    private String createSingleLineReplacement(Collection<DocstringParam> paramsToAdd) {
        String closingQuotes;
        String text = this.getDocstringText();
        StringBuilder replacementText = new StringBuilder();
        if (text.endsWith("'''") || text.endsWith("\"\"\"")) {
            replacementText.append(text.substring(0, text.length() - 3));
            closingQuotes = text.substring(text.length() - 3);
        } else {
            replacementText.append(text.substring(0, text.length()));
            closingQuotes = text.substring(text.length() - 1);
        }
        this.addParams(replacementText, true, paramsToAdd);
        replacementText.append(closingQuotes);
        String string = replacementText.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/PyDocstringGenerator", "createSingleLineReplacement"));
        }
        return string;
    }

    public String docStringAsText() {
        return this.addParamToDocstring();
    }

    public int getStartOffset() {
        Pair<Integer, Integer> offsets = this.getOffsets();
        return offsets != null ? (Integer)offsets.first : -1;
    }

    private Pair<Integer, Integer> getOffsets() {
        DocstringParam paramToEdit = this.getParamToEdit();
        String paramName = paramToEdit.getName();
        return this.myParamTypesOffset.get(paramName);
    }

    private DocstringParam getParamToEdit() {
        if (this.myParams.size() == 0) {
            throw new IllegalStateException("We should have at least one param to edit");
        }
        return this.myParams.get(0);
    }

    public int getEndOffset() {
        Pair<Integer, Integer> offsets = this.getOffsets();
        return offsets != null ? (Integer)offsets.second : -1;
    }

    public void build() {
        this.myDocStringExpression = this.myDocStringOwner.getDocStringExpression();
        String replacement = this.addParamToDocstring();
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(this.myProject);
        if (this.myDocStringExpression != null) {
            PyDocStringOwner owner;
            PyExpression str = elementGenerator.createDocstring(replacement).getExpression();
            this.myDocStringExpression.replace((PsiElement)str);
            if (this.myFunction != null) {
                this.myFunction = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(this.myFunction);
            }
            if ((owner = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(this.myDocStringOwner)) != null) {
                this.myDocStringOwner = owner;
            }
            this.myDocStringExpression = this.myDocStringOwner.getDocStringExpression();
        } else {
            if (this.myFunction == null) {
                throw new IllegalStateException("Should be a function");
            }
            PyStatementList list = this.myFunction.getStatementList();
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.getFile());
            if (document != null) {
                if (document.getLineNumber(list.getTextOffset()) == document.getLineNumber(this.myFunction.getTextOffset()) || list.getStatements().length == 0) {
                    PyFunction func = elementGenerator.createFromText(LanguageLevel.forElement(this.myFunction), PyFunction.class, "def " + this.myFunction.getName() + this.myFunction.getParameterList().getText() + ":\n" + StringUtil.repeat((String)" ", (int)PyDocstringGenerator.getIndentSize(this.myFunction)) + replacement + "\n" + StringUtil.repeat((String)" ", (int)PyDocstringGenerator.getIndentSize(this.myFunction)) + list.getText());
                    this.myFunction = (PyFunction)this.myFunction.replace(func);
                } else {
                    PyExpressionStatement str = elementGenerator.createDocstring(replacement);
                    list.addBefore((PsiElement)str, (PsiElement)list.getStatements()[0]);
                }
            }
            this.myFunction = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(this.myFunction);
            if (this.myFunction != null) {
                this.myDocStringExpression = this.myFunction.getDocStringExpression();
            }
        }
    }

    private static int getIndentSize(PyDocStringOwner function) {
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyleSettingsManager.getInstance((Project)function.getProject()).getCurrentSettings().getIndentOptions((FileType)PythonFileType.INSTANCE);
        PyStatementList statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)function, PyStatementList.class);
        int indent = 1;
        while (statementList != null) {
            statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)statementList, PyStatementList.class);
            ++indent;
        }
        return indent * indentOptions.TAB_SIZE;
    }

    private String getPrefix() {
        String prefix = ":";
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myDocStringOwner);
        if (module == null) {
            return prefix;
        }
        PyDocumentationSettings documentationSettings = PyDocumentationSettings.getInstance(module);
        if (documentationSettings.isEpydocFormat(this.getFile())) {
            prefix = "@";
        }
        return prefix;
    }

    public PyDocstringGenerator withSignatures() {
        if (this.myFunction != null) {
            PySignature signature = PySignatureCacheManager.getInstance(this.myProject).findSignature(this.myFunction);
            this.addFunctionArguments(this.myFunction, signature);
        }
        return this;
    }

    public static class DocstringParam {
        private String myKind;
        private String myName;
        private String myType;

        private DocstringParam(@NotNull String kind, @NotNull String name, @Nullable String type) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/python/documentation/PyDocstringGenerator$DocstringParam", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/documentation/PyDocstringGenerator$DocstringParam", "<init>"));
            }
            this.myKind = kind;
            this.myName = name;
            this.myType = type;
        }

        public String getKind() {
            return this.myKind;
        }

        public String getName() {
            return this.myName;
        }

        public String getType() {
            return this.myType;
        }
    }
}

