/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.util.XmlTagUtilBase;
import com.jetbrains.python.documentation.StructuredDocStringBase;
import com.jetbrains.python.toolbox.Substring;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EpydocString
extends StructuredDocStringBase {
    public static String[] RTYPE_TAGS = new String[]{"rtype", "returntype"};
    public static String[] KEYWORD_ARGUMENT_TAGS = new String[]{"keyword", "kwarg", "kwparam"};
    public static String[] ALL_TAGS = new String[]{"@param", "@type", "@return", "@rtype", "@keyword", "@raise", "@ivar", "@cvar", "@var", "@group", "@sort", "@note", "@attention", "@bug", "@warning", "@version", "@todo", "@deprecated", "@since", "@status", "@change", "@permission", "@requires", "@precondition", "@postcondition", "@invariant", "@author", "@organization", "@copyright", "@license", "@contact", "@summary", "@see"};
    public static String[] ADDITIONAL = new String[]{"group", "sort", "note", "attention", "bug", "warning", "version", "todo", "deprecated", "since", "status", "change", "permission", "requires", "precondition", "postcondition", "invariant", "author", "organization", "copyright", "license", "contact", "summary", "see"};

    public EpydocString() {
        this("");
    }

    public EpydocString(@NotNull String docstringText) {
        if (docstringText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docstringText", "com/jetbrains/python/documentation/EpydocString", "<init>"));
        }
        super(docstringText, "@");
    }

    @Override
    public String getDescription() {
        String html = EpydocString.inlineMarkupToHTML(this.myDescription);
        assert (html != null);
        return html;
    }

    @Override
    public List<String> getParameters() {
        return EpydocString.toUniqueStrings(this.getParameterSubstrings());
    }

    @Override
    public List<String> getKeywordArguments() {
        return EpydocString.toUniqueStrings(this.getKeywordArgumentSubstrings());
    }

    @Override
    @Nullable
    public String getReturnType() {
        return EpydocString.removeInlineMarkup(this.getReturnTypeSubstring());
    }

    @Override
    public String getReturnDescription() {
        return EpydocString.inlineMarkupToHTML(this.getTagValue(RETURN_TAGS));
    }

    @Override
    @Nullable
    public String getParamType(@Nullable String paramName) {
        return EpydocString.removeInlineMarkup(this.getParamTypeSubstring(paramName));
    }

    @Override
    @Nullable
    public String getParamDescription(@Nullable String paramName) {
        if (paramName == null) {
            return null;
        }
        Substring value = this.getTagValue(PARAM_TAGS, paramName);
        if (value == null) {
            value = this.getTagValue(PARAM_TAGS, "*" + paramName);
        }
        if (value == null) {
            value = this.getTagValue(PARAM_TAGS, "**" + paramName);
        }
        return EpydocString.inlineMarkupToHTML(value);
    }

    @Override
    @Nullable
    public String getKeywordArgumentDescription(@Nullable String paramName) {
        if (paramName == null) {
            return null;
        }
        return EpydocString.inlineMarkupToHTML(this.getTagValue(KEYWORD_ARGUMENT_TAGS, paramName));
    }

    @Override
    public List<String> getRaisedExceptions() {
        return EpydocString.toUniqueStrings(this.getTagArguments(RAISES_TAGS));
    }

    @Override
    public String getRaisedExceptionDescription(@Nullable String exceptionName) {
        if (exceptionName == null) {
            return null;
        }
        return EpydocString.removeInlineMarkup(this.getTagValue(RAISES_TAGS, exceptionName));
    }

    @Override
    public String getAttributeDescription() {
        Substring value = this.getTagValue(VARIABLE_TAGS);
        return EpydocString.convertInlineMarkup(value != null ? value.toString() : null, true);
    }

    @Nullable
    public static String removeInlineMarkup(@Nullable String s) {
        return EpydocString.convertInlineMarkup(s, false);
    }

    @Nullable
    private static String removeInlineMarkup(@Nullable Substring s) {
        return EpydocString.convertInlineMarkup(s != null ? s.concatTrimmedLines(" ") : null, false);
    }

    @Nullable
    private static String convertInlineMarkup(@Nullable String s, boolean toHTML) {
        if (s == null) {
            return null;
        }
        MarkupConverter converter = toHTML ? new HTMLConverter() : new MarkupConverter();
        converter.appendWithMarkup(s);
        return converter.result();
    }

    private static int findMatchingEndBrace(String s, int bracePos) {
        int braceCount = 1;
        for (int pos = bracePos + 1; pos < s.length(); ++pos) {
            char c = s.charAt(pos);
            if (c == '{') {
                ++braceCount;
                continue;
            }
            if (c != '}' || --braceCount != 0) continue;
            return pos;
        }
        return -1;
    }

    private static String joinLines(String s, boolean addSpace) {
        int lineBreakStart;
        while ((lineBreakStart = s.indexOf(10)) >= 0) {
            int lineBreakEnd;
            int blankLines = 0;
            for (lineBreakEnd = lineBreakStart + 1; lineBreakEnd < s.length() && (s.charAt(lineBreakEnd) == ' ' || s.charAt(lineBreakEnd) == '\n'); ++lineBreakEnd) {
                if (s.charAt(lineBreakEnd) != '\n') continue;
                ++blankLines;
            }
            if (addSpace) {
                String separator = blankLines > 0 ? "<p>" : " ";
                s = s.substring(0, lineBreakStart) + separator + s.substring(lineBreakEnd);
                continue;
            }
            s = s.substring(0, lineBreakStart) + s.substring(lineBreakEnd);
        }
        return s;
    }

    @Nullable
    public static String inlineMarkupToHTML(@Nullable String s) {
        return EpydocString.convertInlineMarkup(s, true);
    }

    @Nullable
    private static String inlineMarkupToHTML(@Nullable Substring s) {
        String text = "";
        if (s != null && !(text = s.concatTrimmedLines(" ")).endsWith(".")) {
            text = text + ".";
        }
        return EpydocString.inlineMarkupToHTML(text);
    }

    @Override
    public List<String> getAdditionalTags() {
        ArrayList<String> list = new ArrayList<String>();
        for (String tagName : ADDITIONAL) {
            Map map = (Map)this.myArgTagValues.get(tagName);
            if (map == null) continue;
            list.add(tagName);
        }
        return list;
    }

    @Override
    public List<Substring> getKeywordArgumentSubstrings() {
        return this.getTagArguments(KEYWORD_ARGUMENT_TAGS);
    }

    @Override
    public Substring getReturnTypeSubstring() {
        return this.getTagValue(RTYPE_TAGS);
    }

    @Override
    public Substring getParamTypeSubstring(@Nullable String paramName) {
        return paramName == null ? this.getTagValue("type") : this.getTagValue("type", paramName);
    }

    private static class HTMLConverter
    extends MarkupConverter {
        private HTMLConverter() {
        }

        @Override
        protected void appendText(String text) {
            this.myResult.append(EpydocString.joinLines(XmlTagUtilBase.escapeString((String)text, (boolean)false), true));
        }

        @Override
        protected void appendMarkup(char markupChar, String markupContent) {
            if (markupChar == 'U') {
                this.appendLink(markupContent);
                return;
            }
            switch (markupChar) {
                case 'I': {
                    this.appendTagPair(markupContent, "i");
                    break;
                }
                case 'B': {
                    this.appendTagPair(markupContent, "b");
                    break;
                }
                case 'C': {
                    this.appendTagPair(markupContent, "code");
                    break;
                }
                default: {
                    this.myResult.append(StringUtil.escapeXml((String)markupContent));
                }
            }
        }

        private void appendTagPair(String markupContent, String tagName) {
            this.myResult.append("<").append(tagName).append(">");
            this.appendWithMarkup(markupContent);
            this.myResult.append("</").append(tagName).append(">");
        }

        private void appendLink(String markupContent) {
            String linkText;
            String linkUrl = linkText = StringUtil.escapeXml((String)markupContent);
            int pos = markupContent.indexOf(60);
            if (pos >= 0 && markupContent.endsWith(">")) {
                linkText = StringUtil.escapeXml((String)markupContent.substring(0, pos).trim());
                linkUrl = EpydocString.joinLines(StringUtil.escapeXml((String)markupContent.substring(pos + 1, markupContent.length() - 1)), false);
            }
            this.myResult.append("<a href=\"");
            if (!linkUrl.matches("[a-z]+:.+")) {
                this.myResult.append("http://");
            }
            this.myResult.append(linkUrl).append("\">").append(linkText).append("</a>");
        }
    }

    private static class MarkupConverter {
        protected final StringBuilder myResult = new StringBuilder();

        private MarkupConverter() {
        }

        public void appendWithMarkup(String s) {
            int bracePos;
            int pos = 0;
            while ((bracePos = s.indexOf(123, pos)) >= 1) {
                char prevChar = s.charAt(bracePos - 1);
                if (prevChar >= 'A' && prevChar <= 'Z') {
                    this.appendText(s.substring(pos, bracePos - 1));
                    int rbracePos = EpydocString.findMatchingEndBrace(s, bracePos);
                    if (rbracePos < 0) {
                        pos = bracePos + 1;
                        break;
                    }
                    String inlineMarkupContent = s.substring(bracePos + 1, rbracePos);
                    this.appendMarkup(prevChar, inlineMarkupContent);
                    pos = rbracePos + 1;
                    continue;
                }
                this.appendText(s.substring(pos, bracePos + 1));
                pos = bracePos + 1;
            }
            this.appendText(s.substring(pos));
        }

        protected void appendText(String text) {
            this.myResult.append(text);
        }

        protected void appendMarkup(char markupChar, String markupContent) {
            this.appendWithMarkup(markupContent);
        }

        public String result() {
            return this.myResult.toString();
        }
    }
}

