/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.psi.PsiElement;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.toolbox.ChainIterable;
import com.jetbrains.python.toolbox.FP;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class DocumentationBuilderKit {
    static final TagWrapper TagBold = new TagWrapper("b");
    static final TagWrapper TagItalic = new TagWrapper("i");
    static final TagWrapper TagSmall = new TagWrapper("small");
    static final TagWrapper TagCode = new TagWrapper("code");
    static final FP.Lambda1<String, String> LCombUp = new FP.Lambda1<String, String>(){

        @Override
        public String apply(String argname) {
            return DocumentationBuilderKit.combUp(argname);
        }
    };
    @NonNls
    static final String BR = "<br>";
    static final FP.Lambda1<String, String> LSame1 = new FP.Lambda1<String, String>(){

        @Override
        public String apply(String name) {
            return name;
        }
    };
    static final FP.Lambda1<Iterable<String>, Iterable<String>> LSame2 = new FP.Lambda1<Iterable<String>, Iterable<String>>(){

        @Override
        public Iterable<String> apply(Iterable<String> what) {
            return what;
        }
    };
    public static FP.Lambda1<PyExpression, String> LReadableRepr = new FP.Lambda1<PyExpression, String>(){

        @Override
        public String apply(PyExpression arg) {
            return PyUtil.getReadableRepr((PsiElement)arg, true);
        }
    };

    private DocumentationBuilderKit() {
    }

    static ChainIterable<String> wrapInTag(String tag, Iterable<String> content) {
        return new ChainIterable<String>("<" + tag + ">").add(content).addItem("</" + tag + ">");
    }

    @NonNls
    static String combUp(@NonNls String what) {
        return XmlStringUtil.escapeString((String)what).replace("\n", BR).replace(" ", "&nbsp;");
    }

    static ChainIterable<String> $(String ... content) {
        return new ChainIterable<List<String>>(Arrays.asList(content));
    }

    static <T> Iterable<T> interleave(Iterable<T> source, T filler) {
        LinkedList<T> ret = new LinkedList<T>();
        boolean is_next = false;
        for (T what : source) {
            if (is_next) {
                ret.add(filler);
            } else {
                is_next = true;
            }
            ret.add(what);
        }
        return ret;
    }

    static class LinkWrapper
    implements FP.Lambda1<Iterable<String>, Iterable<String>> {
        private String myLink;

        LinkWrapper(String link) {
            this.myLink = link;
        }

        @Override
        public Iterable<String> apply(Iterable<String> contents) {
            return new ChainIterable<String>().addItem("<a href=\"").addItem("psi_element://").addItem(this.myLink).addItem("\">").add(contents).addItem("</a>");
        }
    }

    static class TagWrapper
    implements FP.Lambda1<Iterable<String>, Iterable<String>> {
        private final String myTag;

        TagWrapper(String tag) {
            this.myTag = tag;
        }

        @Override
        public Iterable<String> apply(Iterable<String> contents) {
            return DocumentationBuilderKit.wrapInTag(this.myTag, contents);
        }
    }
}

