/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.documentation.EpydocString;
import com.jetbrains.python.documentation.SphinxDocString;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocStringUtil {
    private DocStringUtil() {
    }

    @Nullable
    public static String getDocStringValue(@NotNull PyDocStringOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/jetbrains/python/documentation/DocStringUtil", "getDocStringValue"));
        }
        return PyPsiUtils.strValue(owner.getDocStringExpression());
    }

    @Nullable
    public static StructuredDocString parse(@Nullable String text) {
        if (text == null) {
            return null;
        }
        if (DocStringUtil.isSphinxDocString(text)) {
            return new SphinxDocString(text);
        }
        return new EpydocString(text);
    }

    public static boolean isSphinxDocString(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/documentation/DocStringUtil", "isSphinxDocString"));
        }
        return text.contains(":param ") || text.contains(":rtype") || text.contains(":type");
    }

    public static boolean isEpydocDocString(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/documentation/DocStringUtil", "isEpydocDocString"));
        }
        return text.contains("@param ") || text.contains("@rtype") || text.contains("@type");
    }

    @Nullable
    public static PyStringLiteralExpression findDocStringExpression(@Nullable PyElement parent) {
        if (parent != null) {
            PsiElement seeker = PyUtil.getFirstNonCommentAfter(parent.getFirstChild());
            if (seeker instanceof PyExpressionStatement) {
                seeker = PyUtil.getFirstNonCommentAfter(seeker.getFirstChild());
            }
            if (seeker instanceof PyStringLiteralExpression) {
                return (PyStringLiteralExpression)seeker;
            }
        }
        return null;
    }

    public static StructuredDocString getStructuredDocString(PyDocStringOwner owner) {
        return DocStringUtil.parse(owner.getDocStringValue());
    }

    public static boolean isDocStringExpression(@Nullable PyExpression expression) {
        PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)expression, PyDocStringOwner.class);
        if (docStringOwner != null && docStringOwner.getDocStringExpression() == expression) {
            return true;
        }
        if (expression instanceof PyStringLiteralExpression) {
            return DocStringUtil.isVariableDocString((PyStringLiteralExpression)expression);
        }
        return false;
    }

    @Nullable
    public static String getAttributeDocComment(@NotNull PyTargetExpression attr) {
        if (attr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attr", "com/jetbrains/python/documentation/DocStringUtil", "getAttributeDocComment"));
        }
        if (attr.getParent() instanceof PyAssignmentStatement) {
            PsiElement prevSibling;
            PyAssignmentStatement assignment = (PyAssignmentStatement)attr.getParent();
            for (prevSibling = assignment.getPrevSibling(); prevSibling != null && prevSibling instanceof PsiWhiteSpace; prevSibling = prevSibling.getPrevSibling()) {
            }
            if (prevSibling instanceof PsiComment && prevSibling.getText().startsWith("#:")) {
                return prevSibling.getText().substring(2);
            }
        }
        return null;
    }

    public static boolean isVariableDocString(@NotNull PyStringLiteralExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/python/documentation/DocStringUtil", "isVariableDocString"));
        }
        PsiElement parent = expr.getParent();
        if (!(parent instanceof PyExpressionStatement)) {
            return false;
        }
        PsiElement prevElement = parent.getPrevSibling();
        while (prevElement instanceof PsiWhiteSpace || prevElement instanceof PsiComment) {
            prevElement = prevElement.getPrevSibling();
        }
        if (prevElement instanceof PyAssignmentStatement) {
            if (expr.getText().contains("type:")) {
                return true;
            }
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)prevElement;
            ScopeOwner scope = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)prevElement, ScopeOwner.class);
            if (scope instanceof PyClass || scope instanceof PyFile) {
                return true;
            }
            if (scope instanceof PyFunction) {
                for (PyExpression target : assignmentStatement.getTargets()) {
                    if (!PyUtil.isInstanceAttribute(target)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

