/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyImportedModuleType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocStringTypeReference
extends PsiPolyVariantReferenceBase<PsiElement> {
    @Nullable
    private PyType myType;
    @NotNull
    private TextRange myFullRange;
    @Nullable
    private final PyImportElement myImportElement;

    public DocStringTypeReference(PsiElement element, TextRange range, @NotNull TextRange fullRange, @Nullable PyType type, @Nullable PyImportElement importElement) {
        if (fullRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullRange", "com/jetbrains/python/documentation/DocStringTypeReference", "<init>"));
        }
        super(element, range);
        this.myFullRange = fullRange;
        this.myType = type;
        this.myImportElement = importElement;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/documentation/DocStringTypeReference", "bindToElement"));
        }
        if (element.equals(this.resolve())) {
            return element;
        }
        if (this.myElement instanceof PyStringLiteralExpression && element instanceof PyClass) {
            PyStringLiteralExpression e = (PyStringLiteralExpression)this.myElement;
            PyClass cls = (PyClass)element;
            QualifiedName qname = QualifiedNameFinder.findCanonicalImportPath(cls, element);
            if (qname != null) {
                qname = qname.append(cls.getName());
                ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)e);
                this.myType = new PyClassTypeImpl(cls, false);
                return manipulator.handleContentChange((PsiElement)e, this.myFullRange, qname.toString());
            }
        }
        return null;
    }

    public boolean isSoft() {
        return false;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (newElementName.endsWith(".py")) {
            newElementName = newElementName.substring(0, newElementName.length() - ".py".length());
        }
        return super.handleElementRename(newElementName);
    }

    public boolean isReferenceTo(PsiElement element) {
        if (this.myType instanceof PyImportedModuleType) {
            return element.equals(PyUtil.turnInitIntoDir(this.resolve()));
        }
        return super.isReferenceTo(element);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PyDocStringOwner result = null;
        ResolveResultList results = new ResolveResultList();
        if (this.myType instanceof PyClassType) {
            result = ((PyClassType)this.myType).getPyClass();
        } else if (this.myType instanceof PyImportedModuleType) {
            result = ((PyImportedModuleType)this.myType).getImportedModule().resolve();
        } else if (this.myType instanceof PyModuleType) {
            result = ((PyModuleType)this.myType).getModule();
        }
        if (result != null) {
            if (this.myImportElement != null) {
                results.add(new ImportedResolveResult((PsiElement)result, 0, Collections.singletonList(this.myImportElement)));
            } else {
                results.poke((PsiElement)result, 0);
            }
        }
        ResolveResult[] resolveResultArray = results.toArray(new ResolveResult[0]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/DocStringTypeReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        PsiFile file = this.myElement.getContainingFile();
        ArrayList variants = Lists.newArrayList((Object[])new Object[]{"str", "int", "basestring", "bool", "buffer", "bytearray", "complex", "dict", "tuple", "enumerate", "file", "float", "frozenset", "list", "long", "set", "object"});
        if (file instanceof PyFile) {
            variants.addAll(((PyFile)file).getTopLevelClasses());
            List<PyFromImportStatement> fromImports = ((PyFile)file).getFromImports();
            for (PyFromImportStatement fromImportStatement : fromImports) {
                PyImportElement[] elements;
                for (PyImportElement element : elements = fromImportStatement.getImportElements()) {
                    PyType type;
                    PyReferenceExpression referenceExpression = element.getImportReferenceExpression();
                    if (referenceExpression == null || !((type = TypeEvalContext.userInitiated(file.getProject(), CompletionUtil.getOriginalOrSelf(file)).getType(referenceExpression)) instanceof PyClassType)) continue;
                    variants.add(((PyClassType)type).getPyClass());
                }
            }
        }
        Object[] objectArray = variants.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/DocStringTypeReference", "getVariants"));
        }
        return objectArray;
    }
}

