/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.documentation.EpydocString;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.SphinxDocString;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.NotNull;

public class DocStringTagCompletionContributor
extends CompletionContributor {
    public static final PsiElementPattern.Capture<PyStringLiteralExpression> DOCSTRING_PATTERN = (PsiElementPattern.Capture)PlatformPatterns.psiElement(PyStringLiteralExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PyExpressionStatement.class).inside(PyDocStringOwner.class));

    public DocStringTagCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(DOCSTRING_PATTERN), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiFile file;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/documentation/DocStringTagCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/documentation/DocStringTagCompletionContributor$1", "addCompletions"));
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)parameters.getPosition());
                if (module == null) {
                    return;
                }
                PyDocumentationSettings settings = PyDocumentationSettings.getInstance(module);
                if (settings.isEpydocFormat(file = parameters.getOriginalFile()) || settings.isReSTFormat(file)) {
                    String[] allTags;
                    char prefix;
                    int offset = parameters.getOffset();
                    String text = file.getText();
                    char c = prefix = settings.isEpydocFormat(file) ? (char)'@' : ':';
                    if (offset > 0) {
                        --offset;
                    }
                    StringBuilder prefixBuilder = new StringBuilder();
                    while (offset > 0 && (Character.isLetterOrDigit(text.charAt(offset)) || text.charAt(offset) == prefix)) {
                        prefixBuilder.insert(0, text.charAt(offset));
                        if (text.charAt(offset) == prefix) {
                            --offset;
                            break;
                        }
                        --offset;
                    }
                    while (offset > 0 && text.charAt(--offset) != '\n' && text.charAt(offset) != '\"' && text.charAt(offset) != '\'') {
                        if (Character.isWhitespace(text.charAt(offset))) continue;
                        return;
                    }
                    String[] stringArray = allTags = settings.isEpydocFormat(file) ? EpydocString.ALL_TAGS : SphinxDocString.ALL_TAGS;
                    if (prefixBuilder.length() > 0) {
                        result = result.withPrefixMatcher(prefixBuilder.toString());
                    }
                    for (String tag : allTags) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)tag));
                    }
                }
            }
        });
    }
}

