/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.documentation.DocStringParameterReference;
import com.jetbrains.python.documentation.DocStringTypeReference;
import com.jetbrains.python.documentation.DocStringUtil;
import com.jetbrains.python.documentation.StructuredDocStringBase;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.toolbox.Substring;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocStringReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/documentation/DocStringReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/documentation/DocStringReferenceProvider", "getReferencesByElement"));
        }
        PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PyDocStringOwner.class);
        if (docStringOwner != null && element == docStringOwner.getDocStringExpression()) {
            PyStringLiteralExpression expr = (PyStringLiteralExpression)element;
            List<TextRange> ranges = expr.getStringValueTextRanges();
            String exprText = expr.getText();
            TextRange textRange = PyStringLiteralExpressionImpl.getNodeTextRange(exprText);
            String text = textRange.substring(exprText);
            if (!ranges.isEmpty()) {
                ArrayList<PsiReference> result = new ArrayList<PsiReference>();
                int offset = ranges.get(0).getStartOffset();
                StructuredDocString docString = DocStringUtil.parse(text);
                if (docString != null) {
                    result.addAll(DocStringReferenceProvider.referencesFromNames(expr, offset, docString, docString.getTagArguments(StructuredDocStringBase.PARAM_TAGS), StructuredDocStringBase.ReferenceType.PARAMETER));
                    result.addAll(DocStringReferenceProvider.referencesFromNames(expr, offset, docString, docString.getTagArguments(StructuredDocStringBase.PARAM_TYPE_TAGS), StructuredDocStringBase.ReferenceType.PARAMETER_TYPE));
                    result.addAll(DocStringReferenceProvider.referencesFromNames(expr, offset, docString, docString.getKeywordArgumentSubstrings(), StructuredDocStringBase.ReferenceType.KEYWORD));
                    result.addAll(DocStringReferenceProvider.referencesFromNames(expr, offset, docString, docString.getTagArguments("var"), StructuredDocStringBase.ReferenceType.VARIABLE));
                    result.addAll(DocStringReferenceProvider.referencesFromNames(expr, offset, docString, docString.getTagArguments("cvar"), StructuredDocStringBase.ReferenceType.CLASS_VARIABLE));
                    result.addAll(DocStringReferenceProvider.referencesFromNames(expr, offset, docString, docString.getTagArguments("ivar"), StructuredDocStringBase.ReferenceType.INSTANCE_VARIABLE));
                    result.addAll(DocStringReferenceProvider.returnTypes(element, docString, offset));
                }
                PsiReference[] psiReferenceArray = result.toArray(new PsiReference[result.size()]);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/DocStringReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/DocStringReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static List<PsiReference> returnTypes(PsiElement element, StructuredDocString docString, int offset) {
        ArrayList<PsiReference> result = new ArrayList<PsiReference>();
        Substring rtype = docString.getReturnTypeSubstring();
        if (rtype != null) {
            result.addAll(DocStringReferenceProvider.parseTypeReferences(element, rtype, offset));
        }
        return result;
    }

    private static List<PsiReference> referencesFromNames(PyStringLiteralExpression element, int offset, StructuredDocString docString, List<Substring> paramNames, StructuredDocStringBase.ReferenceType refType) {
        ArrayList<PsiReference> result = new ArrayList<PsiReference>();
        for (Substring name : paramNames) {
            Substring type;
            String s = name.toString();
            if (PyNames.isIdentifier(s)) {
                TextRange range = name.getTextRange().shiftRight(offset);
                result.add(new DocStringParameterReference(element, range, refType));
            }
            if (!refType.equals((Object)StructuredDocStringBase.ReferenceType.PARAMETER_TYPE) || (type = docString.getParamTypeSubstring(s)) == null) continue;
            result.addAll(DocStringReferenceProvider.parseTypeReferences(element, type, offset));
        }
        return result;
    }

    private static List<PsiReference> parseTypeReferences(PsiElement anchor, Substring s, int offset) {
        ArrayList<PsiReference> result = new ArrayList<PsiReference>();
        PyTypeParser.ParseResult parseResult = PyTypeParser.parse(anchor, s.toString());
        Map<TextRange, ? extends PyType> types = parseResult.getTypes();
        if (types.isEmpty()) {
            result.add((PsiReference)new DocStringTypeReference(anchor, s.getTextRange().shiftRight(offset), s.getTextRange().shiftRight(offset), null, null));
        }
        offset = s.getTextRange().getStartOffset() + offset;
        Map<? extends PyType, TextRange> fullRanges = parseResult.getFullRanges();
        for (Map.Entry<TextRange, ? extends PyType> pair : types.entrySet()) {
            PyType t = pair.getValue();
            TextRange range = pair.getKey().shiftRight(offset);
            TextRange fullRange = fullRanges.containsKey(t) ? fullRanges.get(t).shiftRight(offset) : range;
            PyImportElement importElement = parseResult.getImports().get(t);
            result.add((PsiReference)new DocStringTypeReference(anchor, range, fullRange, t, importElement));
        }
        return result;
    }

    @Nullable
    public static TextRange findNextTag(String docString, int pos, String[] paramTags) {
        int result = Integer.MAX_VALUE;
        String foundTag = null;
        for (String paramTag : paramTags) {
            int tagPos = docString.indexOf(paramTag, pos);
            while (tagPos >= 0 && tagPos + paramTag.length() < docString.length() && Character.isLetterOrDigit(docString.charAt(tagPos + paramTag.length()))) {
                tagPos = docString.indexOf(paramTag, tagPos + 1);
            }
            if (tagPos < 0 || tagPos >= result) continue;
            foundTag = paramTag;
            result = tagPos;
        }
        return foundTag == null ? null : new TextRange(result, result + foundTag.length());
    }
}

