/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.Lists;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.documentation.StructuredDocStringBase;
import com.jetbrains.python.psi.PsiReferenceEx;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocStringParameterReference
extends PsiReferenceBase<PyStringLiteralExpression>
implements PsiReferenceEx {
    private final StructuredDocStringBase.ReferenceType myType;

    public DocStringParameterReference(PyStringLiteralExpression element, TextRange range, StructuredDocStringBase.ReferenceType refType) {
        super((PsiElement)element, range);
        this.myType = refType;
    }

    public PsiElement resolve() {
        PyDocStringOwner owner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyDocStringOwner.class);
        if (owner instanceof PyFunction) {
            return this.resolveParameter((PyFunction)owner);
        }
        if (owner instanceof PyClass) {
            PyFunction init = ((PyClass)owner).findMethodByName("__init__", false);
            if (init != null) {
                PsiElement element = this.resolveParameter(init);
                if (element == null && (this.myType.equals((Object)StructuredDocStringBase.ReferenceType.CLASS_VARIABLE) || this.myType.equals((Object)StructuredDocStringBase.ReferenceType.PARAMETER_TYPE))) {
                    element = this.resolveClassVariable((PyClass)owner);
                }
                if (element == null && (this.myType.equals((Object)StructuredDocStringBase.ReferenceType.INSTANCE_VARIABLE) || this.myType.equals((Object)StructuredDocStringBase.ReferenceType.PARAMETER_TYPE))) {
                    element = this.resolveInstanceVariable((PyClass)owner);
                }
                return element;
            }
            if (this.myType.equals((Object)StructuredDocStringBase.ReferenceType.CLASS_VARIABLE) || this.myType.equals((Object)StructuredDocStringBase.ReferenceType.PARAMETER_TYPE)) {
                return this.resolveClassVariable((PyClass)owner);
            }
            if (this.myType.equals((Object)StructuredDocStringBase.ReferenceType.INSTANCE_VARIABLE) || this.myType.equals((Object)StructuredDocStringBase.ReferenceType.PARAMETER_TYPE)) {
                return this.resolveInstanceVariable((PyClass)owner);
            }
        }
        return null;
    }

    @Nullable
    private PsiElement resolveInstanceVariable(PyClass owner) {
        List<PyTargetExpression> attributes = owner.getInstanceAttributes();
        for (PyTargetExpression element : attributes) {
            if (!this.getCanonicalText().equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private PsiElement resolveClassVariable(@NotNull PyClass owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/jetbrains/python/documentation/DocStringParameterReference", "resolveClassVariable"));
        }
        List<PyTargetExpression> attributes = owner.getClassAttributes();
        for (PyTargetExpression element : attributes) {
            if (!this.getCanonicalText().equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private PsiElement resolveParameter(PyFunction owner) {
        PyParameterList parameterList = owner.getParameterList();
        PyNamedParameter resolved = parameterList.findParameterByName(this.getCanonicalText());
        if (resolved != null) {
            return resolved;
        }
        for (PyParameter parameter : parameterList.getParameters()) {
            PyNamedParameter namedParameter;
            if (!(parameter instanceof PyNamedParameter) || !(namedParameter = (PyNamedParameter)parameter).isKeywordContainer() && !namedParameter.isPositionalContainer()) continue;
            return namedParameter;
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        PyDocStringOwner owner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyDocStringOwner.class);
        if (owner instanceof PyFunction) {
            ArrayList result = Lists.newArrayList();
            List<PyNamedParameter> namedParameters = ParamHelper.collectNamedParameters(((PyFunction)owner).getParameterList());
            HashSet usedParameters = new HashSet();
            PyStringLiteralExpression expression = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyStringLiteralExpression.class, (boolean)false);
            if (expression != null) {
                PsiReference[] references;
                for (PsiReference ref : references = expression.getReferences()) {
                    if (!(ref instanceof DocStringParameterReference) || !((DocStringParameterReference)ref).getType().equals((Object)this.myType)) continue;
                    usedParameters.add(ref.getCanonicalText());
                }
            }
            for (PyNamedParameter param : namedParameters) {
                if (usedParameters.contains(param.getName())) continue;
                result.add(param);
            }
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)result);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/DocStringParameterReference", "getVariants"));
            }
            return objectArray;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/DocStringParameterReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public StructuredDocStringBase.ReferenceType getType() {
        return this.myType;
    }

    @Override
    @Nullable
    public HighlightSeverity getUnresolvedHighlightSeverity(TypeEvalContext context) {
        return HighlightSeverity.WEAK_WARNING;
    }

    @Override
    @Nullable
    public String getUnresolvedDescription() {
        PyDocStringOwner owner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyDocStringOwner.class);
        if (owner instanceof PyFunction) {
            PyFunction function = (PyFunction)owner;
            return "Function '" + function.getName() + "' does not have a parameter '" + this.getCanonicalText() + "'";
        }
        return null;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        TextRange range = this.getRangeInElement();
        Pair<String, String> quotes = PythonStringUtil.getQuotes(range.substring(((PyStringLiteralExpression)this.myElement).getText()));
        if (quotes != null) {
            range = TextRange.create((int)(range.getStartOffset() + ((String)quotes.first).length()), (int)(range.getEndOffset() - ((String)quotes.second).length()));
        }
        String newName = range.replace(((PyStringLiteralExpression)this.myElement).getText(), newElementName);
        ((PyStringLiteralExpression)this.myElement).replace(PyElementGenerator.getInstance(((PyStringLiteralExpression)this.myElement).getProject()).createStringLiteralAlreadyEscaped(newName));
        return this.myElement;
    }
}

