/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.attach;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PyLocalPositionConverter;
import com.jetbrains.python.debugger.PyRemoteDebugProcess;
import com.jetbrains.python.debugger.attach.PyAttachToProcessCommandLineState;
import java.io.IOException;
import java.net.ServerSocket;
import org.jetbrains.annotations.NotNull;

public class PyAttachToProcessDebugRunner
extends PyDebugRunner {
    private Project myProject;
    private final int myPid;
    private String mySdkPath;

    public PyAttachToProcessDebugRunner(@NotNull Project project, int pid, String sdkPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/attach/PyAttachToProcessDebugRunner", "<init>"));
        }
        this.myProject = project;
        this.myPid = pid;
        this.mySdkPath = sdkPath;
    }

    public void launch() throws ExecutionException {
        FileDocumentManager.getInstance().saveAllDocuments();
        int port = this.launchRemoteDebugServer();
    }

    private int launchRemoteDebugServer() throws ExecutionException {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to find free socket port", (Throwable)e);
        }
        PyAttachToProcessCommandLineState state2 = PyAttachToProcessCommandLineState.create(this.myProject, this.mySdkPath, serverSocket.getLocalPort(), this.myPid);
        final ExecutionResult result = state2.execute(state2.getEnvironment().getExecutor(), (ProgramRunner)this);
        XDebugSession session = XDebuggerManager.getInstance((Project)this.myProject).startSessionAndShowTab(String.valueOf(this.myPid), null, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/debugger/attach/PyAttachToProcessDebugRunner$1", "start"));
                }
                PyRemoteDebugProcess pyDebugProcess = new PyRemoteDebugProcess(session, serverSocket, result.getExecutionConsole(), result.getProcessHandler(), ""){

                    @Override
                    protected void printConsoleInfo() {
                    }

                    @Override
                    protected String getConnectionMessage() {
                        return "Attaching to a process with PID=" + PyAttachToProcessDebugRunner.this.myPid;
                    }

                    @Override
                    protected String getConnectionTitle() {
                        return "Attaching Debugger";
                    }
                };
                pyDebugProcess.setPositionConverter(new PyLocalPositionConverter());
                PyDebugRunner.createConsoleCommunicationAndSetupActions(PyAttachToProcessDebugRunner.this.myProject, result, pyDebugProcess, session);
                PyRemoteDebugProcess pyRemoteDebugProcess = pyDebugProcess;
                if (pyRemoteDebugProcess == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/attach/PyAttachToProcessDebugRunner$1", "start"));
                }
                return pyRemoteDebugProcess;
            }
        });
        return serverSocket.getLocalPort();
    }
}

