/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.attach;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.debugger.PyRemoteDebugProcess;
import com.jetbrains.python.debugger.PyRemoteDebugProcessAware;
import com.jetbrains.python.run.PythonConfigurationType;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class PyAttachToProcessCommandLineState
extends PythonScriptCommandLineState {
    private static final String ATTACH_PYDEVD = "pydev/pydevd_attach_to_process/attach_pydevd.py";

    private PyAttachToProcessCommandLineState(PythonRunConfiguration runConfiguration, ExecutionEnvironment env) {
        super(runConfiguration, env);
    }

    public static PyAttachToProcessCommandLineState create(@NotNull Project project, @NotNull String sdkPath, int port, int pid) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/attach/PyAttachToProcessCommandLineState", "create"));
        }
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "com/jetbrains/python/debugger/attach/PyAttachToProcessCommandLineState", "create"));
        }
        PythonRunConfiguration conf = (PythonRunConfiguration)PythonConfigurationType.getInstance().getFactory().createTemplateConfiguration(project);
        conf.setScriptName(PythonHelpersLocator.getHelperPath(ATTACH_PYDEVD));
        conf.setSdkHome(sdkPath);
        conf.setScriptParameters("--port " + port + " --pid " + pid);
        ExecutionEnvironment env = ExecutionEnvironmentBuilder.create((Project)project, (Executor)DefaultDebugExecutor.getDebugExecutorInstance(), (RunProfile)conf).build();
        return new PyAttachToProcessCommandLineState(conf, env);
    }

    @Override
    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        ProcessHandler handler = super.doCreateProcess(commandLine);
        return new PyRemoteDebugProcessHandler(handler);
    }

    public static class PyRemoteDebugProcessHandler
    extends ProcessHandler
    implements PyRemoteDebugProcessAware {
        private final ProcessHandler myHandler;
        private PyRemoteDebugProcess myProcess = null;

        public PyRemoteDebugProcessHandler(ProcessHandler handler) {
            this.myHandler = handler;
            this.myHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    PyRemoteDebugProcessHandler.this.notifyTextAvailable(event.getText(), outputType);
                }
            });
        }

        public void startNotify() {
            super.startNotify();
            this.myHandler.startNotify();
        }

        protected void destroyProcessImpl() {
            if (this.myProcess != null) {
                this.myProcess.stop();
            }
            this.detachProcessImpl();
        }

        protected void detachProcessImpl() {
            this.notifyProcessTerminated(0);
            this.notifyTextAvailable("Server stopped.\n", ProcessOutputTypes.SYSTEM);
        }

        public boolean detachIsDefault() {
            return false;
        }

        public OutputStream getProcessInput() {
            return null;
        }

        @Override
        public void setRemoteDebugProcess(PyRemoteDebugProcess process) {
            this.myProcess = process;
        }
    }
}

