/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.attach;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SelectFromListDialog;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.debugger.attach.PyAttachToProcessDebugRunner;
import com.jetbrains.python.internal.ProcessUtils;
import com.jetbrains.python.internal.PyProcessInfo;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class PyAttachToProcessAction
extends AnAction {
    public PyAttachToProcessAction() {
        super("Attach debugger to process");
    }

    public void update(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        e.getPresentation().setEnabled(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Iterator<Sdk> i$;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/debugger/attach/PyAttachToProcessAction", "actionPerformed"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        Sdk sdk = PythonSdkType.findPythonSdk(module);
        if (sdk == null && (i$ = PythonSdkType.getAllSdks().iterator()).hasNext()) {
            Sdk s;
            sdk = s = i$.next();
        }
        SelectFromListDialog selectDialog = new SelectFromListDialog(project, (Object[])PyAttachToProcessAction.pythonProcessesList(), new SelectFromListDialog.ToStringAspect(){

            public String getToStirng(Object obj) {
                PyProcessInfo info = (PyProcessInfo)obj;
                return info.getPid() + " " + info.getArgs();
            }
        }, "Select Python Process", 0);
        selectDialog.show();
        if (selectDialog.isOK()) {
            PyProcessInfo process = (PyProcessInfo)selectDialog.getSelection()[0];
            PyAttachToProcessDebugRunner runner = new PyAttachToProcessDebugRunner(project, process.getPid(), sdk.getHomePath());
            try {
                runner.launch();
            }
            catch (ExecutionException e1) {
                Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)"Error Attaching Debugger");
            }
        }
    }

    private static PyProcessInfo[] pythonProcessesList() {
        Object[] list = ProcessUtils.getProcessList((String)PythonHelpersLocator.getHelpersRoot().getAbsolutePath()).getProcessList();
        return (PyProcessInfo[])FluentIterable.from((Iterable)Lists.newArrayList((Object[])list)).filter((Predicate)new Predicate<PyProcessInfo>(){

            public boolean apply(PyProcessInfo input) {
                return input.getCommand().toLowerCase().contains("python");
            }
        }).toArray(PyProcessInfo.class);
    }
}

