/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.array.ArrayTableForm;
import com.jetbrains.python.debugger.array.NumpyArrayTable;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyViewArrayAction
extends XDebuggerTreeActionBase {
    @Override
    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        if (nodeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/jetbrains/python/debugger/array/PyViewArrayAction", "perform"));
        }
        Project p = e.getProject();
        if (p != null && node != null && node.getValueContainer() instanceof PyDebugValue && node.isComputed()) {
            ViewArrayDialog dialog = new ViewArrayDialog(p, (PyDebugValue)node.getValueContainer());
            dialog.show();
        }
    }

    @Nullable
    private static TreePath[] getSelectedPaths(DataContext dataContext) {
        XDebuggerTree tree = XDebuggerTree.getTree(dataContext);
        return tree == null ? null : tree.getSelectionPaths();
    }

    @Override
    public void update(AnActionEvent e) {
        TreePath[] paths = PyViewArrayAction.getSelectedPaths(e.getDataContext());
        if (paths != null) {
            PyDebugValue debugValue;
            String nodeType;
            if (paths.length > 1) {
                e.getPresentation().setVisible(false);
                return;
            }
            XValueNodeImpl node = PyViewArrayAction.getSelectedNode(e.getDataContext());
            if (node != null && node.getValueContainer() instanceof PyDebugValue && node.isComputed() && "ndarray".equals(nodeType = (debugValue = (PyDebugValue)node.getValueContainer()).getType())) {
                e.getPresentation().setVisible(true);
                return;
            }
        }
        e.getPresentation().setVisible(false);
    }

    protected static class ViewArrayDialog
    extends DialogWrapper {
        private Project myProject;
        private NumpyArrayTable myNumpyArrayTable;

        private ViewArrayDialog(@NotNull Project project, PyDebugValue debugValue) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/array/PyViewArrayAction$ViewArrayDialog", "<init>"));
            }
            super(project, false);
            this.setModal(false);
            this.setCancelButtonText("Close");
            this.setCrossClosesWindow(true);
            this.myProject = project;
            this.myNumpyArrayTable = new NumpyArrayTable(this.myProject, this, debugValue);
            this.myNumpyArrayTable.init();
            this.init();
        }

        public void setError(String text) {
            this.setErrorText(text);
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/array/PyViewArrayAction$ViewArrayDialog", "createActions"));
            }
            return actionArray;
        }

        protected String getDimensionServiceKey() {
            return "#com.jetbrains.python.actions.view.array.PyViewArrayAction";
        }

        protected JComponent createCenterPanel() {
            return this.myNumpyArrayTable.getComponent().getMainPanel();
        }

        public ArrayTableForm getComponent() {
            return this.myNumpyArrayTable.getComponent();
        }
    }
}

