/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerEvaluator;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.array.ArrayTableCellRenderer;
import com.jetbrains.python.debugger.array.ArrayTableForm;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import com.jetbrains.python.debugger.array.JBTableWithRowHeaders;
import com.jetbrains.python.debugger.array.PyViewArrayAction;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class NumpyArrayTable {
    private final PyDebugValue myValue;
    private final PyViewArrayAction.ViewArrayDialog myDialog;
    private final ArrayTableForm myComponent;
    private final JTable myTable;
    private Project myProject;
    private PyDebuggerEvaluator myEvaluator;
    private String myDtypeKind;
    private ArrayTableCellRenderer myTableCellRenderer;
    private AsyncArrayTableModel myPagingModel;
    private static final int COLUMNS_IN_DEFAULT_SLICE = 40;
    private static final int ROWS_IN_DEFAULT_SLICE = 40;
    private static final int COLUMNS_IN_DEFAULT_VIEW = 1000;
    private static final int ROWS_IN_DEFAULT_VIEW = 1000;
    private static final Pattern PY_COMPLEX_NUMBER = Pattern.compile("([+-]?[.\\d^j]*)([+-]?[e.\\d]*j)?");
    private static final int HUGE_ARRAY_SIZE = 1000000;
    private static final String LOAD_SMALLER_SLICE = "Full slice too large and would slow down debugger, shrunk to smaller slice.";
    private static final String DISABLE_COLOR_FOR_HUGE_ARRAY = "Disable color because array too big and calculating min and max would slow down debugging.";
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.debugger.array.NumpyArrayValueProvider");

    public NumpyArrayTable(@NotNull Project project, @NotNull PyViewArrayAction.ViewArrayDialog dialog, @NotNull PyDebugValue value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/array/NumpyArrayTable", "<init>"));
        }
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/jetbrains/python/debugger/array/NumpyArrayTable", "<init>"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/python/debugger/array/NumpyArrayTable", "<init>"));
        }
        this.myValue = value;
        this.myDialog = dialog;
        this.myComponent = new ArrayTableForm(project, new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    NumpyArrayTable.this.doReslice();
                }
            }
        }, new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    NumpyArrayTable.this.doApplyFormat();
                }
            }
        });
        this.myTable = this.myComponent.getTable();
        this.myProject = project;
        this.myEvaluator = new PyDebuggerEvaluator(project, this.getDebugValue().getFrameAccessor());
    }

    public ArrayTableForm getComponent() {
        return this.myComponent;
    }

    private void initComponent() {
        this.myComponent.getColoredCheckbox().setEnabled(false);
        this.myComponent.getColoredCheckbox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getSource() == NumpyArrayTable.this.myComponent.getColoredCheckbox()) {
                    if (NumpyArrayTable.this.myTable.getRowCount() > 0 && NumpyArrayTable.this.myTable.getColumnCount() > 0 && NumpyArrayTable.this.myTable.getCellRenderer(0, 0) instanceof ArrayTableCellRenderer) {
                        ArrayTableCellRenderer renderer = (ArrayTableCellRenderer)NumpyArrayTable.this.myTable.getCellRenderer(0, 0);
                        if (NumpyArrayTable.this.myComponent.getColoredCheckbox().isSelected()) {
                            renderer.setColored(true);
                        } else {
                            renderer.setColored(false);
                        }
                    }
                    NumpyArrayTable.this.myComponent.getScrollPane().repaint();
                }
            }
        });
        this.myComponent.getSliceTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                NumpyArrayTable.this.myComponent.getSliceTextField().getDocument().createGuardedBlock(0, NumpyArrayTable.this.getNodeFullName().length());
            }

            @Override
            public void focusLost(FocusEvent e) {
                RangeMarker block = NumpyArrayTable.this.myComponent.getSliceTextField().getDocument().getRangeGuard(0, NumpyArrayTable.this.getNodeFullName().length());
                if (block != null) {
                    NumpyArrayTable.this.myComponent.getSliceTextField().getDocument().removeGuardedBlock(block);
                }
            }
        });
    }

    public void disableColor() {
        this.myTableCellRenderer.setMin(Double.MAX_VALUE);
        this.myTableCellRenderer.setMax(Double.MIN_VALUE);
        this.myTableCellRenderer.setColored(false);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                NumpyArrayTable.this.myComponent.getColoredCheckbox().setSelected(false);
                NumpyArrayTable.this.myComponent.getColoredCheckbox().setEnabled(false);
                if (NumpyArrayTable.this.myTable.getColumnCount() > 0) {
                    NumpyArrayTable.this.myTable.setDefaultRenderer(NumpyArrayTable.this.myTable.getColumnClass(0), NumpyArrayTable.this.myTableCellRenderer);
                }
            }
        });
    }

    public PyDebugValue getDebugValue() {
        return this.myValue;
    }

    public PyFrameAccessor getEvaluator() {
        return this.myValue.getFrameAccessor();
    }

    public void init() {
        this.init(this.getDebugValue().getEvaluationExpression(), false);
    }

    public void init(final String slice, final boolean inPlace) {
        this.initComponent();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                PyDebugValue value = NumpyArrayTable.this.getDebugValue();
                PyDebugValue parent = value.getParent();
                PyDebugValue slicedValue = new PyDebugValue(slice, value.getType(), value.getValue(), value.isContainer(), value.isErrorOnEval(), parent, value.getFrameAccessor());
                String format = NumpyArrayTable.this.getFormat().isEmpty() ? "%" : NumpyArrayTable.this.getFormat();
                try {
                    NumpyArrayTable.this.initUi(value.getFrameAccessor().getArrayItems(slicedValue, 0, 0, -1, -1, format), inPlace);
                }
                catch (PyDebuggerException e) {
                    NumpyArrayTable.this.showError(e.getMessage());
                }
            }
        });
    }

    private void initUi(final @NotNull ArrayChunk chunk, final boolean inPlace) {
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/jetbrains/python/debugger/array/NumpyArrayTable", "initUi"));
        }
        this.myPagingModel = new AsyncArrayTableModel(Math.min(chunk.getRows(), 1000), Math.min(chunk.getColumns(), 1000), this);
        this.myPagingModel.addToCache(chunk);
        this.myDtypeKind = chunk.getType();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                NumpyArrayTable.this.myTable.setModel(NumpyArrayTable.this.myPagingModel);
                NumpyArrayTable.this.myComponent.getSliceTextField().setText(chunk.getSlicePresentation());
                NumpyArrayTable.this.myComponent.getFormatTextField().setText(chunk.getFormat());
                NumpyArrayTable.this.myDialog.setTitle(NumpyArrayTable.getTitlePresentation(chunk.getSlicePresentation()));
                NumpyArrayTable.this.myTableCellRenderer = new ArrayTableCellRenderer(Double.MIN_VALUE, Double.MIN_VALUE, chunk.getType());
                NumpyArrayTable.this.fillColorRange(chunk.getMin(), chunk.getMax());
                if (!NumpyArrayTable.this.isNumeric()) {
                    NumpyArrayTable.this.disableColor();
                } else {
                    NumpyArrayTable.this.myComponent.getColoredCheckbox().setEnabled(true);
                }
                if (!inPlace) {
                    NumpyArrayTable.this.myComponent.getScrollPane().getViewport().setViewPosition(new Point(0, 0));
                    JBTableWithRowHeaders.RowHeaderTable rowTable = ((JBTableWithRowHeaders)((Object)NumpyArrayTable.this.myTable)).getRowHeaderTable();
                    rowTable.setRowShift(0);
                }
                ((AsyncArrayTableModel)NumpyArrayTable.this.myTable.getModel()).fireTableDataChanged();
                ((AsyncArrayTableModel)NumpyArrayTable.this.myTable.getModel()).fireTableCellUpdated(0, 0);
                if (NumpyArrayTable.this.myTable.getColumnCount() > 0) {
                    NumpyArrayTable.this.myTable.setDefaultRenderer(NumpyArrayTable.this.myTable.getColumnClass(0), NumpyArrayTable.this.myTableCellRenderer);
                }
            }
        });
    }

    private static String getTitlePresentation(String slice) {
        return "Array View: " + slice;
    }

    private void fillColorRange(String minValue, String maxValue) {
        double max;
        double min;
        if ("c".equals(this.myDtypeKind)) {
            min = 0.0;
            max = 1.0;
            this.myTableCellRenderer.setComplexMin(minValue);
            this.myTableCellRenderer.setComplexMax(maxValue);
        } else if ("b".equals(this.myDtypeKind)) {
            min = minValue.equals("True") ? 1.0 : 0.0;
            max = maxValue.equals("True") ? 1.0 : 0.0;
        } else {
            min = Double.parseDouble(minValue);
            max = Double.parseDouble(maxValue);
        }
        this.myTableCellRenderer.setMin(min);
        this.myTableCellRenderer.setMax(max);
    }

    public String getSliceText() {
        return this.myComponent.getSliceTextField().getText();
    }

    public boolean isNumeric() {
        if (this.myDtypeKind != null) {
            return "biufc".contains(this.myDtypeKind.substring(0, 1));
        }
        return false;
    }

    private void initTableModel(final boolean inPlace) {
        this.myPagingModel = new AsyncArrayTableModel(this.myPagingModel.getRowCount(), this.myPagingModel.getColumnCount(), this);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                NumpyArrayTable.this.myTable.setModel(NumpyArrayTable.this.myPagingModel);
                if (!inPlace) {
                    NumpyArrayTable.this.myComponent.getScrollPane().getViewport().setViewPosition(new Point(0, 0));
                    JBTableWithRowHeaders.RowHeaderTable rowTable = ((JBTableWithRowHeaders)((Object)NumpyArrayTable.this.myTable)).getRowHeaderTable();
                    rowTable.setRowShift(0);
                }
                ((AsyncArrayTableModel)NumpyArrayTable.this.myTable.getModel()).fireTableDataChanged();
                ((AsyncArrayTableModel)NumpyArrayTable.this.myTable.getModel()).fireTableCellUpdated(0, 0);
                if (NumpyArrayTable.this.myTable.getColumnCount() > 0) {
                    NumpyArrayTable.this.myTable.setDefaultRenderer(NumpyArrayTable.this.myTable.getColumnClass(0), NumpyArrayTable.this.myTableCellRenderer);
                }
            }
        });
    }

    public String correctStringValue(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/python/debugger/array/NumpyArrayTable", "correctStringValue"));
        }
        if (value instanceof String) {
            String corrected = (String)value;
            if (this.isNumeric() && (corrected.startsWith("'") || corrected.startsWith("\""))) {
                corrected = corrected.substring(1, corrected.length() - 1);
            }
            return corrected;
        }
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        return value.toString();
    }

    public void setDtypeKind(String dtype) {
        this.myDtypeKind = dtype;
    }

    public void showError(String message) {
        this.myDialog.setError(message);
    }

    public void showInfoHint(final String message) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (NumpyArrayTable.this.myComponent.getSliceTextField().getEditor() != null) {
                    HintManager.getInstance().showInformationHint(NumpyArrayTable.this.myComponent.getSliceTextField().getEditor(), message);
                }
            }
        });
    }

    private void doReslice() {
        this.clearErrorMessage();
        this.init(this.getSliceText(), false);
    }

    private void clearErrorMessage() {
        this.showError(null);
    }

    private void doApplyFormat() {
        this.reset();
    }

    private void reset() {
        this.clearErrorMessage();
        this.initTableModel(true);
    }

    public static double getRangedValue(String value, String type, double min, double max, String complexMax, String complexMin) {
        if ("iuf".contains(type)) {
            return (Double.parseDouble(value) - min) / (max - min);
        }
        if ("b".equals(type)) {
            return value.equals("True") ? 1.0 : 0.0;
        }
        if ("c".equals(type)) {
            return NumpyArrayTable.getComplexRangedValue(value, complexMax, complexMin);
        }
        return 0.0;
    }

    private static double getComplexRangedValue(String value, String complexMax, String complexMin) {
        Pair<Double, Double> med = NumpyArrayTable.parsePyComplex(value);
        Pair<Double, Double> max = NumpyArrayTable.parsePyComplex(complexMax);
        Pair<Double, Double> min = NumpyArrayTable.parsePyComplex(complexMin);
        double range = ((Double)med.first - (Double)min.first) / ((Double)max.first - (Double)min.first);
        if (((Double)max.first).equals(min.first)) {
            range = ((Double)med.second - (Double)min.second) / ((Double)max.second - (Double)min.second);
        }
        return range;
    }

    private static Pair<Double, Double> parsePyComplex(@NotNull String pyComplexValue) {
        Matcher matcher;
        if (pyComplexValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyComplexValue", "com/jetbrains/python/debugger/array/NumpyArrayTable", "parsePyComplex"));
        }
        if (pyComplexValue.startsWith("(") && pyComplexValue.endsWith(")")) {
            pyComplexValue = pyComplexValue.substring(1, pyComplexValue.length() - 1);
        }
        if ((matcher = PY_COMPLEX_NUMBER.matcher(pyComplexValue)).matches()) {
            String real = matcher.group(1);
            String imag = matcher.group(2);
            if (real.contains("j") && imag == null) {
                return new Pair((Object)new Double(0.0), (Object)Double.parseDouble(real.substring(0, real.length() - 1)));
            }
            return new Pair((Object)Double.parseDouble(real), (Object)Double.parseDouble(imag.substring(0, imag.length() - 1)));
        }
        throw new IllegalArgumentException("Not a valid python complex value: " + pyComplexValue);
    }

    public String getNodeFullName() {
        return this.getDebugValue().getEvaluationExpression();
    }

    public String getFormat() {
        return this.myComponent.getFormatTextField().getText();
    }
}

