/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.jetbrains.python.debugger.array.ArrayTableForm;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;

public class JBTableWithRowHeaders
extends JBTable {
    private final JBScrollPane myScrollPane;
    private RowHeaderTable myRowHeaderTable;

    public JBScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    public JBTableWithRowHeaders() {
        this.setAutoResizeMode(2);
        this.setRowSelectionAllowed(false);
        this.setMaxItemsForSizeCalculation(50);
        this.setTableHeader(new CustomTableHeader((JTable)((Object)this)));
        this.getTableHeader().setDefaultRenderer(new ArrayTableForm.ColumnHeaderRenderer());
        this.getTableHeader().setReorderingAllowed(false);
        this.myScrollPane = new JBScrollPane((Component)((Object)this));
        RowHeaderTable rowTable = new RowHeaderTable((JTable)((Object)this));
        this.myScrollPane.setRowHeaderView((Component)((Object)rowTable));
        this.myScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)rowTable.getTableHeader());
        this.setRowHeaderTable(rowTable);
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.getPreferredSize().width < this.getParent().getWidth();
    }

    public RowHeaderTable getRowHeaderTable() {
        return this.myRowHeaderTable;
    }

    public void setRowHeaderTable(RowHeaderTable rowHeaderTable) {
        this.myRowHeaderTable = rowHeaderTable;
    }

    public static class CustomTableHeader
    extends JTableHeader {
        public CustomTableHeader(JTable table) {
            this.setColumnModel(table.getColumnModel());
            table.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    CustomTableHeader.this.repaint();
                }
            });
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
            this.repaint();
        }
    }

    public static class RowHeaderTable
    extends JBTable
    implements PropertyChangeListener,
    TableModelListener {
        private JTable myMainTable;
        private int myRowShift = 0;

        public RowHeaderTable(JTable table) {
            MouseListener[] listeners;
            this.myMainTable = table;
            this.myMainTable.getModel().addTableModelListener(this);
            this.setFocusable(false);
            this.setAutoCreateColumnsFromModel(false);
            this.setSelectionModel(this.myMainTable.getSelectionModel());
            this.setSelectionMode(0);
            TableColumn column = new TableColumn();
            column.setHeaderValue(" ");
            this.addColumn(column);
            column.setCellRenderer(new RowNumberRenderer());
            this.getColumnModel().getColumn(0).setPreferredWidth(50);
            this.setPreferredScrollableViewportSize(this.getPreferredSize());
            this.setRowHeight(this.myMainTable.getRowHeight());
            for (MouseListener l : listeners = this.getMouseListeners()) {
                this.removeMouseListener(l);
            }
        }

        protected void paintComponent(@NotNull Graphics g) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/jetbrains/python/debugger/array/JBTableWithRowHeaders$RowHeaderTable", "paintComponent"));
            }
            this.getEmptyText().setText("");
            super.paintComponent(g);
        }

        public int getRowCount() {
            return this.myMainTable.getRowCount();
        }

        public int getRowHeight(int row) {
            this.setRowHeight(this.myMainTable.getRowHeight());
            return super.getRowHeight(row);
        }

        public Object getValueAt(int row, int column) {
            return Integer.toString(row + this.myRowShift);
        }

        public void setRowShift(int shift) {
            this.myRowShift = shift;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void setValueAt(Object value, int row, int column) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("selectionModel".equals(e.getPropertyName())) {
                this.setSelectionModel(this.myMainTable.getSelectionModel());
            }
            if ("rowHeight".equals(e.getPropertyName())) {
                this.repaint();
            }
            if ("model".equals(e.getPropertyName())) {
                this.myMainTable.getModel().addTableModelListener(this);
                this.revalidate();
            }
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.revalidate();
        }

        private class RowNumberRenderer
        extends DefaultTableCellRenderer {
            public RowNumberRenderer() {
                this.setHorizontalAlignment(0);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header;
                if (table != null && (header = table.getTableHeader()) != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                if (isSelected) {
                    this.setFont(this.getFont().deriveFont(1));
                }
                this.setText(value == null ? "" : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        }
    }
}

