/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.array.NumpyArrayTable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.table.AbstractTableModel;

public class AsyncArrayTableModel
extends AbstractTableModel {
    private static final int CHUNK_COL_SIZE = 30;
    private static final int CHUNK_ROW_SIZE = 30;
    public static final String EMPTY_CELL_VALUE = "";
    private int myRows;
    private int myColumns;
    private final NumpyArrayTable myProvider;
    private final ExecutorService myExecutorService = Executors.newSingleThreadExecutor();
    private LoadingCache<Pair<Integer, Integer>, ListenableFuture<ArrayChunk>> myChunkCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Pair<Integer, Integer>, ListenableFuture<ArrayChunk>>(){

        public ListenableFuture<ArrayChunk> load(final Pair<Integer, Integer> key) throws Exception {
            final PyDebugValue value = AsyncArrayTableModel.this.myProvider.getDebugValue();
            final PyDebugValue slicedValue = new PyDebugValue(AsyncArrayTableModel.this.myProvider.getSliceText(), value.getType(), value.getValue(), value.isContainer(), value.isErrorOnEval(), value.getParent(), value.getFrameAccessor());
            ListenableFutureTask task = ListenableFutureTask.create((Callable)new Callable<ArrayChunk>(){

                @Override
                public ArrayChunk call() throws Exception {
                    return value.getFrameAccessor().getArrayItems(slicedValue, ((Integer)key.first).intValue(), ((Integer)key.second).intValue(), Math.min(30, AsyncArrayTableModel.this.getRowCount() - (Integer)key.first), Math.min(30, AsyncArrayTableModel.this.getColumnCount() - (Integer)key.second), AsyncArrayTableModel.this.myProvider.getFormat());
                }
            });
            AsyncArrayTableModel.this.myExecutorService.execute((Runnable)task);
            return task;
        }
    });

    public AsyncArrayTableModel(int rows, int columns, NumpyArrayTable provider) {
        this.myRows = rows;
        this.myColumns = columns;
        this.myProvider = provider;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Object getValueAt(final int row, final int col) {
        Pair<Integer, Integer> key = AsyncArrayTableModel.itemToChunkKey(row, col);
        try {
            ListenableFuture chunk = (ListenableFuture)this.myChunkCache.get(key);
            if (chunk.isDone()) {
                Object[][] data = ((ArrayChunk)chunk.get()).getData();
                int r = row % 30;
                int c = col % 30;
                if (r < data.length && c < data[r].length) {
                    return this.myProvider.correctStringValue(data[r][c]);
                }
            } else {
                chunk.addListener(new Runnable(){

                    @Override
                    public void run() {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AsyncArrayTableModel.this.fireTableCellUpdated(row, col);
                            }
                        });
                    }
                }, (Executor)this.myExecutorService);
            }
            return EMPTY_CELL_VALUE;
        }
        catch (Exception e) {
            this.myProvider.showError(e.getMessage());
            return EMPTY_CELL_VALUE;
        }
    }

    private static Pair<Integer, Integer> itemToChunkKey(int row, int col) {
        return Pair.create((Object)AsyncArrayTableModel.getPageRowStart(row), (Object)AsyncArrayTableModel.getPageColStart(col));
    }

    private static int getPageRowStart(int rowOffset) {
        return rowOffset - rowOffset % 30;
    }

    private static int getPageColStart(int colOffset) {
        return colOffset - colOffset % 30;
    }

    @Override
    public int getColumnCount() {
        return this.myColumns;
    }

    @Override
    public String getColumnName(int col) {
        return String.valueOf(col);
    }

    @Override
    public int getRowCount() {
        return this.myRows;
    }

    public void changeValue(int row, int col, Object value) {
        Future chunk = (Future)this.myChunkCache.getIfPresent(AsyncArrayTableModel.itemToChunkKey(row, col));
        if (chunk != null && chunk.isDone()) {
            try {
                ((ArrayChunk)chunk.get()).getData()[row - AsyncArrayTableModel.getPageRowStart((int)row)][col - AsyncArrayTableModel.getPageColStart((int)col)] = value;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            throw new IllegalArgumentException("Forced to change empty cell in " + row + " row and " + col + " column.");
        }
    }

    public void addToCache(final ArrayChunk chunk) {
        Object[][] data = chunk.getData();
        int cols = data.length;
        int rows = data[0].length;
        for (int roffset = 0; roffset < rows / 30; ++roffset) {
            for (int coffset = 0; coffset < cols / 30; ++coffset) {
                Pair<Integer, Integer> key = AsyncArrayTableModel.itemToChunkKey(roffset * 30, coffset * 30);
                final Object[][] chunkData = new Object[30][30];
                for (int r = 0; r < 30; ++r) {
                    for (int c = 0; c < 30; ++c) {
                        chunkData[r][c] = data[roffset * 30 + r][coffset * 30 + c];
                    }
                }
                this.myChunkCache.put(key, (Object)new ListenableFuture<ArrayChunk>(){

                    public void addListener(Runnable listener, Executor executor) {
                    }

                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return false;
                    }

                    public boolean isCancelled() {
                        return false;
                    }

                    public boolean isDone() {
                        return true;
                    }

                    public ArrayChunk get() throws InterruptedException, ExecutionException {
                        return new ArrayChunk(chunk.getValue(), null, 0, 0, null, null, null, null, chunkData);
                    }

                    public ArrayChunk get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        return new ArrayChunk(chunk.getValue(), null, 0, 0, null, null, null, null, chunkData);
                    }
                });
            }
        }
    }
}

