/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.debugger.array.JBTableWithRowHeaders;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.jetbrains.annotations.NotNull;

public class ArrayTableForm {
    private EditorTextField mySliceTextField;
    private JCheckBox myColoredCheckbox;
    private EditorTextField myFormatTextField;
    private JBScrollPane myScrollPane;
    private JLabel myFormatLabel;
    private JPanel myFormatPanel;
    private JPanel myMainPanel;
    private JTable myTable;
    private final Project myProject;
    private KeyListener myResliceCallback;
    private KeyListener myReformatCallback;
    private static final String DATA_LOADING_IN_PROCESS = "Please wait, load array data.";
    private static final String NOT_APPLICABLE = "View not applicable for ";

    public ArrayTableForm(@NotNull Project project, KeyListener resliceCallback, KeyListener reformatCallback) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/array/ArrayTableForm", "<init>"));
        }
        this.myProject = project;
        this.myResliceCallback = resliceCallback;
        this.myReformatCallback = reformatCallback;
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        this.mySliceTextField = new EditorTextField("", this.myProject, (FileType)PythonFileType.INSTANCE){

            @Override
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.getContentComponent().addKeyListener(ArrayTableForm.this.myResliceCallback);
                return editor;
            }
        };
        this.myTable = new JBTableWithRowHeaders();
        this.myScrollPane = ((JBTableWithRowHeaders)((Object)this.myTable)).getScrollPane();
        this.myFormatTextField = new EditorTextField("", this.myProject, (FileType)PythonFileType.INSTANCE){

            @Override
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.getContentComponent().addKeyListener(ArrayTableForm.this.myReformatCallback);
                return editor;
            }
        };
    }

    public EditorTextField getSliceTextField() {
        return this.mySliceTextField;
    }

    public EditorTextField getFormatTextField() {
        return this.myFormatTextField;
    }

    public JTable getTable() {
        return this.myTable;
    }

    public JCheckBox getColoredCheckbox() {
        return this.myColoredCheckbox;
    }

    public JComponent getMainPanel() {
        return this.myMainPanel;
    }

    public JBScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = this.myScrollPane;
        jBScrollPane.setVerticalScrollBarPolicy(20);
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 5, 0, 3, 3, 3, null, null, null));
        JTable jTable = this.myTable;
        jTable.setAutoResizeMode(0);
        jTable.setFillsViewportHeight(true);
        jBScrollPane.setViewportView(jTable);
        this.myColoredCheckbox = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(true);
        jCheckBox.setSelected(true);
        jCheckBox.setText("Colored");
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 4, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFormatPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 3, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFormatLabel = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setHorizontalTextPosition(4);
        jLabel.setText("Format:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myFormatTextField;
        ((JComponent)((Object)editorTextField)).setToolTipText("Format");
        jPanel.add((Component)((Object)editorTextField), new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, new Dimension(70, -1), null, null));
        EditorTextField editorTextField2 = this.mySliceTextField;
        ((JComponent)((Object)editorTextField2)).setToolTipText("Current slice.");
        jPanel2.add((Component)((Object)editorTextField2), new GridConstraints(1, 0, 1, 3, 0, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    public static class DefaultTableHeaderCellRenderer
    extends DefaultTableCellRenderer {
        public DefaultTableHeaderCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(2);
            this.setVerticalAlignment(3);
            this.setOpaque(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JTableHeader tableHeader = table.getTableHeader();
            if (tableHeader != null) {
                this.setForeground(tableHeader.getForeground());
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    public static class ColumnHeaderRenderer
    extends DefaultTableHeaderCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            int selectedColumn = table.getSelectedColumn();
            if (selectedColumn == column) {
                this.setFont(this.getFont().deriveFont(1));
            }
            return this;
        }
    }
}

