/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.debugger.array.NumpyArrayTable;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;

class ArrayTableCellRenderer
extends DefaultTableCellRenderer {
    private double myMin = Double.MIN_VALUE;
    private double myMax = Double.MIN_VALUE;
    private String myComplexMin;
    private String myComplexMax;
    private boolean myColored = true;
    private String myType;

    public ArrayTableCellRenderer(double min, double max, String type) {
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(2);
        this.setVerticalAlignment(3);
        this.myMin = min;
        this.myMax = max;
        this.myType = type;
    }

    public void setColored(boolean colored) {
        this.myColored = colored;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        if (value != null) {
            this.setText(value.toString());
        }
        if (hasFocus) {
            this.setBorder(new LineBorder((Color)JBColor.BLUE, 2));
        }
        if (this.myMax != this.myMin) {
            if (this.myColored && value != null) {
                try {
                    double rangedValue = NumpyArrayTable.getRangedValue(value.toString(), this.myType, this.myMin, this.myMax, this.myComplexMax, this.myComplexMin);
                    this.setBackground((Color)new JBColor(new Color((int)Math.round(255.0 * rangedValue), 0, (int)Math.round(255.0 * (1.0 - rangedValue)), 130), new Color((int)Math.round(255.0 * rangedValue), 0, (int)Math.round(255.0 * (1.0 - rangedValue)), 130)));
                }
                catch (NumberFormatException ignored) {}
            } else {
                this.setBackground((Color)new JBColor(UIUtil.getBgFillColor((JComponent)table), UIUtil.getBgFillColor((JComponent)table)));
            }
        }
        return this;
    }

    public void setMin(double min) {
        this.myMin = min;
    }

    public void setMax(double max) {
        this.myMax = max;
    }

    public double getMin() {
        return this.myMin;
    }

    public double getMax() {
        return this.myMax;
    }

    public void setComplexMin(String complexMin) {
        this.myComplexMin = complexMin;
    }

    public void setComplexMax(String complexMax) {
        this.myComplexMax = complexMax;
    }
}

