/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private MyTableEditor myEditor;
    private final Project myProject;
    private Object myLastValue;
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.debugger.array.ArrayTableCellEditor");

    public ArrayTableCellEditor(Project project) {
        this.myProject = project;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
        this.myEditor = new MyTableEditor(this.myProject, new PyDebuggerEditorsProvider(), "numpy.array.table.view", null, new XExpressionImpl(value.toString(), PythonLanguage.getInstance(), "", EvaluationMode.CODE_FRAGMENT), this.getActionsAdapter(rowIndex, vColIndex));
        this.myLastValue = value;
        return this.myEditor.getComponent();
    }

    @Override
    @Nullable
    public Object getCellEditorValue() {
        if (this.myEditor.getEditor() != null) {
            return this.myEditor.getEditor().getDocument().getText();
        }
        return null;
    }

    @NotNull
    private KeyAdapter getActionsAdapter(final int rowIndex, final int vColIndex) {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ArrayTableCellEditor.this.doOKAction(rowIndex, vColIndex);
                } else if (e.getKeyCode() == 27) {
                    ArrayTableCellEditor.this.cancelEditing();
                }
            }
        };
        if (keyAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/array/ArrayTableCellEditor", "getActionsAdapter"));
        }
        return keyAdapter;
    }

    public void doOKAction(int rowIndex, int vColIndex) {
    }

    public void cancelEditing() {
        new WriteCommandAction(null, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/debugger/array/ArrayTableCellEditor$2", "run"));
                }
                if (ArrayTableCellEditor.this.myEditor.getEditor() != null) {
                    ArrayTableCellEditor.this.myEditor.getEditor().getDocument().setText((CharSequence)ArrayTableCellEditor.this.myLastValue.toString());
                }
            }
        }.execute();
        this.myEditor.getComponent().repaint();
        this.stopCellEditing();
    }

    public MyTableEditor getEditor() {
        return this.myEditor;
    }

    public void setLastValue(Object lastValue) {
        this.myLastValue = lastValue;
    }

    public static class MyTableEditor
    extends XDebuggerEditorBase {
        private final EditorTextField myEditorTextField;
        private final XExpression myExpression;

        public MyTableEditor(Project project, XDebuggerEditorsProvider debuggerEditorsProvider, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition, @NotNull XExpression text, final @NotNull KeyAdapter actionAdapter) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/debugger/array/ArrayTableCellEditor$MyTableEditor", "<init>"));
            }
            if (actionAdapter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionAdapter", "com/jetbrains/python/debugger/array/ArrayTableCellEditor$MyTableEditor", "<init>"));
            }
            super(project, debuggerEditorsProvider, EvaluationMode.CODE_FRAGMENT, historyId, sourcePosition);
            this.myExpression = XExpressionImpl.changeMode(text, this.getMode());
            this.myEditorTextField = new EditorTextField(this.createDocument(this.myExpression), project, debuggerEditorsProvider.getFileType()){

                @Override
                protected EditorEx createEditor() {
                    EditorEx editor = super.createEditor();
                    editor.setVerticalScrollbarVisible(false);
                    editor.setOneLineMode(true);
                    editor.getContentComponent().addKeyListener(actionAdapter);
                    return editor;
                }

                @Override
                protected boolean isOneLineMode() {
                    return true;
                }
            };
            this.myEditorTextField.setFontInheritedFromLAF(false);
        }

        @Override
        public JComponent getComponent() {
            return this.myEditorTextField;
        }

        @Override
        protected void doSetText(XExpression text) {
            this.myEditorTextField.setText(text.getExpression());
        }

        @Override
        public XExpression getExpression() {
            return this.getEditorsProvider().createExpression(this.getProject(), this.myEditorTextField.getDocument(), this.myExpression.getLanguage(), EvaluationMode.CODE_FRAGMENT);
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            Editor editor = this.myEditorTextField.getEditor();
            return editor != null ? editor.getContentComponent() : null;
        }

        @Override
        @Nullable
        public Editor getEditor() {
            return this.myEditorTextField.getEditor();
        }

        @Override
        public void selectAll() {
            this.myEditorTextField.selectAll();
        }
    }
}

