/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyExecutionStack;
import com.jetbrains.python.debugger.PyThreadInfo;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PySuspendContext
extends XSuspendContext {
    private final XExecutionStack myActiveStack;
    private PyDebugProcess myDebugProcess;

    public PySuspendContext(@NotNull PyDebugProcess debugProcess, @NotNull PyThreadInfo threadInfo) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/python/debugger/PySuspendContext", "<init>"));
        }
        if (threadInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadInfo", "com/jetbrains/python/debugger/PySuspendContext", "<init>"));
        }
        this.myDebugProcess = debugProcess;
        this.myActiveStack = new PyExecutionStack(debugProcess, threadInfo);
    }

    public XExecutionStack getActiveExecutionStack() {
        return this.myActiveStack;
    }

    public XExecutionStack[] getExecutionStacks() {
        Collection<PyThreadInfo> threads = this.myDebugProcess.getThreads();
        if (threads.size() < 1) {
            return XExecutionStack.EMPTY_ARRAY;
        }
        XExecutionStack[] stacks = new XExecutionStack[threads.size()];
        int i = 0;
        for (PyThreadInfo thread : threads) {
            stacks[i++] = new PyExecutionStack(this.myDebugProcess, thread);
        }
        return stacks;
    }
}

