/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.debugger.PyDebuggerEvaluator;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import org.jetbrains.annotations.NotNull;

public class PyStackFrame
extends XStackFrame {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.pydev.PyStackFrame");
    private static final Object STACK_FRAME_EQUALITY_OBJECT = new Object();
    private Project myProject;
    private final PyFrameAccessor myDebugProcess;
    private final PyStackFrameInfo myFrameInfo;
    private final XSourcePosition myPosition;

    public PyStackFrame(@NotNull Project project, @NotNull PyFrameAccessor debugProcess, @NotNull PyStackFrameInfo frameInfo, XSourcePosition position) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/PyStackFrame", "<init>"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/python/debugger/PyStackFrame", "<init>"));
        }
        if (frameInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameInfo", "com/jetbrains/python/debugger/PyStackFrame", "<init>"));
        }
        this.myProject = project;
        this.myDebugProcess = debugProcess;
        this.myFrameInfo = frameInfo;
        this.myPosition = position;
    }

    public Object getEqualityObject() {
        return STACK_FRAME_EQUALITY_OBJECT;
    }

    public XSourcePosition getSourcePosition() {
        return this.myPosition;
    }

    public XDebuggerEvaluator getEvaluator() {
        return new PyDebuggerEvaluator(this.myProject, this.myDebugProcess);
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/python/debugger/PyStackFrame", "customizePresentation"));
        }
        component.setIcon(AllIcons.Debugger.StackFrame);
        if (this.myPosition == null) {
            component.append("<frame not available>", SimpleTextAttributes.GRAY_ATTRIBUTES);
            return;
        }
        boolean isExternal = true;
        VirtualFile file = this.myPosition.getFile();
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document != null) {
            isExternal = !ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(file);
        }
        component.append(this.myFrameInfo.getName(), PyStackFrame.gray(SimpleTextAttributes.REGULAR_ATTRIBUTES, isExternal));
        component.append(", ", PyStackFrame.gray(SimpleTextAttributes.REGULAR_ATTRIBUTES, isExternal));
        component.append(this.myPosition.getFile().getName(), PyStackFrame.gray(SimpleTextAttributes.REGULAR_ATTRIBUTES, isExternal));
        component.append(":", PyStackFrame.gray(SimpleTextAttributes.REGULAR_ATTRIBUTES, isExternal));
        component.append(Integer.toString(this.myPosition.getLine() + 1), PyStackFrame.gray(SimpleTextAttributes.REGULAR_ATTRIBUTES, isExternal));
    }

    private static SimpleTextAttributes gray(SimpleTextAttributes attributes, boolean gray) {
        if (!gray) {
            return attributes;
        }
        return (attributes.getStyle() & 2) != 0 ? SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/debugger/PyStackFrame", "computeChildren"));
        }
        if (node.isObsolete()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    XValueChildrenList values = PyStackFrame.this.myDebugProcess.loadFrame();
                    if (!node.isObsolete()) {
                        node.addChildren(values != null ? values : XValueChildrenList.EMPTY, true);
                    }
                }
                catch (PyDebuggerException e) {
                    if (!node.isObsolete()) {
                        node.setErrorMessage("Unable to display frame variables");
                    }
                    LOG.warn((Throwable)e);
                }
            }
        });
    }

    public String getThreadId() {
        return this.myFrameInfo.getThreadId();
    }

    public String getFrameId() {
        return this.myFrameInfo.getId();
    }

    public String getThreadFrameId() {
        return this.myFrameInfo.getThreadId() + ":" + this.myFrameInfo.getId();
    }

    protected XSourcePosition getPosition() {
        return this.myPosition;
    }
}

