/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySmartStepIntoHandler
extends XSmartStepIntoHandler<PySmartStepIntoVariant> {
    private final XDebugSession mySession;
    private PyDebugProcess myProcess;

    public PySmartStepIntoHandler(PyDebugProcess process) {
        this.mySession = process.getSession();
        this.myProcess = process;
    }

    @NotNull
    public List<PySmartStepIntoVariant> computeSmartStepVariants(@NotNull XSourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/python/debugger/PySmartStepIntoHandler", "computeSmartStepVariants"));
        }
        final Document document = FileDocumentManager.getInstance().getDocument(position.getFile());
        final ArrayList variants = Lists.newArrayList();
        final HashSet visitedCalls = Sets.newHashSet();
        final int line = position.getLine();
        XDebuggerUtil.getInstance().iterateLine(this.mySession.getProject(), document, line, (Processor)new Processor<PsiElement>(){

            public boolean process(PsiElement psiElement) {
                PySmartStepIntoHandler.addVariants(document, line, psiElement, variants, visitedCalls);
                return true;
            }
        });
        ArrayList arrayList = variants;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PySmartStepIntoHandler", "computeSmartStepVariants"));
        }
        return arrayList;
    }

    public void startStepInto(@NotNull PySmartStepIntoVariant smartStepIntoVariant) {
        if (smartStepIntoVariant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "smartStepIntoVariant", "com/jetbrains/python/debugger/PySmartStepIntoHandler", "startStepInto"));
        }
        this.myProcess.startSmartStepInto(smartStepIntoVariant.getFunctionName());
    }

    public String getPopupTitle(@NotNull XSourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/python/debugger/PySmartStepIntoHandler", "getPopupTitle"));
        }
        return PyBundle.message("debug.popup.title.step.into.function", new Object[0]);
    }

    private static void addVariants(Document document, int line, @Nullable PsiElement element, List<PySmartStepIntoVariant> variants, Set<PyCallExpression> visited) {
        if (element == null) {
            return;
        }
        PyCallExpression expression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (expression != null && expression.getTextRange().getEndOffset() <= document.getLineEndOffset(line) && visited.add(expression)) {
            PySmartStepIntoHandler.addVariants(document, line, expression.getParent(), variants, visited);
            PyExpression ref = expression.getCallee();
            variants.add(new PySmartStepIntoVariant(ref));
        }
    }

    public static class PySmartStepIntoVariant
    extends XSmartStepIntoVariant {
        private final PyElement myElement;

        public PySmartStepIntoVariant(PyElement element) {
            this.myElement = element;
        }

        public String getText() {
            return this.myElement.getText() + "()";
        }

        public String getFunctionName() {
            String name = this.myElement.getName();
            return name != null ? name : this.getText();
        }
    }
}

