/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyUnionType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySignatureUtil {
    private PySignatureUtil() {
    }

    @Nullable
    public static String getShortestImportableName(@Nullable PsiElement anchor, @NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/debugger/PySignatureUtil", "getShortestImportableName"));
        }
        PyType pyType = PyTypeParser.getTypeByName(anchor, type);
        if (pyType instanceof PyClassType) {
            PyClass c = ((PyClassType)pyType).getPyClass();
            return c.getQualifiedName();
        }
        if (pyType != null) {
            return PySignatureUtil.getPrintableName(pyType);
        }
        return type;
    }

    private static String getPrintableName(PyType type) {
        if (type instanceof PyUnionType) {
            return StringUtil.join((Collection)Collections2.transform(((PyUnionType)type).getMembers(), (Function)new Function<PyType, String>(){

                public String apply(@Nullable PyType input) {
                    return PySignatureUtil.getPrintableName(input);
                }
            }), (String)" or ");
        }
        if (type != null) {
            return type.getName();
        }
        return "unknown";
    }

    @Nullable
    public static String getArgumentType(@NotNull PyFunction function, @NotNull String name) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/debugger/PySignatureUtil", "getArgumentType"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/debugger/PySignatureUtil", "getArgumentType"));
        }
        PySignatureCacheManager cacheManager = PySignatureCacheManager.getInstance(function.getProject());
        PySignature signature = cacheManager.findSignature(function);
        if (signature != null) {
            return PySignatureUtil.getShortestImportableName(function, signature.getArgTypeQualifiedName(name));
        }
        return null;
    }
}

