/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySignatureCacheManagerImpl
extends PySignatureCacheManager {
    protected static final Logger LOG = Logger.getInstance((String)PySignatureCacheManagerImpl.class.getName());
    private static final boolean SHOULD_OVERWRITE_TYPES = false;
    public static final FileAttribute CALL_SIGNATURES_ATTRIBUTE = new FileAttribute("call.signatures.attribute", 1, true);
    private final Project myProject;
    private final LoadingCache<VirtualFile, String> mySignatureCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<VirtualFile, String>(){

        public String load(VirtualFile key) throws Exception {
            return PySignatureCacheManagerImpl.readAttributeFromFile(key);
        }
    });

    public PySignatureCacheManagerImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void recordSignature(@NotNull PySignature signature) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/jetbrains/python/debugger/PySignatureCacheManagerImpl", "recordSignature"));
        }
        GlobalSearchScope scope = ProjectScope.getProjectScope((Project)this.myProject);
        VirtualFile file = PySignatureCacheManagerImpl.getFile(signature);
        if (file != null && scope.contains(file)) {
            this.recordSignature(file, signature);
        }
    }

    private void recordSignature(VirtualFile file, PySignature signature) {
        String dataString = this.readAttribute(file);
        String[] lines = dataString != null ? dataString.split("\n") : ArrayUtil.EMPTY_STRING_ARRAY;
        boolean found = false;
        int i = 0;
        for (String sign : lines) {
            String[] parts = sign.split("\t");
            if (parts.length > 0 && parts[0].equals(signature.getFunctionName())) {
                found = true;
                lines[i] = PySignatureCacheManagerImpl.signatureToString(PySignatureCacheManagerImpl.stringToSignature(file.getCanonicalPath(), lines[i]).addAllArgs(signature));
            }
            ++i;
        }
        if (!found) {
            String[] lines2 = new String[lines.length + 1];
            System.arraycopy(lines, 0, lines2, 0, lines.length);
            lines2[lines2.length - 1] = PySignatureCacheManagerImpl.signatureToString(signature);
            lines = lines2;
        }
        String attrString = StringUtil.join((String[])lines, (String)"\n");
        this.writeAttribute(file, attrString);
    }

    private void writeAttribute(@NotNull VirtualFile file, @NotNull String attrString) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/debugger/PySignatureCacheManagerImpl", "writeAttribute"));
        }
        if (attrString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrString", "com/jetbrains/python/debugger/PySignatureCacheManagerImpl", "writeAttribute"));
        }
        String cachedValue = (String)this.mySignatureCache.asMap().get(file);
        if (!attrString.equals(cachedValue)) {
            this.mySignatureCache.put((Object)file, (Object)attrString);
            PySignatureCacheManagerImpl.writeAttributeToAFile(file, attrString);
        }
    }

    private static void writeAttributeToAFile(@NotNull VirtualFile file, @NotNull String attrString) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/debugger/PySignatureCacheManagerImpl", "writeAttributeToAFile"));
        }
        if (attrString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrString", "com/jetbrains/python/debugger/PySignatureCacheManagerImpl", "writeAttributeToAFile"));
        }
        try {
            CALL_SIGNATURES_ATTRIBUTE.writeAttributeBytes(file, attrString.getBytes());
        }
        catch (IOException e) {
            LOG.warn("Can't write attribute " + file.getCanonicalPath() + " " + attrString);
        }
    }

    private static String signatureToString(PySignature signature) {
        return signature.getFunctionName() + "\t" + StringUtil.join(PySignatureCacheManagerImpl.arguments(signature), (String)"\t");
    }

    private static List<String> arguments(PySignature signature) {
        ArrayList res = Lists.newArrayList();
        for (PySignature.NamedParameter param : signature.getArgs()) {
            res.add(param.getName() + ":" + param.getTypeQualifiedName());
        }
        return res;
    }

    @Override
    @Nullable
    public String findParameterType(@NotNull PyFunction function, @NotNull String name) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/debugger/PySignatureCacheManagerImpl", "findParameterType"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/debugger/PySignatureCacheManagerImpl", "findParameterType"));
        }
        PySignature signature = this.findSignature(function);
        if (signature != null) {
            return signature.getArgTypeQualifiedName(name);
        }
        return null;
    }

    @Override
    @Nullable
    public PySignature findSignature(@NotNull PyFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/debugger/PySignatureCacheManagerImpl", "findSignature"));
        }
        VirtualFile file = PySignatureCacheManagerImpl.getFile(function);
        if (file != null) {
            return this.readSignatureAttributeFromFile(file, PySignatureCacheManagerImpl.getFunctionName(function));
        }
        return null;
    }

    private static String getFunctionName(PyFunction function) {
        String name = function.getName();
        if (name == null) {
            return "";
        }
        PyClass cls = function.getContainingClass();
        if (cls != null) {
            name = cls.getName() + "." + name;
        }
        return name;
    }

    @Nullable
    private PySignature readSignatureAttributeFromFile(@NotNull VirtualFile file, @NotNull String name) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/debugger/PySignatureCacheManagerImpl", "readSignatureAttributeFromFile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/debugger/PySignatureCacheManagerImpl", "readSignatureAttributeFromFile"));
        }
        String content = this.readAttribute(file);
        if (content != null) {
            String[] lines;
            for (String sign : lines = content.split("\n")) {
                String[] parts = sign.split("\t");
                if (parts.length <= 0 || !parts[0].equals(name)) continue;
                return PySignatureCacheManagerImpl.stringToSignature(file.getCanonicalPath(), sign);
            }
        }
        return null;
    }

    @Nullable
    private String readAttribute(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/debugger/PySignatureCacheManagerImpl", "readAttribute"));
        }
        try {
            String attrContent = (String)this.mySignatureCache.get((Object)file);
            if (!StringUtil.isEmpty((String)attrContent)) {
                return attrContent;
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    private static String readAttributeFromFile(@NotNull VirtualFile file) {
        byte[] data;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/debugger/PySignatureCacheManagerImpl", "readAttributeFromFile"));
        }
        try {
            data = CALL_SIGNATURES_ATTRIBUTE.readAttributeBytes(file);
        }
        catch (Exception e) {
            data = null;
        }
        String content = data != null && data.length > 0 ? new String(data) : null;
        String string = content != null ? content : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PySignatureCacheManagerImpl", "readAttributeFromFile"));
        }
        return string;
    }

    @Nullable
    private static PySignature stringToSignature(String path, String string) {
        String[] parts = string.split("\t");
        if (parts.length > 0) {
            PySignature signature = new PySignature(path, parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                String[] var = parts[i].split(":");
                if (var.length != 2) {
                    throw new IllegalStateException("Should be <name>:<type> format. " + parts[i] + " instead.");
                }
                signature = signature.addArgument(var[0], var[1]);
            }
            return signature;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getFile(@NotNull PySignature signature) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/jetbrains/python/debugger/PySignatureCacheManagerImpl", "getFile"));
        }
        return LocalFileSystem.getInstance().findFileByPath(signature.getFile());
    }

    @Nullable
    private static VirtualFile getFile(@NotNull PyFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/debugger/PySignatureCacheManagerImpl", "getFile"));
        }
        PsiFile file = function.getContainingFile();
        return file != null ? file.getOriginalFile().getVirtualFile() : null;
    }

    @Override
    public void clearCache() {
        final Ref deleted = Ref.create((Object)false);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProjectFileIndex.SERVICE.getInstance((Project)PySignatureCacheManagerImpl.this.myProject).iterateContent(new ContentIterator(){

                    public boolean processFile(VirtualFile fileOrDir) {
                        if (PySignatureCacheManagerImpl.this.readAttribute(fileOrDir) != null) {
                            PySignatureCacheManagerImpl.this.writeAttribute(fileOrDir, "");
                            deleted.set((Object)true);
                        }
                        return !ProgressManager.getInstance().getProgressIndicator().isCanceled();
                    }
                });
            }
        }, "Cleaning the cache of dynamically collected types", true, this.myProject);
        String message = (Boolean)deleted.get() != false ? "Collected signatures were deleted" : "Nothing to delete";
        Messages.showInfoMessage((Project)this.myProject, (String)message, (String)"Delete Cache");
    }
}

