/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyRemoteDebugProcessAware;
import java.net.ServerSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteDebugProcess
extends PyDebugProcess {
    private final int myLocalPort;
    private final String mySettraceCall;

    public PyRemoteDebugProcess(@NotNull XDebugSession session, @NotNull ServerSocket serverSocket, @NotNull ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @Nullable String settraceCall) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/debugger/PyRemoteDebugProcess", "<init>"));
        }
        if (serverSocket == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverSocket", "com/jetbrains/python/debugger/PyRemoteDebugProcess", "<init>"));
        }
        if (executionConsole == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionConsole", "com/jetbrains/python/debugger/PyRemoteDebugProcess", "<init>"));
        }
        super(session, serverSocket, executionConsole, processHandler, false);
        if (processHandler instanceof PyRemoteDebugProcessAware) {
            ((PyRemoteDebugProcessAware)processHandler).setRemoteDebugProcess(this);
        }
        this.myLocalPort = serverSocket.getLocalPort();
        this.mySettraceCall = settraceCall;
    }

    @Override
    public void sessionInitialized() {
        super.sessionInitialized();
        this.printConsoleInfo();
    }

    protected void printConsoleInfo() {
        this.printToConsole("Starting debug server at port " + this.myLocalPort + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        this.printToConsole("Use the following code to connect to the debugger:\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        if (!StringUtil.isEmpty((String)this.mySettraceCall)) {
            this.printToConsole(this.mySettraceCall + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    @Override
    protected String getConnectionMessage() {
        return "Waiting for process connection...";
    }

    @Override
    protected String getConnectionTitle() {
        return "Waiting for connection";
    }

    @Override
    protected void detachDebuggedProcess() {
        this.waitForNextConnection();
    }

    @Override
    protected void beforeConnect() {
        this.printToConsole(this.getCurrentStateMessage() + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    @Override
    protected void afterConnect() {
    }

    public void waitForNextConnection() {
        if (this.isConnected()) {
            this.disconnect();
        }
        if (this.getSession().isSuspended()) {
            this.getSession().resume();
        }
        if (!this.isWaitingForConnection()) {
            this.setWaitingForConnection(true);
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    PyRemoteDebugProcess.this.waitForConnection(PyRemoteDebugProcess.this.getCurrentStateMessage(), PyRemoteDebugProcess.this.getConnectionTitle());
                }
            });
        }
    }

    @Override
    public int getConnectTimeout() {
        return 0;
    }
}

