/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySourcePosition;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLocalPositionConverter
implements PyPositionConverter {
    private static final String[] EGG_EXTENSIONS = new String[]{".egg", ".zip"};

    @NotNull
    public final PySourcePosition create(@NotNull String filePath, int line) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/jetbrains/python/debugger/PyLocalPositionConverter", "create"));
        }
        File file = new File(filePath);
        if (file.exists()) {
            PyLocalSourcePosition pyLocalSourcePosition = new PyLocalSourcePosition(file.getPath(), line);
            if (pyLocalSourcePosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyLocalPositionConverter", "create"));
            }
            return pyLocalSourcePosition;
        }
        PyRemoteSourcePosition pyRemoteSourcePosition = new PyRemoteSourcePosition(filePath, line);
        if (pyRemoteSourcePosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyLocalPositionConverter", "create"));
        }
        return pyRemoteSourcePosition;
    }

    @NotNull
    public final PySourcePosition convertToPython(@NotNull XSourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/python/debugger/PyLocalPositionConverter", "convertToPython"));
        }
        PySourcePosition pySourcePosition = this.convertToPython(PyLocalPositionConverter.convertFilePath(position.getFile().getPath()), PyLocalPositionConverter.convertLocalLineToRemote(position.getFile(), position.getLine()));
        if (pySourcePosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyLocalPositionConverter", "convertToPython"));
        }
        return pySourcePosition;
    }

    @NotNull
    protected PySourcePosition convertToPython(String filePath, int line) {
        PyLocalSourcePosition pyLocalSourcePosition = new PyLocalSourcePosition(filePath, line);
        if (pyLocalSourcePosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyLocalPositionConverter", "convertToPython"));
        }
        return pyLocalSourcePosition;
    }

    protected static int convertLocalLineToRemote(VirtualFile file, int line) {
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document != null) {
            while (PyDebugSupportUtils.isContinuationLine(document, line)) {
                ++line;
            }
        }
        return line + 1;
    }

    @Nullable
    public XSourcePosition convertFromPython(@NotNull PySourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/python/debugger/PyLocalPositionConverter", "convertFromPython"));
        }
        return PyLocalPositionConverter.createXSourcePosition(this.getVirtualFile(position.getFile()), position.getLine());
    }

    public PySignature convertSignature(PySignature signature) {
        return signature;
    }

    public VirtualFile getVirtualFile(String path) {
        VirtualFile vFile = this.getLocalFileSystem().findFileByPath(path);
        if (vFile == null) {
            vFile = this.findEggEntry(path);
        }
        return vFile;
    }

    protected VirtualFileSystem getLocalFileSystem() {
        return LocalFileSystem.getInstance();
    }

    private VirtualFile findEggEntry(String file) {
        String ext;
        int ind = -1;
        String[] arr$ = EGG_EXTENSIONS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (ind = file.indexOf(ext = arr$[i$])) == -1; ++i$) {
        }
        if (ind != -1) {
            String jarPath = file.substring(0, ind + 4);
            VirtualFile jarFile = this.getLocalFileSystem().findFileByPath(jarPath);
            if (jarFile != null) {
                String innerPath = file.substring(ind + 4);
                VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
                if (jarRoot != null) {
                    return jarRoot.findFileByRelativePath(innerPath);
                }
            }
        }
        return null;
    }

    private static String convertFilePath(String file) {
        String ext;
        int ind = -1;
        String[] arr$ = EGG_EXTENSIONS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (ind = file.indexOf((ext = arr$[i$]) + "!")) == -1; ++i$) {
        }
        if (ind != -1) {
            return file.substring(0, ind + 4) + file.substring(ind + 5);
        }
        return file;
    }

    @Nullable
    protected static XSourcePosition createXSourcePosition(@Nullable VirtualFile vFile, int line) {
        if (vFile != null) {
            return XDebuggerUtil.getInstance().createPosition(vFile, PyLocalPositionConverter.convertRemoteLineToLocal(vFile, line));
        }
        return null;
    }

    private static int convertRemoteLineToLocal(VirtualFile vFile, int line) {
        Document document = FileDocumentManager.getInstance().getDocument(vFile);
        --line;
        if (document != null) {
            while (PyDebugSupportUtils.isContinuationLine(document, line - 1)) {
                --line;
            }
        }
        return line;
    }

    protected static class PyRemoteSourcePosition
    extends PySourcePosition {
        public PyRemoteSourcePosition(String file, int line) {
            super(file, line);
        }

        protected String normalize(@Nullable String file) {
            if (file == null) {
                return null;
            }
            if (SystemInfo.isWindows && PyRemoteSourcePosition.isWindowsPath((String)file)) {
                file = file.toLowerCase();
            }
            return super.normalize(file);
        }
    }

    protected static class PyLocalSourcePosition
    extends PySourcePosition {
        public PyLocalSourcePosition(String file, int line) {
            super(file, line);
        }

        protected String normalize(@Nullable String file) {
            if (file == null) {
                return null;
            }
            if (SystemInfo.isWindows) {
                file = file.toLowerCase();
            }
            return super.normalize(file);
        }
    }
}

