/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpointTypeBase;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import org.jetbrains.annotations.NotNull;

public class PyLineBreakpointType
extends XLineBreakpointTypeBase {
    public static final String ID = "python-line";
    private static final String NAME = "Python Line Breakpoint";

    public PyLineBreakpointType() {
        super(ID, NAME, (XDebuggerEditorsProvider)new PyDebuggerEditorsProvider());
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/debugger/PyLineBreakpointType", "canPutAt"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/PyLineBreakpointType", "canPutAt"));
        }
        final Ref stoppable = Ref.create((Object)false);
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document != null && file.getFileType() == PythonFileType.INSTANCE) {
            XDebuggerUtil.getInstance().iterateLine(project, document, line, (Processor)new Processor<PsiElement>(){

                public boolean process(PsiElement psiElement) {
                    if (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment) {
                        return true;
                    }
                    if (psiElement.getNode() != null && PyLineBreakpointType.notStoppableElementType(psiElement.getNode().getElementType())) {
                        return true;
                    }
                    stoppable.set((Object)true);
                    return false;
                }
            });
            if (PyDebugSupportUtils.isContinuationLine(document, line - 1)) {
                stoppable.set((Object)false);
            }
        }
        return (Boolean)stoppable.get();
    }

    private static boolean notStoppableElementType(IElementType elementType) {
        return elementType == PyTokenTypes.TRIPLE_QUOTED_STRING || elementType == PyTokenTypes.SINGLE_QUOTED_STRING || elementType == PyTokenTypes.SINGLE_QUOTED_UNICODE || elementType == PyTokenTypes.DOCSTRING;
    }

    public String getBreakpointsDialogHelpTopic() {
        return "reference.dialogs.breakpoints";
    }
}

