/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.TreeChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.jetbrains.python.debugger.PyClassTreeChooserDialog;
import com.jetbrains.python.debugger.PyExceptionBreakpointProperties;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class PyExceptionBreakpointType
extends XBreakpointType<XBreakpoint<PyExceptionBreakpointProperties>, PyExceptionBreakpointProperties> {
    private static final String BASE_EXCEPTION = "BaseException";

    public PyExceptionBreakpointType() {
        super("python-exception", "Python Exception Breakpoint");
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyExceptionBreakpointType", "getEnabledIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_exception_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyExceptionBreakpointType", "getDisabledIcon"));
        }
        return icon;
    }

    public PyExceptionBreakpointProperties createProperties() {
        return new PyExceptionBreakpointProperties(BASE_EXCEPTION);
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    public XBreakpoint<PyExceptionBreakpointProperties> addBreakpoint(final Project project, JComponent parentComponent) {
        PyClassTreeChooserDialog dialog = new PyClassTreeChooserDialog("Select Exception Class", project, GlobalSearchScope.allScope((Project)project), new PyExceptionCachingFilter(), null);
        dialog.showDialog();
        PyClass pyClass = (PyClass)dialog.getSelected();
        if (pyClass != null) {
            final String qualifiedName = pyClass.getQualifiedName();
            assert (qualifiedName != null) : "Qualified name of the class shouldn't be null";
            return (XBreakpoint)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<XBreakpoint<PyExceptionBreakpointProperties>>(){

                public XBreakpoint<PyExceptionBreakpointProperties> compute() {
                    return XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)PyExceptionBreakpointType.this, (XBreakpointProperties)new PyExceptionBreakpointProperties(qualifiedName));
                }
            });
        }
        return null;
    }

    public String getBreakpointsDialogHelpTopic() {
        return "reference.dialogs.breakpoints";
    }

    public String getDisplayText(XBreakpoint<PyExceptionBreakpointProperties> breakpoint) {
        PyExceptionBreakpointProperties properties = (PyExceptionBreakpointProperties)breakpoint.getProperties();
        if (properties != null) {
            String exception = properties.getException();
            if (BASE_EXCEPTION.equals(exception)) {
                return "All exceptions";
            }
            return exception;
        }
        return "";
    }

    public XBreakpoint<PyExceptionBreakpointProperties> createDefaultBreakpoint(@NotNull XBreakpointType.XBreakpointCreator<PyExceptionBreakpointProperties> creator) {
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creator", "com/jetbrains/python/debugger/PyExceptionBreakpointType", "createDefaultBreakpoint"));
        }
        XBreakpoint breakpoint = creator.createBreakpoint((XBreakpointProperties)PyExceptionBreakpointType.createDefaultBreakpointProperties());
        breakpoint.setEnabled(true);
        return breakpoint;
    }

    private static PyExceptionBreakpointProperties createDefaultBreakpointProperties() {
        PyExceptionBreakpointProperties p = new PyExceptionBreakpointProperties(BASE_EXCEPTION);
        p.setNotifyOnTerminate(true);
        p.setNotifyAlways(false);
        p.setNotifyAlways(false);
        return p;
    }

    public XBreakpointCustomPropertiesPanel<XBreakpoint<PyExceptionBreakpointProperties>> createCustomPropertiesPanel() {
        return new PyExceptionBreakpointPropertiesPanel();
    }

    private static class PyExceptionBreakpointPropertiesPanel
    extends XBreakpointCustomPropertiesPanel<XBreakpoint<PyExceptionBreakpointProperties>> {
        private JCheckBox myNotifyOnTerminateCheckBox;
        private JCheckBox myNotifyOnRaiseCheckBox;
        private JRadioButton myAlwaysRadio;
        private JRadioButton myOnlyOnFirstRadio;

        private PyExceptionBreakpointPropertiesPanel() {
        }

        @NotNull
        public JComponent getComponent() {
            this.myNotifyOnTerminateCheckBox = new JCheckBox("On termination");
            this.myNotifyOnRaiseCheckBox = new JCheckBox("On raise");
            this.myAlwaysRadio = new JRadioButton("At each level of call chain");
            this.myOnlyOnFirstRadio = new JRadioButton("At top of call chain");
            ButtonGroup group = new ButtonGroup();
            group.add(this.myAlwaysRadio);
            group.add(this.myOnlyOnFirstRadio);
            Box notificationsBox = Box.createVerticalBox();
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.myNotifyOnTerminateCheckBox, "North");
            notificationsBox.add(panel);
            panel = new JPanel(new BorderLayout());
            panel.add((Component)this.myNotifyOnRaiseCheckBox, "North");
            notificationsBox.add(panel);
            panel = new JPanel(new BorderLayout());
            EmptyBorder border = new EmptyBorder(0, 20, 0, 0);
            panel.setBorder(border);
            panel.add((Component)this.myAlwaysRadio, "North");
            panel.add((Component)this.myOnlyOnFirstRadio, "Center");
            notificationsBox.add(panel);
            panel = new JPanel(new BorderLayout());
            JPanel innerPanel = new JPanel(new BorderLayout());
            innerPanel.add((Component)notificationsBox, "Center");
            innerPanel.add(Box.createHorizontalStrut(3), "West");
            innerPanel.add(Box.createHorizontalStrut(3), "East");
            panel.add((Component)innerPanel, "North");
            panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Activation policy", (boolean)true));
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PyExceptionBreakpointPropertiesPanel.this.setRadioButtonsEnabled();
                }
            };
            this.myNotifyOnRaiseCheckBox.addActionListener(listener);
            this.setRadioButtonsEnabled();
            JPanel jPanel = panel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyExceptionBreakpointType$PyExceptionBreakpointPropertiesPanel", "getComponent"));
            }
            return jPanel;
        }

        private void setRadioButtonsEnabled() {
            this.setRadioButtonsEnabled(this.myNotifyOnRaiseCheckBox.isSelected());
        }

        private void setNotifyOnRaiseSelected(boolean selected) {
            this.myNotifyOnRaiseCheckBox.setSelected(selected);
            this.setRadioButtonsEnabled(selected);
        }

        private void setRadioButtonsEnabled(boolean selected) {
            this.myAlwaysRadio.setEnabled(selected);
            this.myOnlyOnFirstRadio.setEnabled(selected);
            if (selected && !this.myAlwaysRadio.isSelected() && !this.myOnlyOnFirstRadio.isSelected()) {
                this.myAlwaysRadio.setSelected(true);
            }
        }

        public void saveTo(@NotNull XBreakpoint<PyExceptionBreakpointProperties> breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/python/debugger/PyExceptionBreakpointType$PyExceptionBreakpointPropertiesPanel", "saveTo"));
            }
            ((PyExceptionBreakpointProperties)breakpoint.getProperties()).setNotifyOnTerminate(this.myNotifyOnTerminateCheckBox.isSelected());
            ((PyExceptionBreakpointProperties)breakpoint.getProperties()).setNotifyAlways(this.myNotifyOnRaiseCheckBox.isSelected() && this.myAlwaysRadio.isSelected());
            ((PyExceptionBreakpointProperties)breakpoint.getProperties()).setNotifyOnlyOnFirst(this.myNotifyOnRaiseCheckBox.isSelected() && this.myOnlyOnFirstRadio.isSelected());
        }

        public void loadFrom(@NotNull XBreakpoint<PyExceptionBreakpointProperties> breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/python/debugger/PyExceptionBreakpointType$PyExceptionBreakpointPropertiesPanel", "loadFrom"));
            }
            this.myNotifyOnTerminateCheckBox.setSelected(((PyExceptionBreakpointProperties)breakpoint.getProperties()).isNotifyOnTerminate());
            boolean always = ((PyExceptionBreakpointProperties)breakpoint.getProperties()).isNotifyAlways();
            boolean onFirst = ((PyExceptionBreakpointProperties)breakpoint.getProperties()).isNotifyOnlyOnFirst();
            this.setNotifyOnRaiseSelected(always || onFirst);
            this.myAlwaysRadio.setSelected(always);
            this.myOnlyOnFirstRadio.setSelected(onFirst);
        }
    }

    private static class PyExceptionCachingFilter
    implements TreeChooser.Filter<PyClass> {
        private final HashMap<Integer, Pair<WeakReference<PyClass>, Boolean>> processedElements = Maps.newHashMap();

        private PyExceptionCachingFilter() {
        }

        public boolean isAccepted(final @NotNull PyClass pyClass) {
            boolean isException;
            if (pyClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/debugger/PyExceptionBreakpointType$PyExceptionCachingFilter", "isAccepted"));
            }
            VirtualFile virtualFile = pyClass.getContainingFile().getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            int key = pyClass.hashCode();
            Pair<WeakReference<PyClass>, Boolean> pair = this.processedElements.get(key);
            if (pair == null || ((WeakReference)pair.first).get() != pyClass) {
                isException = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        return PyUtil.isExceptionClass(pyClass);
                    }
                });
                this.processedElements.put(key, (Pair<WeakReference<PyClass>, Boolean>)Pair.create(new WeakReference<PyClass>(pyClass), (Object)isException));
            } else {
                isException = (Boolean)pair.second;
            }
            return isException;
        }
    }
}

