/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.util.xmlb.annotations.Attribute;
import com.jetbrains.python.debugger.ExceptionBreakpointProperties;
import com.jetbrains.python.debugger.pydev.AddExceptionBreakpointCommand;
import com.jetbrains.python.debugger.pydev.ExceptionBreakpointCommand;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import org.jetbrains.annotations.NotNull;

public class PyExceptionBreakpointProperties
extends ExceptionBreakpointProperties<PyExceptionBreakpointProperties> {
    @Attribute(value="notifyAlways")
    public boolean myNotifyAlways;
    @Attribute(value="notifyOnlyOnFirst")
    public boolean myNotifyOnlyOnFirst;
    @Attribute(value="notifyOnTerminate")
    public boolean myNotifyOnTerminate;

    public PyExceptionBreakpointProperties() {
    }

    public PyExceptionBreakpointProperties(@NotNull String exception) {
        if (exception == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "com/jetbrains/python/debugger/PyExceptionBreakpointProperties", "<init>"));
        }
        this.myException = exception;
        this.myNotifyOnTerminate = true;
    }

    public PyExceptionBreakpointProperties getState() {
        return this;
    }

    public void loadState(PyExceptionBreakpointProperties state2) {
        this.myException = state2.myException;
        this.myNotifyAlways = state2.myNotifyAlways;
        this.myNotifyOnlyOnFirst = state2.myNotifyOnlyOnFirst;
        this.myNotifyOnTerminate = state2.myNotifyOnTerminate;
    }

    public boolean isNotifyOnTerminate() {
        return this.myNotifyOnTerminate;
    }

    public void setNotifyOnTerminate(boolean notifyOnTerminate) {
        this.myNotifyOnTerminate = notifyOnTerminate;
    }

    public boolean isNotifyAlways() {
        return this.myNotifyAlways;
    }

    public void setNotifyAlways(boolean notifyAlways) {
        this.myNotifyAlways = notifyAlways;
    }

    public boolean isNotifyOnlyOnFirst() {
        return this.myNotifyOnlyOnFirst;
    }

    public void setNotifyOnlyOnFirst(boolean notifyOnlyOnFirst) {
        this.myNotifyOnlyOnFirst = notifyOnlyOnFirst;
    }

    @Override
    public String getExceptionBreakpointId() {
        return "python-" + this.myException;
    }

    public ExceptionBreakpointCommand createAddCommand(RemoteDebugger debugger) {
        return ExceptionBreakpointCommand.addExceptionBreakpointCommand((RemoteDebugger)debugger, (String)this.getExceptionBreakpointId(), (AddExceptionBreakpointCommand.ExceptionBreakpointNotifyPolicy)new AddExceptionBreakpointCommand.ExceptionBreakpointNotifyPolicy(this.isNotifyAlways(), this.isNotifyOnTerminate(), this.isNotifyOnlyOnFirst()));
    }

    public ExceptionBreakpointCommand createRemoveCommand(RemoteDebugger debugger) {
        return ExceptionBreakpointCommand.removeExceptionBreakpointCommand((RemoteDebugger)debugger, (String)this.getExceptionBreakpointId());
    }
}

