/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.jetbrains.python.console.PyConsoleIndentUtil;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebuggerEvaluator
extends XDebuggerEvaluator {
    private static final PyDebugValue NONE = new PyDebugValue("", "NoneType", "None", false, false, null, null);
    private Project myProject;
    private final PyFrameAccessor myDebugProcess;

    public PyDebuggerEvaluator(@NotNull Project project, @NotNull PyFrameAccessor debugProcess) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/PyDebuggerEvaluator", "<init>"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/python/debugger/PyDebuggerEvaluator", "<init>"));
        }
        this.myProject = project;
        this.myDebugProcess = debugProcess;
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/debugger/PyDebuggerEvaluator", "evaluate"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/python/debugger/PyDebuggerEvaluator", "evaluate"));
        }
        this.doEvaluate(expression, callback, true);
    }

    private void doEvaluate(final String expr, final XDebuggerEvaluator.XEvaluationCallback callback, final boolean doTrunc) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                String expression = expr.trim();
                if (expression.isEmpty()) {
                    callback.evaluated((XValue)NONE);
                    return;
                }
                boolean isExpression = PyDebugSupportUtils.isExpression(PyDebuggerEvaluator.this.myProject, expression);
                try {
                    PyDebugValue value = PyDebuggerEvaluator.this.myDebugProcess.evaluate(expression, !isExpression, doTrunc);
                    if (value.isErrorOnEval()) {
                        callback.errorOccurred("{" + value.getType() + "}" + value.getValue());
                    } else {
                        callback.evaluated((XValue)value);
                    }
                }
                catch (PyDebuggerException e) {
                    callback.errorOccurred(e.getTracebackError());
                }
            }
        });
    }

    @Nullable
    public TextRange getExpressionRangeAtOffset(Project project, Document document, int offset, boolean sideEffectsAllowed) {
        return PyDebugSupportUtils.getExpressionRangeAtOffset(project, document, offset);
    }

    @NotNull
    public String formatTextForEvaluation(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/debugger/PyDebuggerEvaluator", "formatTextForEvaluation"));
        }
        String string = PyConsoleIndentUtil.normalize(text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyDebuggerEvaluator", "formatTextForEvaluation"));
        }
        return string;
    }
}

