/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.impl.PyExpressionCodeFragmentImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebuggerEditorsProvider
extends XDebuggerEditorsProvider {
    @NotNull
    public FileType getFileType() {
        PythonFileType pythonFileType = PythonFileType.INSTANCE;
        if (pythonFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyDebuggerEditorsProvider", "getFileType"));
        }
        return pythonFileType;
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull String text, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/PyDebuggerEditorsProvider", "createDocument"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/debugger/PyDebuggerEditorsProvider", "createDocument"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/jetbrains/python/debugger/PyDebuggerEditorsProvider", "createDocument"));
        }
        text = text.trim();
        PyExpressionCodeFragmentImpl fragment = new PyExpressionCodeFragmentImpl(project, "fragment.py", text, true);
        PsiElement element = PyDebuggerEditorsProvider.getContextElement(project, sourcePosition);
        fragment.setContext(element);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyDebuggerEditorsProvider", "createDocument"));
        }
        return document;
    }

    @Nullable
    @VisibleForTesting
    public static PsiElement getContextElement(Project project, XSourcePosition sourcePosition) {
        if (sourcePosition != null) {
            int offset;
            Document document = FileDocumentManager.getInstance().getDocument(sourcePosition.getFile());
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile != null && (offset = sourcePosition.getOffset()) >= 0 && offset < document.getTextLength()) {
                PsiElement element;
                int lineEndOffset = document.getLineEndOffset(document.getLineNumber(offset));
                do {
                    if ((element = psiFile.findElementAt(offset)) == null || element instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
                    return PyPsiUtils.getStatement(element);
                } while ((offset = element.getTextRange().getEndOffset()) < lineEndOffset);
            }
        }
        return null;
    }
}

