/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class PyDebuggerConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final PyDebuggerOptionsProvider mySettings;
    private JPanel myMainPanel;
    private JCheckBox myAttachToSubprocess;
    private JCheckBox mySaveSignatures;
    private JButton myClearCacheButton;
    private JCheckBox mySupportGevent;
    private final Project myProject;

    public PyDebuggerConfigurable(Project project, PyDebuggerOptionsProvider settings) {
        this.myProject = project;
        this.mySettings = settings;
        this.$$$setupUI$$$();
    }

    public String getDisplayName() {
        return "Python Debugger";
    }

    public String getHelpTopic() {
        return "reference.idesettings.debugger.python";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyDebuggerConfigurable", "getId"));
        }
        return string;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        this.myClearCacheButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PySignatureCacheManager.getInstance(PyDebuggerConfigurable.this.myProject).clearCache();
            }
        });
        return this.myMainPanel;
    }

    public boolean isModified() {
        return this.myAttachToSubprocess.isSelected() != this.mySettings.isAttachToSubprocess() || this.mySaveSignatures.isSelected() != this.mySettings.isSaveCallSignatures() || this.mySupportGevent.isSelected() != this.mySettings.isSupportGeventDebugging();
    }

    public void apply() throws ConfigurationException {
        this.mySettings.setAttachToSubprocess(this.myAttachToSubprocess.isSelected());
        this.mySettings.setSaveCallSignatures(this.mySaveSignatures.isSelected());
        this.mySettings.setSupportGeventDebugging(this.mySupportGevent.isSelected());
    }

    public void reset() {
        this.myAttachToSubprocess.setSelected(this.mySettings.isAttachToSubprocess());
        this.mySaveSignatures.setSelected(this.mySettings.isSaveCallSignatures());
        this.mySupportGevent.setSelected(this.mySettings.isSupportGeventDebugging());
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JButton jButton;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAttachToSubprocess = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Attach to subprocess automatically while debugging");
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        this.mySaveSignatures = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Collect run-time types information for code insight ");
        jCheckBox2.setActionCommand("Save call signatures");
        jCheckBox2.setLabel("Collect run-time types information for code insight ");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myClearCacheButton = jButton = new JButton();
        jButton.setText("Clear caches");
        jPanel2.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySupportGevent = jCheckBox = new JCheckBox();
        jCheckBox.setText("Gevent compatible debugging");
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

