/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySliceExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebugSupportUtils {
    private PyDebugSupportUtils() {
    }

    public static boolean isExpression(final Project project, final String expression) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                PsiFile file = PyElementGenerator.getInstance(project).createDummyFile(LanguageLevel.getDefault(), expression);
                return file.getFirstChild() instanceof PyExpressionStatement && file.getFirstChild() == file.getLastChild();
            }
        });
    }

    @Nullable
    public static TextRange getExpressionRangeAtOffset(final Project project, final Document document, final int offset) {
        return (TextRange)ApplicationManager.getApplication().runReadAction((Computable)new Computable<TextRange>(){

            @Nullable
            public TextRange compute() {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                if (psiFile != null) {
                    PsiElement element = psiFile.findElementAt(offset);
                    if (!(element instanceof PyExpression) || element instanceof PyLiteralExpression) {
                        element = PsiTreeUtil.getParentOfType((PsiElement)element, PyExpression.class);
                    }
                    if (element != null && element instanceof PyLiteralExpression) {
                        return null;
                    }
                    if (element != null && PyDebugSupportUtils.isSimpleEnough(element) && PyDebugSupportUtils.isExpression(project, document.getText(element.getTextRange()))) {
                        return element.getTextRange();
                    }
                }
                return null;
            }
        });
    }

    private static boolean isSimpleEnough(PsiElement element) {
        return element instanceof PyLiteralExpression || element instanceof PyQualifiedExpression || element instanceof PyBinaryExpression || element instanceof PyPrefixExpression || element instanceof PySliceExpression || element instanceof PyNamedParameter;
    }

    public static boolean canSaveToTemp(final Project project, final String expression) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                PsiFile file = PyElementGenerator.getInstance(project).createDummyFile(LanguageLevel.getDefault(), expression);
                PsiElement root = file.getFirstChild();
                return PyDebugSupportUtils.isVariable(root) == false && root instanceof PyExpressionStatement;
            }
        });
    }

    private static Boolean isVariable(PsiElement root) {
        return root instanceof PyExpressionStatement && root.getFirstChild() instanceof PyReferenceExpression && root.getFirstChild() == root.getLastChild() && root.getFirstChild().getFirstChild() != null && root.getFirstChild().getFirstChild().getNode().getElementType() == PyTokenTypes.IDENTIFIER && root.getFirstChild().getFirstChild() == root.getFirstChild().getLastChild() && root.getFirstChild().getFirstChild().getFirstChild() == null;
    }

    @Nullable
    private static String getLineText(@NotNull Document document, int line) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/python/debugger/PyDebugSupportUtils", "getLineText"));
        }
        if (line > 0 && line < document.getLineCount()) {
            return document.getText(TextRange.create((int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line)));
        }
        return null;
    }

    public static boolean isContinuationLine(@NotNull Document document, int line) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/python/debugger/PyDebugSupportUtils", "isContinuationLine"));
        }
        String text = PyDebugSupportUtils.getLineText(document, line);
        return text != null && text.trim().endsWith("\\");
    }
}

